/*
 * Decompiled with CFR 0.152.
 */
package com.geolang.ascema.managerservice.servicediscovery;

import com.geolang.ascema.managercore.settings.SettingsFile;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.logging.Level;
import java.util.logging.Logger;

public class UdpSD {
    private DatagramSocket socket;
    private static final Logger LOG = Logger.getLogger(UdpSD.class.getName());
    private final ExecutorService executor = Executors.newSingleThreadExecutor();
    private boolean stop = false;
    private final int port = SettingsFile.getInstance().getUDPDiscoveryPort();

    public UdpSD() {
        this.executor.submit(() -> this.run());
    }

    public void stop() {
        this.stop = true;
        try {
            this.socket.close();
        }
        catch (Throwable t) {
            LOG.info(t.getMessage());
        }
        this.executor.shutdownNow();
    }

    private void run() {
        try {
            this.socket = new DatagramSocket(this.port, InetAddress.getByName("0.0.0.0"));
            this.socket.setBroadcast(true);
            byte[] sendData = "ascemajmdnsRESPONSE".getBytes();
            int length = sendData.length;
            while (!this.stop) {
                String message;
                byte[] recvBuf = new byte[15000];
                DatagramPacket packet = new DatagramPacket(recvBuf, recvBuf.length);
                this.socket.receive(packet);
                if (this.stop || !(message = new String(packet.getData()).trim()).equals("ascemajmdns")) continue;
                DatagramPacket sendPacket = new DatagramPacket(sendData, length, packet.getAddress(), packet.getPort());
                this.socket.send(sendPacket);
                LOG.log(Level.INFO, "UDP Respond to: {0}", sendPacket.getAddress().getHostAddress());
            }
        }
        catch (IOException ex) {
            LOG.log(Level.WARNING, null, ex);
        }
    }
}

