/*
 * Decompiled with CFR 0.152.
 */
package com.geolang.ascema.managerservice.servicediscovery;

import com.geolang.ascema.managercore.settings.SettingsFile;
import com.geolang.ascema.managerservice.servicediscovery.UdpSD;
import java.io.IOException;
import java.net.UnknownHostException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jmdns.JmDNS;
import javax.jmdns.ServiceInfo;

public class JMDNSServer {
    private static final Logger LOG = Logger.getLogger(JMDNSServer.class.getName());
    private JmDNS jmdns = null;
    private UdpSD udpFallback = null;
    private ExecutorService background = null;

    public JMDNSServer() {
        try {
            this.jmdns = JmDNS.create();
            this.udpFallback = new UdpSD();
            int port = SettingsFile.getInstance().getJMSDNPort();
            LOG.log(Level.INFO, "Inet addr {0}", this.jmdns.getInetAddress());
            ServiceInfo serviceInfo = ServiceInfo.create((String)"_http._tcp.local.", (String)"ascemajmdns", (int)port, (String)"ascemaendpointagent-dns");
            this.background = Executors.newSingleThreadExecutor();
            this.background.submit(() -> {
                try {
                    LOG.info("Register JMDNS..");
                    this.jmdns.registerService(serviceInfo);
                    LOG.info("Registered JMDNS");
                }
                catch (IOException ex) {
                    Logger.getLogger(JMDNSServer.class.getName()).log(Level.SEVERE, null, ex);
                }
            });
        }
        catch (UnknownHostException ex) {
            LOG.log(Level.SEVERE, ex.getMessage());
        }
        catch (IOException ex) {
            LOG.log(Level.SEVERE, ex.getMessage());
        }
    }

    public void destroy() {
        LOG.info("Closing JMDNS..");
        if (this.background != null) {
            this.background.shutdownNow();
            this.background = null;
        }
        if (this.udpFallback != null) {
            this.udpFallback.stop();
            this.udpFallback = null;
        }
        if (this.jmdns != null) {
            try {
                this.jmdns.unregisterAllServices();
                this.jmdns.close();
            }
            catch (IOException ex) {
                Logger.getLogger(JMDNSServer.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        LOG.info("JMDNS Closed");
    }
}

