/*
 * Decompiled with CFR 0.152.
 */
package com.geolang.ascema.managerservice.rest.security.ad;

import com.geolang.ascema.managercore.settings.SettingsFile;
import com.geolang.ascema.managerservice.rest.security.ad.DummyTrustManager;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.SocketFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;

public class LdapSSLSocketFactory
extends SSLSocketFactory {
    private static final Logger LOG = Logger.getLogger(LdapSSLSocketFactory.class.getName());
    private SSLSocketFactory socketFactory;
    private static final AtomicReference<LdapSSLSocketFactory> defaultFactory = new AtomicReference();

    public LdapSSLSocketFactory() {
        try {
            SettingsFile settings = SettingsFile.getInstance();
            boolean allowSelfSigned = settings.getLDAPAllowSelfSigned();
            if (allowSelfSigned) {
                SSLContext ctx = SSLContext.getInstance("TLS");
                ctx.init(null, new TrustManager[]{new DummyTrustManager()}, new SecureRandom());
                this.socketFactory = ctx.getSocketFactory();
            } else {
                KeyStore keyStore = KeyStore.getInstance("JKS");
                LOG.info(System.getProperties().getProperty("java.home"));
                keyStore.load(new FileInputStream(System.getProperties().getProperty("java.home") + File.separator + "lib" + File.separator + "security" + File.separator + "cacerts"), "changeit".toCharArray());
                TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
                tmf.init(keyStore);
                SSLContext ctx = SSLContext.getInstance("TLS");
                ctx.init(null, tmf.getTrustManagers(), new SecureRandom());
                ctx.init(null, new TrustManager[]{new DummyTrustManager()}, new SecureRandom());
                this.socketFactory = ctx.getSocketFactory();
            }
        }
        catch (KeyManagementException | NoSuchAlgorithmException ex) {
            LOG.severe(ex.getMessage());
        }
        catch (IOException | KeyStoreException | CertificateException ex) {
            Logger.getLogger(LdapSSLSocketFactory.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public static SocketFactory getDefault() {
        LdapSSLSocketFactory value = (LdapSSLSocketFactory)defaultFactory.get();
        if (value == null) {
            defaultFactory.compareAndSet(null, new LdapSSLSocketFactory());
            return (SocketFactory)defaultFactory.get();
        }
        return value;
    }

    @Override
    public String[] getDefaultCipherSuites() {
        return this.socketFactory.getDefaultCipherSuites();
    }

    @Override
    public String[] getSupportedCipherSuites() {
        return this.socketFactory.getSupportedCipherSuites();
    }

    @Override
    public Socket createSocket(Socket socket, String string, int i, boolean bln) throws IOException {
        return this.socketFactory.createSocket(socket, string, i, bln);
    }

    @Override
    public Socket createSocket(String string, int i) throws IOException, UnknownHostException {
        return this.socketFactory.createSocket(string, i);
    }

    @Override
    public Socket createSocket(String string, int i, InetAddress ia, int i1) throws IOException, UnknownHostException {
        return this.socketFactory.createSocket(string, i, ia, i1);
    }

    @Override
    public Socket createSocket(InetAddress ia, int i) throws IOException {
        return this.socketFactory.createSocket(ia, i);
    }

    @Override
    public Socket createSocket(InetAddress ia, int i, InetAddress ia1, int i1) throws IOException {
        return this.socketFactory.createSocket(ia, i, ia1, i1);
    }

    @Override
    public Socket createSocket() throws IOException {
        return this.socketFactory.createSocket();
    }
}

