/*
 * Decompiled with CFR 0.152.
 */
package com.geolang.ascema.managerservice.rest.security.ad;

import com.geolang.ascema.managercore.settings.WorkingFolder;
import com.geolang.ascema.managerservice.rest.security.ad.LDAPConfig;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileTime;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public class LdapCredentialsLoader {
    private static final Logger LOG = Logger.getLogger(LdapCredentialsLoader.class.getName());
    private static final String OVERRIDE_CONFIG = "ldap.txt";
    private static final String PRIM_DOMAIN = "DOMAIN1";
    private static final String SEC_DOMAIN = "DOMAIN2";
    private static final String PRIMARY_URL = "URL1";
    private static final String SECONDARY_URL = "URL2";
    private static final String USER_DN_PATTERN = "USER_DN_PATTERN";
    private static final String GROUP_ATTRIBUTE = "GROUP_ATTRIBUTE";
    private static final String AUDIT_GROUPS = "AUDIT_GROUPS";
    private static final String ADMIN_GROUPS = "ADMIN_GROUPS";
    private static final String BASIC_GROUPS = "BASIC_GROUPS";
    private static final String CREATE_LOCAL_DISABLED = "CREATE_LOCAL_USERS_DISABLED";
    private static final String ALLOW_SELF_SIGNED = "ALLOW_SELF_SIGNED";

    public static void updateFromConfig() {
        block7: {
            LDAPConfig config = new LDAPConfig();
            File folder = new File(WorkingFolder.getWorkingFolder());
            Path p = folder.toPath();
            Path tryOne = Paths.get(p.toString(), "ldap.txt");
            if (Files.exists(tryOne, new LinkOption[0])) {
                LOG.info("read ldap template");
                try {
                    BasicFileAttributes attr = Files.readAttributes(tryOne, BasicFileAttributes.class, new LinkOption[0]);
                    FileTime ft = attr.lastModifiedTime();
                    long millis = ft.toMillis();
                    if (millis > config.getLastModifiedMillis()) {
                        LOG.info("ldap.txt is later than settings last modified");
                        LdapCredentialsLoader.loadDefaultsFromFile((Path)tryOne, (LDAPConfig)config);
                        if (config.hasEnoughDetails()) {
                            LOG.info("Updating ldap config");
                            LDAPConfig.update((LDAPConfig)config);
                        } else {
                            LOG.info("Not enough info to set ldap");
                        }
                        break block7;
                    }
                    LOG.info("ldap template is not new");
                }
                catch (IOException ex) {
                    Logger.getLogger(LdapCredentialsLoader.class.getName()).log(Level.SEVERE, null, ex);
                }
            } else {
                LdapCredentialsLoader.copyFile();
            }
        }
    }

    private static void copyFile() {
        try {
            LOG.info("Copy template ldap file");
            URL inputUrl = LdapCredentialsLoader.class.getResource("/ldap.txt");
            File dest = new File(WorkingFolder.getWorkingFolder() + File.separator + "ldap.txt");
            FileUtils.copyURLToFile((URL)inputUrl, (File)dest);
        }
        catch (IOException ex) {
            Logger.getLogger(LdapCredentialsLoader.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void loadDefaultsFromFile(Path configFile, LDAPConfig config) {
        LOG.log(Level.INFO, "init ldap credentials from config file? {0}", configFile);
        BufferedReader reader = null;
        try {
            boolean b;
            Properties props = new Properties();
            reader = new BufferedReader(new FileReader(configFile.toFile()));
            props.load(reader);
            String p = props.getProperty("URL1");
            if (p == null || p.isBlank()) {
                LOG.log(Level.INFO, "required ldap setting PRIMARY_URL not set in ldap.txt, ignoring config file");
                return;
            }
            config.setUrlPrimary(p);
            LOG.log(Level.INFO, "set ldap url {0}", StringUtils.truncate((String)p, (int)1) + "...");
            boolean aGroupSet = false;
            p = props.getProperty("DOMAIN1");
            if (p == null || p.isBlank()) {
                LOG.log(Level.INFO, "required ldap setting DOMAIN not set in ldap.txt, ignoring config file");
                return;
            }
            config.setDomainPrimary(p);
            LOG.log(Level.INFO, "set ldap domain {0}", StringUtils.truncate((String)p, (int)1) + "...");
            p = props.getProperty("AUDIT_GROUPS");
            if (p != null && !p.isBlank()) {
                config.setAuditGroupsStr(p);
                LOG.log(Level.INFO, "set ldap audit groups {0}", StringUtils.truncate((String)p, (int)1) + "...");
                aGroupSet = true;
            } else {
                LOG.log(Level.INFO, "no audit groups configured");
            }
            p = props.getProperty("ADMIN_GROUPS");
            if (p != null && !p.isBlank()) {
                config.setAdminGroupsStr(p);
                LOG.log(Level.INFO, "set ldap admin groups {0}", StringUtils.truncate((String)p, (int)1) + "...");
                aGroupSet = true;
            } else {
                LOG.log(Level.INFO, "no admin groups configured");
            }
            p = props.getProperty("BASIC_GROUPS");
            if (p != null && !p.isBlank()) {
                config.setBasicGroupsStr(p);
                LOG.log(Level.INFO, "set ldap basic groups {0}", StringUtils.truncate((String)p, (int)1) + "...");
                aGroupSet = true;
            } else {
                LOG.log(Level.INFO, "no basic groups configured");
            }
            if (!aGroupSet) {
                LOG.info("No groups configured, so no logins will have a role, ignoring config file");
                return;
            }
            config.setEnabled(true);
            p = props.getProperty("URL2");
            if (p != null && !p.isBlank()) {
                config.setUrlSecondary(p);
                LOG.log(Level.INFO, "set ldap secondary url {0}", StringUtils.truncate((String)p, (int)1) + "...");
            } else {
                LOG.log(Level.INFO, "no secondary url configured");
            }
            p = props.getProperty("DOMAIN2");
            if (p != null && !p.isBlank()) {
                config.setDomainSecondary(p);
                LOG.log(Level.INFO, "set ldap secondary domain {0}", StringUtils.truncate((String)p, (int)1) + "...");
            } else {
                LOG.log(Level.INFO, "no secondary domain configured");
            }
            p = props.getProperty("USER_DN_PATTERN");
            if (p != null && !p.isBlank()) {
                config.setUserDnPattern(p);
                LOG.log(Level.INFO, "set ldap user dn pattern {0}", StringUtils.truncate((String)p, (int)1) + "...");
            } else {
                LOG.log(Level.INFO, "use default user dn pattern");
            }
            p = props.getProperty("GROUP_ATTRIBUTE");
            if (p != null && !p.isBlank()) {
                config.setGroupAttribute(p);
                LOG.log(Level.INFO, "set ldap group attribute {0}", StringUtils.truncate((String)p, (int)1) + "...");
            } else {
                LOG.log(Level.INFO, "use default group attribute");
            }
            p = props.getProperty("CREATE_LOCAL_USERS_DISABLED");
            if (p != null && !p.isBlank()) {
                b = "true".equalsIgnoreCase(p);
                config.setCreateLocalUsersDisabled(b);
                LOG.log(Level.INFO, "local users disabled is {0}", b);
            } else {
                LOG.log(Level.INFO, "use default local users disabled {0}", config.isCreateLocalUsersDisabled());
            }
            p = props.getProperty("ALLOW_SELF_SIGNED");
            if (p != null && !p.isBlank()) {
                b = "true".equalsIgnoreCase(p);
                config.setAllowSelfSignedldaps(b);
                LOG.log(Level.INFO, "allow self signed is {0}", b);
            } else {
                LOG.log(Level.INFO, "use default local users disabled {0}", config.isCreateLocalUsersDisabled());
            }
        }
        catch (FileNotFoundException ex) {
            Logger.getLogger(LdapCredentialsLoader.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IOException ex) {
            Logger.getLogger(LdapCredentialsLoader.class.getName()).log(Level.SEVERE, null, ex);
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (IOException ex) {
                Logger.getLogger(LdapCredentialsLoader.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }
}

