/*
 * Decompiled with CFR 0.152.
 */
package com.geolang.ascema.managerservice.rest.security.ad;

import com.geolang.ascema.managercore.settings.SettingsFile;
import com.geolang.ascema.managerdomain.web.WebLDAPConfig;
import com.geolang.ascema.managerservice.rest.security.ad.UrlAndDomain;
import java.io.Serializable;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

/*
 * Exception performing whole class analysis ignored.
 */
public class LDAPConfig
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final String DUMMY_PWD = "dummypwd";
    private static final String DEFAULT_SEARCH_FILTER = "(&(objectClass=user)(sAMAccountName={0}))";
    private static final String DEFAULT_GROUP_ATTR = "memberOf";
    private boolean enabled;
    private String domainPrimary;
    private String domainSecondary;
    private String urlPrimary;
    private String urlSecondary;
    private String userDnPattern;
    private String groupAttribute;
    private List<String> auditGroups;
    private List<String> adminGroups;
    private List<String> basicGroups;
    private boolean allowSelfSignedldaps;
    private boolean createLocalUsersDisabled;
    private final long lastModifiedMillis;
    private final boolean ldapEnabledForIndividualReports;
    private final boolean ignoreLdapFailuresForIndividualReports;

    public LDAPConfig() {
        SettingsFile settings = SettingsFile.getInstance();
        this.enabled = settings.getLDAPEnabled();
        this.domainPrimary = settings.getLDAPDomainPrimary();
        this.domainSecondary = settings.getLDAPDomainSecondary();
        this.urlPrimary = settings.getLDAPPrimaryUrl();
        this.urlSecondary = settings.getLDAPSecondaryUrl();
        this.userDnPattern = settings.getLDAPUserDnPattern();
        if (this.userDnPattern.isEmpty()) {
            this.userDnPattern = "(&(objectClass=user)(sAMAccountName={0}))";
        }
        this.groupAttribute = settings.getLDAPGroupAttribute();
        if (this.groupAttribute.isEmpty()) {
            this.groupAttribute = "memberOf";
        }
        this.createLocalUsersDisabled = settings.getLDAPDisableLocalUsers();
        this.allowSelfSignedldaps = settings.getLDAPAllowSelfSigned();
        this.auditGroups = LDAPConfig.groupStringToList((String)settings.getLDAPAuditGroups());
        this.adminGroups = LDAPConfig.groupStringToList((String)settings.getLDAPAdminGroups());
        this.basicGroups = LDAPConfig.groupStringToList((String)settings.getLDAPBasicGroups());
        this.ldapEnabledForIndividualReports = settings.getLDAPEnabledForIndividualReports();
        this.ignoreLdapFailuresForIndividualReports = settings.getIgnoreLDAPFailureForIndividualReports();
        this.lastModifiedMillis = settings.getLDAPLastSaved();
    }

    public WebLDAPConfig toWebLdapConfig() {
        WebLDAPConfig ret = new WebLDAPConfig();
        ret.setAdminGroups(this.adminGroups);
        ret.setAuditGroups(this.auditGroups);
        ret.setBasicGroups(this.basicGroups);
        ret.setCreateLocalUsersDisabled(this.createLocalUsersDisabled);
        ret.setDomainPrimary(this.domainPrimary);
        ret.setDomainSecondary(this.domainSecondary);
        ret.setEnabled(this.enabled);
        ret.setGroupAttribute(this.getGroupAttribute());
        ret.setUrlPrimary(this.urlPrimary);
        ret.setUrlSecondary(this.urlSecondary);
        ret.setUserDnPattern(this.getSearchFilterOrDefault());
        ret.setAllowSelfSigned(this.allowSelfSignedldaps);
        ret.setLdapEnabledForIndividualReports(this.ldapEnabledForIndividualReports);
        ret.setIgnoreLdapFailuresForIndividualReports(this.ignoreLdapFailuresForIndividualReports);
        return ret;
    }

    public static void update(LDAPConfig config) {
        SettingsFile settings = SettingsFile.getInstance();
        String dom = config.domainPrimary.toLowerCase();
        settings.setLDAPDomainPrimary(dom);
        dom = config.domainSecondary.toLowerCase();
        settings.setLDAPDomainSecondary(dom);
        settings.setLDAPPrimaryUrl(config.urlPrimary);
        settings.setLDAPSecondaryUrl(config.urlSecondary);
        settings.setLDAPGroupAttribute(config.groupAttribute);
        settings.setLDAPAuditGroups(LDAPConfig.groupsToString((List)config.auditGroups));
        settings.setLDAPAdminGroups(LDAPConfig.groupsToString((List)config.adminGroups));
        settings.setLDAPBasicGroups(LDAPConfig.groupsToString((List)config.basicGroups));
        settings.setLDAPUserDnPattern(config.userDnPattern);
        settings.setLDAPEnabled(config.enabled);
        settings.setLDAPEnabledForIndividualReports(config.ldapEnabledForIndividualReports);
        settings.setIgnoreLDAPFailureForIndividualReports(config.isIgnoreLdapFailuresForIndividualReports());
        settings.setLDAPDisableLocalUsers(config.createLocalUsersDisabled);
        settings.setLDAPAllowSelfSigned(config.allowSelfSignedldaps);
        settings.setLDAPLastSaved(Long.valueOf(Instant.now().toEpochMilli()));
    }

    public static LDAPConfig update(WebLDAPConfig config) {
        SettingsFile settings = SettingsFile.getInstance();
        String dom = config.getDomainPrimary().toLowerCase();
        settings.setLDAPDomainPrimary(dom);
        dom = config.getDomainSecondary().toLowerCase();
        settings.setLDAPDomainSecondary(dom);
        settings.setLDAPPrimaryUrl(config.getUrlPrimary());
        settings.setLDAPSecondaryUrl(config.getUrlSecondary());
        if (!config.getGroupAttribute().isEmpty()) {
            settings.setLDAPGroupAttribute(config.getGroupAttribute());
        }
        settings.setLDAPAuditGroups(LDAPConfig.groupsToString((List)config.getAuditGroups()));
        settings.setLDAPAdminGroups(LDAPConfig.groupsToString((List)config.getAdminGroups()));
        settings.setLDAPBasicGroups(LDAPConfig.groupsToString((List)config.getBasicGroups()));
        if (!config.getUserDnPattern().isEmpty()) {
            settings.setLDAPUserDnPattern(config.getUserDnPattern());
        }
        settings.setLDAPEnabled(config.isEnabled());
        settings.setLDAPEnabledForIndividualReports(config.isLdapEnabledForIndividualReports());
        settings.setIgnoreLDAPFailureForIndividualReports(config.isIgnoreLdapFailuresForIndividualReports());
        settings.setLDAPDisableLocalUsers(config.isCreateLocalUsersDisabled());
        settings.setLDAPAllowSelfSigned(config.isAllowSelfSigned());
        settings.setLDAPLastSaved(Long.valueOf(Instant.now().toEpochMilli()));
        return new LDAPConfig();
    }

    public boolean hasEnoughDetails() {
        boolean hasPrim = !this.urlPrimary.isEmpty() && !this.domainPrimary.isEmpty();
        return hasPrim && (!this.auditGroups.isEmpty() || !this.adminGroups.isEmpty() || !this.basicGroups.isEmpty());
    }

    public String getSearchFilterOrDefault() {
        if (!this.userDnPattern.isEmpty()) {
            return this.userDnPattern;
        }
        return "(&(objectClass=user)(sAMAccountName={0}))";
    }

    public List<UrlAndDomain> getUrlAndDomains() {
        ArrayList<UrlAndDomain> ret = new ArrayList<UrlAndDomain>();
        if (!this.urlPrimary.isEmpty() && !this.domainPrimary.isEmpty()) {
            ret.add(new UrlAndDomain(this.urlPrimary, this.domainPrimary));
        }
        if (!this.urlSecondary.isEmpty() && !this.domainSecondary.isEmpty()) {
            ret.add(new UrlAndDomain(this.urlSecondary, this.domainSecondary));
        }
        return ret;
    }

    public String getDomainPrimary() {
        return this.domainPrimary;
    }

    public String getDomainSecondary() {
        return this.domainSecondary;
    }

    public void setDomainSecondary(String domainSecondary) {
        this.domainSecondary = domainSecondary;
    }

    public void setDomainPrimary(String domainPrimary) {
        String dom;
        this.domainPrimary = dom = domainPrimary.toLowerCase();
    }

    public String getUrlPrimary() {
        return this.urlPrimary;
    }

    public void setUrlPrimary(String urlPrimary) {
        this.urlPrimary = urlPrimary;
    }

    public String getUrlSecondary() {
        return this.urlSecondary;
    }

    public void setUrlSecondary(String urlSecondary) {
        this.urlSecondary = urlSecondary;
    }

    public String getGroupAttribute() {
        if (!this.groupAttribute.isEmpty()) {
            return this.groupAttribute;
        }
        return "memberOf";
    }

    public void setGroupAttribute(String groupAttribute) {
        this.groupAttribute = groupAttribute;
    }

    public List<String> getAuditGroups() {
        return Collections.unmodifiableList(this.auditGroups);
    }

    public void setAuditGroups(List<String> auditGroups) {
        this.auditGroups = auditGroups;
    }

    public void setAuditGroupsStr(String s) {
        this.auditGroups = LDAPConfig.groupStringToList((String)s);
    }

    public void setAdminGroupsStr(String s) {
        this.adminGroups = LDAPConfig.groupStringToList((String)s);
    }

    public void setBasicGroupsStr(String s) {
        this.basicGroups = LDAPConfig.groupStringToList((String)s);
    }

    public List<String> getAdminGroups() {
        return Collections.unmodifiableList(this.adminGroups);
    }

    public void setAdminGroups(List<String> adminGroups) {
        this.adminGroups = adminGroups;
    }

    public List<String> getBasicGroups() {
        return Collections.unmodifiableList(this.basicGroups);
    }

    public void setBasicGroups(List<String> basicGroups) {
        this.basicGroups = basicGroups;
    }

    public String getUserDnPattern() {
        return this.userDnPattern;
    }

    public void setUserDnPattern(String userDnPattern) {
        this.userDnPattern = userDnPattern;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public boolean isLdapEnabledForIndividualReports() {
        return this.ldapEnabledForIndividualReports;
    }

    public boolean isIgnoreLdapFailuresForIndividualReports() {
        return this.ignoreLdapFailuresForIndividualReports;
    }

    public boolean isCreateLocalUsersDisabled() {
        return this.createLocalUsersDisabled;
    }

    public void setCreateLocalUsersDisabled(boolean createLocalUsersDisabled) {
        this.createLocalUsersDisabled = createLocalUsersDisabled;
    }

    public long getLastModifiedMillis() {
        return this.lastModifiedMillis;
    }

    public boolean usingUserPrincipalName() {
        return this.userDnPattern.contains("userPrincipalName");
    }

    public boolean usingSAMAccountName() {
        return this.userDnPattern.contains("sAMAccountName");
    }

    public boolean isAllowSelfSignedldaps() {
        return this.allowSelfSignedldaps;
    }

    public void setAllowSelfSignedldaps(boolean allowSelfSignedldaps) {
        this.allowSelfSignedldaps = allowSelfSignedldaps;
    }

    private static List<String> groupStringToList(String ldapAuditGroups) {
        if (ldapAuditGroups.isEmpty()) {
            return Collections.emptyList();
        }
        String[] result = (String[])Arrays.stream(ldapAuditGroups.split(",")).map(String::trim).toArray(String[]::new);
        return Arrays.asList(result);
    }

    private static String groupsToString(List<String> auditGroups) {
        return String.join((CharSequence)",", auditGroups);
    }
}

