/*
 * Decompiled with CFR 0.152.
 */
package com.geolang.ascema.managerservice.rest.security.ad;

import com.geolang.ascema.managerservice.rest.security.UserStore;
import com.geolang.ascema.managerservice.rest.security.ad.ADAuthProvider;
import com.geolang.ascema.managerservice.rest.security.ad.ADAuthProviderException;
import com.geolang.ascema.managerservice.rest.security.ad.LDAPConfig;
import com.geolang.ascema.managerservice.rest.security.ad.UrlAndDomain;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.naming.AuthenticationException;
import javax.naming.InvalidNameException;
import javax.naming.NamingException;
import javax.naming.OperationNotSupportedException;
import javax.naming.directory.DirContext;
import javax.naming.directory.SearchControls;
import javax.naming.ldap.LdapName;
import javax.naming.ldap.Rdn;
import org.springframework.dao.IncorrectResultSizeDataAccessException;
import org.springframework.ldap.CommunicationException;
import org.springframework.ldap.core.DirContextOperations;
import org.springframework.ldap.core.support.DefaultDirObjectFactory;
import org.springframework.ldap.support.LdapUtils;
import org.springframework.security.authentication.AccountExpiredException;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.authentication.CredentialsExpiredException;
import org.springframework.security.authentication.DisabledException;
import org.springframework.security.authentication.InternalAuthenticationServiceException;
import org.springframework.security.authentication.LockedException;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.AuthorityUtils;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.security.ldap.SpringSecurityLdapTemplate;
import org.springframework.security.ldap.authentication.AbstractLdapAuthenticationProvider;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public final class ADAuthProvider
extends AbstractLdapAuthenticationProvider {
    private static final Logger LOG = Logger.getLogger(ADAuthProvider.class.getName());
    private static final Pattern SUB_ERROR_CODE = Pattern.compile(".*data\\s([0-9a-f]{3,4}).*");
    private static final int USERNAME_NOT_FOUND = 1317;
    private static final int INVALID_PASSWORD = 1326;
    private static final int NOT_PERMITTED = 1328;
    private static final int PASSWORD_EXPIRED = 1330;
    private static final int ACCOUNT_DISABLED = 1331;
    private static final int ACCOUNT_EXPIRED = 1793;
    private static final int PASSWORD_NEEDS_RESET = 1907;
    private static final int ACCOUNT_LOCKED = 1909;
    private final UserStore userStore;
    private final String domain;
    private final String url;
    private final String searchFilter;
    private final String groupAttribute;
    private final boolean usingUserPrincipalName;
    private final List<String> auditGroups;
    private final List<String> adminGroups;
    private final List<String> basicGroups;
    private boolean convertSubErrorCodesToExceptions;
    private final boolean ldapEnabledForIndividualReports;
    private Map<String, Object> contextEnvironmentProperties = new HashMap();
    ContextFactory contextFactory = new ContextFactory();

    public ADAuthProvider(UserStore store, UrlAndDomain urlAndDomain, LDAPConfig config) {
        this.userStore = store;
        this.domain = urlAndDomain.getDomain();
        this.url = urlAndDomain.getUrl();
        this.searchFilter = config.getSearchFilterOrDefault();
        this.groupAttribute = config.getGroupAttribute();
        this.auditGroups = config.getAuditGroups();
        this.adminGroups = config.getAdminGroups();
        this.basicGroups = config.getBasicGroups();
        this.usingUserPrincipalName = config.usingUserPrincipalName();
        this.ldapEnabledForIndividualReports = config.isLdapEnabledForIndividualReports();
        LOG.log(Level.INFO, "Configure AD provider for {0}  {1}", new Object[]{urlAndDomain.getUrl(), urlAndDomain.getDomain()});
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected DirContextOperations doAuthentication(UsernamePasswordAuthenticationToken auth) {
        DirContextOperations dirContextOperations;
        String username = auth.getName();
        String password = (String)auth.getCredentials();
        DirContext ctx = null;
        try {
            ctx = this.bindAsUser(username, password);
            dirContextOperations = this.searchForUser(ctx, username);
        }
        catch (CommunicationException ex) {
            try {
                throw this.badLdapConnection((Throwable)ex);
                catch (NamingException ex2) {
                    LOG.log(Level.WARNING, "Failed to locate directory entry for authenticated user: {0}  {1}", new Object[]{username, ex2.getMessage()});
                    throw this.badCredentials((Throwable)ex2);
                }
            }
            catch (Throwable throwable) {
                LdapUtils.closeContext(ctx);
                throw throwable;
            }
        }
        LdapUtils.closeContext((DirContext)ctx);
        return dirContextOperations;
    }

    protected Collection<? extends GrantedAuthority> loadUserAuthorities(DirContextOperations userData, String username, String pwd) {
        String[] groups = userData.getStringAttributes(this.groupAttribute);
        if (groups == null) {
            LOG.log(Level.WARNING, "no groups attribute {0} found", this.groupAttribute);
            return AuthorityUtils.NO_AUTHORITIES;
        }
        boolean admin = this.groupMemberOf(groups, this.adminGroups);
        boolean auditor = this.groupMemberOf(groups, this.auditGroups);
        boolean basic = this.groupMemberOf(groups, this.basicGroups);
        if (!(basic || auditor || admin)) {
            if (this.ldapEnabledForIndividualReports) {
                return UserStore.getGrantedAuthsForIndividualReportsUser();
            }
            LOG.log(Level.WARNING, "User not member of any required groups {0}", username);
            return AuthorityUtils.NO_AUTHORITIES;
        }
        if (this.userStore != null) {
            this.userStore.addRemoteUser(username, admin, auditor);
        }
        return UserStore.getGrantedAuths((boolean)admin, (boolean)auditor);
    }

    private boolean groupMemberOf(String[] groups, List<String> adminGroups) {
        for (String dn : groups) {
            LdapName ln;
            try {
                ln = new LdapName(dn);
            }
            catch (InvalidNameException ex) {
                LOG.log(Level.WARNING, ex.getMessage());
                continue;
            }
            for (Rdn rdn : ln.getRdns()) {
                Object obj;
                if (!rdn.getType().equalsIgnoreCase("CN") || !((obj = rdn.getValue()) instanceof String)) continue;
                String gName = (String)obj;
                for (String g : adminGroups) {
                    if (!gName.equalsIgnoreCase(g)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private DirContext bindAsUser(String username, String password) {
        Hashtable<String, String> env = new Hashtable<String, String>();
        env.put("java.naming.security.authentication", "simple");
        String bindPrincipal = this.createBindPrincipal(username, this.domain);
        env.put("java.naming.security.principal", bindPrincipal);
        env.put("java.naming.provider.url", this.url);
        env.put("java.naming.security.credentials", password);
        env.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        env.put("java.naming.factory.object", DefaultDirObjectFactory.class.getName());
        if (this.url.toLowerCase().startsWith("ldaps")) {
            env.put("java.naming.ldap.factory.socket", "com.geolang.ascema.managerservice.rest.security.ad.LdapSSLSocketFactory");
        }
        env.putAll(this.contextEnvironmentProperties);
        try {
            return this.contextFactory.createContext(env);
        }
        catch (NamingException ex) {
            if (ex instanceof AuthenticationException || ex instanceof OperationNotSupportedException) {
                this.handleBindException(bindPrincipal, ex);
                throw this.badCredentials((Throwable)ex);
            }
            throw LdapUtils.convertLdapException((NamingException)ex);
        }
    }

    private Object[] getUserNameArguments(String username) {
        String bindPrincipal = this.createBindPrincipal(username, this.domain);
        if (this.usingUserPrincipalName) {
            return new Object[]{bindPrincipal, username};
        }
        String verifyName = username;
        if (username.contains("@")) {
            verifyName = username.substring(0, username.indexOf("@"));
        }
        return new Object[]{verifyName};
    }

    private DirContextOperations searchForUser(DirContext context, String username) throws NamingException {
        String rootDn = this.domain != null ? this.rootDnFromDomain(this.domain) : null;
        SearchControls searchControls = new SearchControls();
        searchControls.setSearchScope(2);
        String bindPrincipal = this.createBindPrincipal(username, this.domain);
        String searchRoot = rootDn != null && !rootDn.isEmpty() ? rootDn : this.searchRootFromPrincipal(bindPrincipal);
        Object[] args = this.getUserNameArguments(username);
        try {
            return SpringSecurityLdapTemplate.searchForSingleEntryInternal((DirContext)context, (SearchControls)searchControls, (String)searchRoot, (String)this.searchFilter, (Object[])args);
        }
        catch (CommunicationException ex) {
            throw this.badLdapConnection((Throwable)ex);
        }
        catch (IncorrectResultSizeDataAccessException ex) {
            if (ex.getActualSize() != 0) {
                throw ex;
            }
            UsernameNotFoundException userNameNotFoundException = new UsernameNotFoundException("User " + username + " not found in directory.", (Throwable)ex);
            throw this.badCredentials((Throwable)userNameNotFoundException);
        }
    }

    private String searchRootFromPrincipal(String bindPrincipal) {
        int atChar = bindPrincipal.lastIndexOf(64);
        if (atChar < 0) {
            LOG.log(Level.FINE, "User principal ''{0}'' does not contain the domain, and no domain has been configured", bindPrincipal);
            throw this.badCredentials();
        }
        return this.rootDnFromDomain(bindPrincipal.substring(atChar + 1, bindPrincipal.length()));
    }

    private String rootDnFromDomain(String domain) {
        String[] tokens = StringUtils.tokenizeToStringArray((String)domain, (String)".");
        StringBuilder root = new StringBuilder();
        for (String token : tokens) {
            if (root.length() > 0) {
                root.append(',');
            }
            root.append("dc=").append(token);
        }
        return root.toString();
    }

    String createBindPrincipal(String username, String domain) {
        if (domain.isEmpty() || username.toLowerCase().endsWith(domain)) {
            return username;
        }
        return username + "@" + domain;
    }

    private void handleBindException(String bindPrincipal, NamingException exception) {
        LOG.log(Level.FINE, "Authentication for {0} failed:{1}", new Object[]{bindPrincipal, exception.getMessage()});
        this.handleResolveObj(exception);
        int subErrorCode = this.parseSubErrorCode(exception.getMessage());
        if (subErrorCode <= 0) {
            LOG.fine("Failed to locate AD-specific sub-error code in message");
            return;
        }
        LOG.log(Level.WARNING, "Active Directory authentication failed: {0}", this.subCodeToLogMessage(subErrorCode));
        if (this.convertSubErrorCodesToExceptions) {
            this.raiseExceptionForErrorCode(subErrorCode, exception);
        }
    }

    private void handleResolveObj(NamingException exception) {
        boolean serializable;
        Object resolvedObj = exception.getResolvedObj();
        if (resolvedObj != null && !(serializable = resolvedObj instanceof Serializable)) {
            exception.setResolvedObj(null);
        }
    }

    private int parseSubErrorCode(String message) {
        Matcher matcher = SUB_ERROR_CODE.matcher(message);
        if (matcher.matches()) {
            return Integer.parseInt(matcher.group(1), 16);
        }
        return -1;
    }

    private void raiseExceptionForErrorCode(int code, NamingException exception) {
        String hexString = Integer.toHexString(code);
        ADAuthProviderException cause = new ADAuthProviderException(hexString, exception.getMessage(), (Throwable)exception);
        switch (code) {
            case 1330: {
                throw new CredentialsExpiredException(this.messages.getMessage("LdapAuthenticationProvider.credentialsExpired", "User credentials have expired"), (Throwable)cause);
            }
            case 1331: {
                throw new DisabledException(this.messages.getMessage("LdapAuthenticationProvider.disabled", "User is disabled"), (Throwable)cause);
            }
            case 1793: {
                throw new AccountExpiredException(this.messages.getMessage("LdapAuthenticationProvider.expired", "User account has expired"), (Throwable)cause);
            }
            case 1909: {
                throw new LockedException(this.messages.getMessage("LdapAuthenticationProvider.locked", "User account is locked"), (Throwable)cause);
            }
        }
        throw this.badCredentials((Throwable)cause);
    }

    private String subCodeToLogMessage(int code) {
        switch (code) {
            case 1317: {
                return "User was not found in directory";
            }
            case 1326: {
                return "Supplied password was invalid";
            }
            case 1328: {
                return "User not permitted to logon at this time";
            }
            case 1330: {
                return "Password has expired";
            }
            case 1331: {
                return "Account is disabled";
            }
            case 1793: {
                return "Account expired";
            }
            case 1907: {
                return "User must reset password";
            }
            case 1909: {
                return "Account locked";
            }
        }
        return "Unknown (error code " + Integer.toHexString(code) + ")";
    }

    private BadCredentialsException badCredentials() {
        return new BadCredentialsException(this.messages.getMessage("LdapAuthenticationProvider.badCredentials", "Bad credentials"));
    }

    private BadCredentialsException badCredentials(Throwable cause) {
        return (BadCredentialsException)this.badCredentials().initCause(cause);
    }

    private InternalAuthenticationServiceException badLdapConnection(Throwable cause) {
        return new InternalAuthenticationServiceException(this.messages.getMessage("LdapAuthenticationProvider.badLdapConnection", "Connection to LDAP server failed."), cause);
    }

    public void setConvertSubErrorCodesToExceptions(boolean convertSubErrorCodesToExceptions) {
        this.convertSubErrorCodesToExceptions = convertSubErrorCodesToExceptions;
    }

    public void setContextEnvironmentProperties(Map<String, Object> environment) {
        Assert.notEmpty(environment, (String)"environment must not be empty");
        this.contextEnvironmentProperties = new Hashtable<String, Object>(environment);
    }
}

