/*
 * Decompiled with CFR 0.152.
 */
package com.geolang.ascema.managerservice.rest.security;

import com.geolang.ascema.managerdomain.domain.Notification;
import com.geolang.ascema.managerdomain.domain.NotificationType;
import com.geolang.ascema.managerdomain.domain.UserPassword;
import com.geolang.ascema.managerdomain.web.UserRole;
import com.geolang.ascema.managerpersistence.IUserRepository;
import com.geolang.ascema.managerpersistence.NotificationStore;
import com.geolang.ascema.managerservice.rest.security.LoginAttemptService;
import jakarta.servlet.http.HttpServletRequest;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.authentication.LockedException;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.core.userdetails.User;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.stereotype.Service;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class UserStore
implements UserDetailsService {
    private static final Logger LOG = Logger.getLogger(UserStore.class.getName());
    @Autowired
    private IUserRepository repo;
    @Autowired
    private PasswordEncoder encoder;
    @Autowired
    private LoginAttemptService loginAttemptService;
    @Autowired
    private HttpServletRequest request;
    @Autowired
    private NotificationStore notificationsStore;
    public static final String ADMIN_USER_NAME = "administrator";
    public static final String ROLE_ADMIN = "ROLE_ADMIN";
    public static final String ROLE_BASIC = "ROLE_BASIC";
    public static final String ROLE_AUDITOR = "ROLE_AUDITOR";
    public static final String ROLE_ANONYMOUS = "ROLE_ANONYMOUS";
    public static final String ROLE_INDIVIDUAL_REPORTS = "ROLE_INDIVIDUAL_REPORTS";
    public static final String BLOCKED = "blocked";
    public static final String ANONYMOUS_USER = "anonymousUser";
    private static final List<SimpleGrantedAuthority> authoritiesBasic = new ArrayList();
    private static final List<SimpleGrantedAuthority> authoritiesAdmin = new ArrayList();
    private static final List<SimpleGrantedAuthority> authoritiesAuditor = new ArrayList();
    private static final List<SimpleGrantedAuthority> authoritiesIndividualReports = new ArrayList();

    public void addUser(UserPassword up) {
        this.repo.save((Object)up);
        LOG.log(Level.INFO, "new user {0}", up.getDisplayName());
    }

    public boolean removeUser(String username) {
        Optional opt = this.getUser(username);
        if (opt.isPresent()) {
            this.repo.delete((Object)((UserPassword)opt.get()));
            LOG.log(Level.INFO, "Delete user {0}", username);
            return true;
        }
        return false;
    }

    public Optional<UserPassword> getUser(String username) {
        return this.repo.findById((Object)username.toLowerCase());
    }

    public String getHint(String username) {
        Optional up = this.getUser(username);
        if (up.isPresent()) {
            return ((UserPassword)up.get()).getHint();
        }
        return "";
    }

    public List<UserRole> getAllLocal() {
        ArrayList<UserRole> ret = new ArrayList<UserRole>();
        for (UserPassword up : this.repo.findAll()) {
            if (up.isRemoteUser()) continue;
            ret.add(new UserRole(up.getDisplayName(), up.isIsAdmin(), up.isIsAuditor()));
        }
        return ret;
    }

    public long getLockedSeconds(String username) {
        String ip = this.getClientIP();
        return this.loginAttemptService.getBlockedSeconds(new LoginAttemptService.IpAndPrinciple(ip, username));
    }

    public UserDetails loadUserByUsername(String username) throws UsernameNotFoundException, LockedException {
        List users;
        String ip = this.getClientIP();
        boolean locked = false;
        String lcUserName = username.toLowerCase();
        if (this.loginAttemptService.isBlocked(new LoginAttemptService.IpAndPrinciple(ip, lcUserName))) {
            LOG.log(Level.INFO, "Blocked user {0}", lcUserName);
            locked = true;
        }
        if ((users = this.repo.findLocalById(lcUserName)) == null || users.isEmpty()) {
            LOG.log(Level.INFO, "User not found {0}", lcUserName);
            throw new UsernameNotFoundException(lcUserName + "Not Found");
        }
        Object[] up = (Object[])users.get(0);
        List auths = UserStore.getGrantedAuths((boolean)((Boolean)up[2]), (boolean)((Boolean)up[3]));
        if (locked) {
            return new User((String)up[0], (String)up[1], true, true, true, false, (Collection)auths);
        }
        return new User((String)up[0], (String)up[1], (Collection)auths);
    }

    private String getClientIP() {
        String xfHeader = this.request.getHeader("X-Forwarded-For");
        if (xfHeader == null) {
            return this.request.getRemoteAddr();
        }
        return xfHeader.split(",")[0];
    }

    public void addRemoteUser(String username, boolean admin, boolean auditor) {
        Optional upOpt = this.getUser(username);
        if (upOpt.isPresent()) {
            return;
        }
        UserPassword up = UserPassword.createRemoteUser((String)username, (boolean)admin, (boolean)auditor);
        this.addUser(up);
        Notification n = new Notification("Welcome " + username + "!", "You can find user documentation in the Help section.", NotificationType.SUCCESS);
        this.notificationsStore.addNotification(username, n);
    }

    public Optional<UserDetails> registerNewUserAccount(String user, String pass, String hint, boolean admin, boolean auditor) {
        Optional upOpt = this.getUser(user);
        if (upOpt.isPresent()) {
            LOG.log(Level.WARNING, "User already exists {0}", user);
            return Optional.empty();
        }
        String enc = this.encoder.encode((CharSequence)pass);
        UserPassword up = UserPassword.createLocalUser((String)user, (String)enc, (String)hint, (boolean)admin, (boolean)auditor);
        this.addUser(up);
        Notification n = new Notification("Welcome " + user + "!", "You can find user documentation in the Help section.", NotificationType.SUCCESS);
        this.notificationsStore.addNotification(user, n);
        return Optional.of(new User(up.getDisplayName(), up.getEncpass(), (Collection)UserStore.getGrantedAuths((boolean)up.isIsAdmin(), (boolean)up.isIsAuditor())));
    }

    public static List<? extends GrantedAuthority> getGrantedAuths(boolean isAdmin, boolean isAuditor) {
        ArrayList authorities = new ArrayList();
        if (isAdmin) {
            authorities.addAll(authoritiesAdmin);
        }
        if (isAuditor) {
            authorities.addAll(authoritiesAuditor);
        }
        if (!isAdmin && !isAuditor) {
            authorities.addAll(authoritiesBasic);
        }
        return authorities;
    }

    public static List<? extends GrantedAuthority> getGrantedAuthsForIndividualReportsUser() {
        return authoritiesIndividualReports;
    }

    public boolean setPassword(String user, String oldPw, String pw, String hint) {
        Optional upOpt = this.getUser(user);
        if (!upOpt.isPresent()) {
            LOG.log(Level.WARNING, "User not found for change pw {0}", user);
            return false;
        }
        UserPassword up = (UserPassword)upOpt.get();
        String encold = up.getEncpass();
        boolean ok = this.encoder.matches((CharSequence)oldPw, encold);
        if (!ok) {
            return false;
        }
        String enc = this.encoder.encode((CharSequence)pw);
        up.setEncpass(enc);
        up.setHint(hint);
        this.repo.save((Object)up);
        return true;
    }

    public boolean setPasswordFromAdmin(String user, String pw, String hint) {
        Optional upOpt = this.getUser(user);
        if (!upOpt.isPresent()) {
            LOG.log(Level.WARNING, "User not found for change pw {0}", user);
            return false;
        }
        UserPassword up = (UserPassword)upOpt.get();
        String enc = this.encoder.encode((CharSequence)pw);
        up.setEncpass(enc);
        up.setHint(hint);
        this.repo.save((Object)up);
        return true;
    }

    public boolean setUserRole(String changerUser, UserRole userRole) {
        Optional upOpt = this.getUser(userRole.getUsername());
        if (!upOpt.isPresent()) {
            LOG.log(Level.WARNING, "User not found for change roles {0}", userRole.getUsername());
            return false;
        }
        UserPassword up = (UserPassword)upOpt.get();
        up.setIsAdmin(userRole.isIsAdmin());
        up.setIsAuditor(userRole.isIsAuditor());
        this.repo.save((Object)up);
        LOG.log(Level.INFO, "{0} edited roles  {1}", new Object[]{changerUser, userRole});
        return true;
    }

    public static boolean isAnonymousRole(Collection<? extends GrantedAuthority> auths) {
        return auths.contains(new SimpleGrantedAuthority("ROLE_ANONYMOUS"));
    }

    public static boolean hasBasicOrAdminRole(Collection<? extends GrantedAuthority> auths) {
        return auths.contains(new SimpleGrantedAuthority("ROLE_ADMIN")) || auths.contains(new SimpleGrantedAuthority("ROLE_BASIC"));
    }

    static {
        authoritiesAdmin.add(new SimpleGrantedAuthority("ROLE_ADMIN"));
        authoritiesBasic.add(new SimpleGrantedAuthority("ROLE_BASIC"));
        authoritiesAuditor.add(new SimpleGrantedAuthority("ROLE_AUDITOR"));
        authoritiesIndividualReports.add(new SimpleGrantedAuthority("ROLE_INDIVIDUAL_REPORTS"));
    }
}

