/*
 * Decompiled with CFR 0.152.
 */
package com.geolang.ascema.managerservice.rest.security;

import com.geolang.ascema.managercore.settings.SettingsFile;
import com.geolang.ascema.managerservice.rest.security.JWTProvider;
import com.geolang.ascema.managerservice.rest.security.SecurityConfig;
import com.geolang.ascema.managerservice.rest.security.UserStore;
import com.geolang.ascema.managerservice.rest.security.ad.ADAuthProvider;
import com.geolang.ascema.managerservice.rest.security.ad.LDAPConfig;
import com.geolang.ascema.managerservice.rest.security.ad.LdapCredentialsLoader;
import com.geolang.ascema.managerservice.rest.security.ad.UrlAndDomain;
import jakarta.servlet.DispatcherType;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Lazy;
import org.springframework.http.HttpMethod;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.authentication.dao.DaoAuthenticationProvider;
import org.springframework.security.config.Customizer;
import org.springframework.security.config.annotation.SecurityConfigurerAdapter;
import org.springframework.security.config.annotation.authentication.builders.AuthenticationManagerBuilder;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity;
import org.springframework.security.config.annotation.web.configurers.AuthorizeHttpRequestsConfigurer;
import org.springframework.security.config.http.SessionCreationPolicy;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.crypto.bcrypt.BCryptPasswordEncoder;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.security.web.SecurityFilterChain;
import org.springframework.security.web.csrf.CookieCsrfTokenRepository;
import org.springframework.security.web.csrf.CsrfTokenRepository;

@Configuration
@EnableWebSecurity
public class SecurityConfig {
    private static final Logger LOG = Logger.getLogger(SecurityConfig.class.getName());
    @Lazy
    @Autowired
    private UserStore userStore;
    @Autowired
    private JWTProvider jwtProvider;

    private void configure(AuthenticationManagerBuilder auth) {
        auth.authenticationProvider((AuthenticationProvider)this.dbAuthProvider());
        try {
            LdapCredentialsLoader.updateFromConfig();
            LDAPConfig ldapConfig = new LDAPConfig();
            if (ldapConfig.hasEnoughDetails() && ldapConfig.isEnabled()) {
                for (UrlAndDomain uad : ldapConfig.getUrlAndDomains()) {
                    ADAuthProvider adProvider = new ADAuthProvider(this.userStore, uad, ldapConfig);
                    adProvider.setConvertSubErrorCodesToExceptions(true);
                    adProvider.setUseAuthenticationRequestCredentials(true);
                    auth.authenticationProvider((AuthenticationProvider)adProvider);
                }
            } else {
                LOG.info("Ldap auth not enabled");
            }
        }
        catch (Exception e) {
            LOG.log(Level.INFO, "Active directory exception {0}", e.getMessage());
        }
    }

    @Bean
    public SecurityFilterChain filterChain(HttpSecurity http) throws Exception {
        AuthenticationManagerBuilder authenticationManagerBuilder = (AuthenticationManagerBuilder)http.getSharedObject(AuthenticationManagerBuilder.class);
        this.configure(authenticationManagerBuilder);
        SettingsFile settings = SettingsFile.getInstance();
        if (settings.getUISSL() && settings.getUICSRF()) {
            LOG.info("Using csrf");
            CookieCsrfTokenRepository rep = new CookieCsrfTokenRepository();
            http.csrf(c -> c.csrfTokenRepository((CsrfTokenRepository)rep));
        } else {
            LOG.info("Not using csrf");
            http.csrf(c -> c.disable());
        }
        http.authorizeHttpRequests(authorizeHttpRequests -> ((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)authorizeHttpRequests.dispatcherTypeMatchers(new DispatcherType[]{DispatcherType.ASYNC})).permitAll().requestMatchers(new String[]{"/actuator/**"})).hasRole("ADMIN").requestMatchers(HttpMethod.GET, new String[]{"/*.html", "/favicon.ico", "/*.html", "/*.css", "/*.js", "/*.png", "/*.svg", "/*.eot", "/*.ttf", "/*.woff", "/*.woff2", "/*.svg", "/*.map", "/*.jpg", "/assets/**"})).permitAll().requestMatchers(new String[]{"/", "/login", "/api/users/401", "/api/users/locked/*", "/api/users/hint/*", "/api/users/ping", "/api/users/checkadminexists", "/api/help/url"})).permitAll().requestMatchers(HttpMethod.GET, new String[]{"/api/admin/settings/companyname", "/api/admin/settings/logo", "/api/admin/settings/policytext", "/api/admin/settings/policyurl", "/api/admin/settings/allowedcontentreason", "/api/admin/license/exists", "/api/admin/license/alfrescoenabled", "/api/admin/license/atlassianenabled", "/api/admin/license/o365enabled", "/api/admin/license/googleenabled", "/api/admin/settings/ldapindividualreports", "/api/admin/settings/ldapindividualreportsignorefailures", "/api/admin/settings/allowedknowledgeBase", "/api/results/wait", "/api/o365/getuserfromid/*", "/api/async/sse", "/api/knowledgebase/templates"})).permitAll().requestMatchers(HttpMethod.POST, new String[]{"/api/results/getdevicelatest", "/api/results/geto365userlatest", "/api/results/getgoogleuserlatest", "/api/results/getfilelatestfordevice", "/api/results/getfilelatestforuser", "/api/results/updatestatus", "/api/results/setstatusforfile", "/api/results/updatemultiplestatus", "/api/results/confirm", "/api/results/historybyfile", "/api/results/openfile", "/api/knowledgebase/lookup"})).permitAll().requestMatchers(HttpMethod.POST, new String[]{"/api/users/set-sysadmin-pass"})).permitAll().requestMatchers(HttpMethod.POST, new String[]{"/api/quarantine/revertrequest", "/api/quarantine/delete"})).permitAll().requestMatchers(HttpMethod.GET, new String[]{"/api/admin/license/expired", "/api/admin/settings/isprimary", "/api/admin/settings/alertconfig", "/api/admin/settings/isstandalone", "/api/admin/settings/serverlocation", "/api/admin/settings/issecondary", "/api/admin/license/fileserverenabled", "/api/admin/settings/datarepo"})).hasAnyRole(new String[]{"BASIC", "ADMIN", "AUDITOR"}).requestMatchers(HttpMethod.POST, new String[]{"/api/admin/settings/alerturl", "/api/admin/settings/alertconfig", "/api/admin/settings/datarepo", "/api/admin/settings/isstandalone", "/api/admin/settings/issecondary"})).hasAnyRole(new String[]{"BASIC", "ADMIN", "AUDITOR"}).requestMatchers(new String[]{"/api/admin/**", "/api/users/sign-up", "/api/users/delete/*", "/api/users/userroles/*", "/api/users/check/*", "/api/users/setuserrole", "/api/devices/log/*", "/api/hero/updatedailyrecords"})).hasRole("ADMIN").requestMatchers(HttpMethod.GET, new String[]{"/api/results/unredact", "/api/dbsearch/unredact"})).hasRole("AUDITOR").requestMatchers(new String[]{"/api/token/refresh"})).hasAnyRole(new String[]{"BASIC", "ADMIN", "AUDITOR", "INDIVIDUAL_REPORTS"}).requestMatchers(new String[]{"/api/**"})).hasAnyRole(new String[]{"BASIC", "ADMIN", "AUDITOR"}).anyRequest()).authenticated()).sessionManagement(sm -> sm.sessionCreationPolicy(SessionCreationPolicy.STATELESS)).with((SecurityConfigurerAdapter)new JwtConfigurer(this), Customizer.withDefaults());
        return (SecurityFilterChain)http.build();
    }

    @Bean
    public PasswordEncoder passwordEncoder() {
        return new BCryptPasswordEncoder();
    }

    @Bean
    public DaoAuthenticationProvider dbAuthProvider() {
        DaoAuthenticationProvider authProvider = new DaoAuthenticationProvider((UserDetailsService)this.userStore);
        authProvider.setPasswordEncoder(this.passwordEncoder());
        return authProvider;
    }
}

