/*
 * Decompiled with CFR 0.152.
 */
package com.geolang.ascema.managerservice.rest.security;

import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;

public class RateLimiter {
    private final Semaphore semaphore;
    private final int maxPermits;
    private final TimeUnit timePeriod;
    private ScheduledExecutorService scheduler;

    public static RateLimiter create(int permits, TimeUnit timePeriod) {
        RateLimiter limiter = new RateLimiter(permits, timePeriod);
        limiter.schedulePermitReplenishment();
        return limiter;
    }

    private RateLimiter(int permits, TimeUnit timePeriod) {
        this.semaphore = new Semaphore(permits);
        this.maxPermits = permits;
        this.timePeriod = timePeriod;
    }

    public boolean tryAcquire() {
        return this.semaphore.tryAcquire();
    }

    public synchronized void release() {
        this.semaphore.release(this.maxPermits - this.semaphore.availablePermits());
    }

    public void stop() {
        this.scheduler.shutdownNow();
    }

    public void schedulePermitReplenishment() {
        this.scheduler = Executors.newScheduledThreadPool(1);
        this.scheduler.schedule(() -> this.release(), 1L, this.timePeriod);
    }
}

