/*
 * Decompiled with CFR 0.152.
 */
package com.geolang.ascema.managerservice.rest.security;

import com.geolang.ascema.managerservice.rest.security.LoginAttemptService;
import java.time.LocalDateTime;
import java.time.temporal.ChronoUnit;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.springframework.stereotype.Service;

@Service
public class LoginAttemptService {
    private static final Logger LOG = Logger.getLogger(LoginAttemptService.class.getName());
    private final Map<String, LocalDateTime> ipAttemptsCache = new HashMap();
    private final Map<String, LocalDateTime> nameAttemptsCache = new HashMap();

    public void loginSucceeded(IpAndPrinciple key) {
        this.ipAttemptsCache.remove(key.ip());
        this.nameAttemptsCache.remove(key.principle());
        LOG.log(Level.INFO, "Successful Login {0}", key.principle());
    }

    public void loginFailed(IpAndPrinciple key) {
        LocalDateTime name;
        LOG.log(Level.INFO, "Failed Login {0} from {1}", new Object[]{key.principle(), key.ip()});
        LocalDateTime ip = (LocalDateTime)this.ipAttemptsCache.get(key.ip());
        if (ip == null) {
            ip = LocalDateTime.now().minus(15L, ChronoUnit.MINUTES);
        }
        if ((name = (LocalDateTime)this.nameAttemptsCache.get(key.principle())) == null) {
            name = LocalDateTime.now().minus(15L, ChronoUnit.MINUTES);
        }
        ip = ip.plus(5L, ChronoUnit.MINUTES);
        name = name.plus(5L, ChronoUnit.MINUTES);
        this.ipAttemptsCache.put(key.ip(), ip);
        this.nameAttemptsCache.put(key.principle(), name);
    }

    public boolean isBlocked(IpAndPrinciple key) {
        boolean ret;
        LocalDateTime ip;
        LocalDateTime now = LocalDateTime.now();
        LocalDateTime name = (LocalDateTime)this.nameAttemptsCache.get(key.principle());
        if (name == null) {
            name = now;
        }
        if ((ip = (LocalDateTime)this.ipAttemptsCache.get(key.ip())) == null) {
            ip = now;
        }
        boolean bl = ret = name.isAfter(now) || ip.isAfter(now);
        if (ret) {
            LOG.log(Level.INFO, " Login Blocked {0} from {1} ip timeout is {2} name timeout is {3}", new Object[]{key.principle(), key.ip(), ip, name});
        }
        return ret;
    }

    public long getBlockedSeconds(IpAndPrinciple key) {
        LocalDateTime ip;
        LocalDateTime now = LocalDateTime.now();
        LocalDateTime name = (LocalDateTime)this.nameAttemptsCache.get(key.principle());
        if (name == null) {
            name = now;
        }
        if ((ip = (LocalDateTime)this.ipAttemptsCache.get(key.ip())) == null) {
            ip = now;
        }
        long namesec = now.until(name, ChronoUnit.SECONDS);
        long ipsec = now.until(ip, ChronoUnit.SECONDS);
        return Math.max(namesec, ipsec);
    }
}

