/*
 * Decompiled with CFR 0.152.
 */
package com.geolang.ascema.managerservice.rest.security;

import io.jsonwebtoken.Claims;
import io.jsonwebtoken.JwtException;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.security.SecretKeyBuilder;
import java.security.Key;
import java.util.Date;
import java.util.Map;
import java.util.stream.Collectors;
import javax.crypto.SecretKey;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.stereotype.Component;

@Component
public class JWTProvider {
    public static final String TOKEN_PREFIX = "Bearer ";
    private static final int validityInMilliseconds = 900000;
    private final SecretKey key = (SecretKey)((SecretKeyBuilder)Jwts.SIG.HS512.key()).build();

    String createToken(Authentication auth) {
        String subject = ((UserDetails)auth.getPrincipal()).getUsername();
        String authorities = auth.getAuthorities().stream().map(GrantedAuthority::getAuthority).collect(Collectors.joining(","));
        return Jwts.builder().expiration(new Date(System.currentTimeMillis() + 900000L)).subject(subject).claim("role", (Object)authorities).issuedAt(new Date()).signWith((Key)this.key).compact();
    }

    public String refreshToken(String token) throws JwtException {
        Claims claims = this.validateToken(token);
        return Jwts.builder().claims((Map)claims).expiration(new Date(System.currentTimeMillis() + 900000L)).signWith((Key)this.key).compact();
    }

    public Claims validateToken(String token) {
        return (Claims)Jwts.parser().verifyWith(this.key).build().parseSignedClaims((CharSequence)token.replace(TOKEN_PREFIX, "")).getPayload();
    }
}

