/*
 * Decompiled with CFR 0.152.
 */
package com.geolang.ascema.managerservice.rest.security;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.geolang.ascema.managerdomain.web.LoginRequest;
import com.geolang.ascema.managerservice.rest.security.JWTProvider;
import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.web.authentication.AuthenticationFailureHandler;
import org.springframework.security.web.authentication.SimpleUrlAuthenticationFailureHandler;
import org.springframework.security.web.authentication.UsernamePasswordAuthenticationFilter;

public class JWTAuthenticationFilter
extends UsernamePasswordAuthenticationFilter {
    private final AuthenticationManager authenticationManager;
    private final JWTProvider jwtProvider;

    public JWTAuthenticationFilter(AuthenticationManager authenticationManager, JWTProvider jwtProvider) {
        this.authenticationManager = authenticationManager;
        this.jwtProvider = jwtProvider;
        SimpleUrlAuthenticationFailureHandler handler = new SimpleUrlAuthenticationFailureHandler("/api/users/401");
        handler.setUseForward(true);
        this.setAuthenticationFailureHandler((AuthenticationFailureHandler)handler);
    }

    public Authentication attemptAuthentication(HttpServletRequest req, HttpServletResponse res) throws AuthenticationException {
        try {
            LoginRequest creds = (LoginRequest)new ObjectMapper().readValue((InputStream)req.getInputStream(), LoginRequest.class);
            return this.authenticationManager.authenticate((Authentication)new UsernamePasswordAuthenticationToken((Object)creds.getUser(), (Object)creds.getPass(), new ArrayList()));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected void successfulAuthentication(HttpServletRequest req, HttpServletResponse res, FilterChain chain, Authentication auth) throws IOException, ServletException {
        String token = this.jwtProvider.createToken(auth);
        res.addHeader("Authorization", "Bearer " + token);
    }
}

