/*
 * Decompiled with CFR 0.152.
 */
package com.geolang.ascema.managerservice.rest.security;

import com.geolang.ascema.managerservice.rest.security.JWTProvider;
import io.jsonwebtoken.Claims;
import io.jsonwebtoken.JwtException;
import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.web.authentication.www.BasicAuthenticationFilter;

public class AuthorisationFilter
extends BasicAuthenticationFilter {
    private static final Logger LOG = Logger.getLogger(AuthorisationFilter.class.getName());
    private final JWTProvider jwtProvider;

    public AuthorisationFilter(AuthenticationManager authManager, JWTProvider provider) {
        super(authManager);
        this.jwtProvider = provider;
    }

    protected void doFilterInternal(HttpServletRequest req, HttpServletResponse res, FilterChain chain) throws IOException, ServletException {
        String header = req.getHeader("Authorization");
        if (header == null || !header.startsWith("Bearer ")) {
            chain.doFilter((ServletRequest)req, (ServletResponse)res);
            return;
        }
        UsernamePasswordAuthenticationToken authentication = this.getAuthentication(req);
        SecurityContextHolder.getContext().setAuthentication((Authentication)authentication);
        chain.doFilter((ServletRequest)req, (ServletResponse)res);
    }

    private UsernamePasswordAuthenticationToken getAuthentication(HttpServletRequest request) {
        String token = request.getHeader("Authorization");
        if (token != null) {
            try {
                Claims claims = this.jwtProvider.validateToken(token);
                if (claims != null) {
                    Collection authorities = Arrays.stream(claims.get((Object)"role").toString().split(",")).map(SimpleGrantedAuthority::new).collect(Collectors.toList());
                    return new UsernamePasswordAuthenticationToken((Object)claims.getSubject(), null, authorities);
                }
                return null;
            }
            catch (JwtException ex) {
                LOG.log(Level.WARNING, "UI has expired token? {0}", ex.getMessage());
            }
        }
        return null;
    }
}

