/*
 * Decompiled with CFR 0.152.
 */
package com.geolang.ascema.managerservice.rest.security;

import com.geolang.ascema.managerservice.rest.security.LoginAttemptService;
import jakarta.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationListener;
import org.springframework.security.authentication.event.AuthenticationFailureBadCredentialsEvent;
import org.springframework.stereotype.Component;

@Component
public class AuthenticationFailureListener
implements ApplicationListener<AuthenticationFailureBadCredentialsEvent> {
    @Autowired
    private HttpServletRequest request;
    @Autowired
    private LoginAttemptService loginAttemptService;

    public void onApplicationEvent(AuthenticationFailureBadCredentialsEvent e) {
        String xfHeader = this.request.getHeader("X-Forwarded-For");
        String user = e.getAuthentication().getPrincipal().toString();
        String ip = xfHeader == null ? this.request.getRemoteAddr() : xfHeader.split(",")[0];
        LoginAttemptService.IpAndPrinciple ipp = new LoginAttemptService.IpAndPrinciple(ip, user);
        this.loginAttemptService.loginFailed(ipp);
    }
}

