/*
 * Decompiled with CFR 0.152.
 */
package com.geolang.ascema.managerservice.rest.requests.tasks;

import com.geolang.ascema.endpointcommon.domain.SearchCommand;
import com.geolang.ascema.endpointcommon.domain.searchconfig.AlfrescoSearchConfiguration;
import com.geolang.ascema.endpointcommon.domain.searchconfig.AtlassianSearchConfiguration;
import com.geolang.ascema.endpointcommon.domain.searchconfig.EndpointSearchConfiguration;
import com.geolang.ascema.endpointcommon.domain.searchconfig.GoogleSearchConfiguration;
import com.geolang.ascema.endpointcommon.domain.searchconfig.O365SearchConfiguration;
import com.geolang.ascema.endpointcommon.domain.searchconfig.SearchFilterCommon;
import com.geolang.ascema.endpointcommon.domain.searchconfig.UnifiedSearchConfiguration;
import com.geolang.ascema.managerdomain.domain.TaskTemplate;
import com.geolang.ascema.managerdomain.web.SearchFilter;
import com.geolang.ascema.managerpersistence.ClassificationLabelStore;
import com.geolang.ascema.managerpersistence.ContextWordStore;
import com.geolang.ascema.managerpersistence.FileExtensionStore;
import com.geolang.ascema.managerservice.controllers.SchedulingService;
import com.geolang.ascema.managerservice.controllers.patterns.PatternService;
import com.geolang.ascema.managerservice.rest.requests.alfresco.AlfrescoSearchFilter;
import com.geolang.ascema.managerservice.rest.requests.atlassian.AtlassianSearchFilter;
import com.geolang.ascema.managerservice.rest.requests.google.GoogleSearchFilter;
import com.geolang.ascema.managerservice.rest.requests.o365.O365SearchFilter;
import com.geolang.ascema.managerservice.rest.requests.tasks.SearchFilterCommonWeb;
import com.geolang.ascema.managerservice.rest.requests.tasks.SearchTemplateBase;
import java.io.Serializable;
import java.util.Date;

public class UnifiedSearchJobTemplate
extends SearchTemplateBase
implements Serializable {
    private static final long serialVersionUID = 1L;
    private SearchFilterCommonWeb commonFilter;
    private SearchFilter searchFilter;
    private AlfrescoSearchFilter alfrescoFilter;
    private O365SearchFilter o365Filter;
    private AtlassianSearchFilter atlassianFilter;
    private GoogleSearchFilter googleFilter;
    private int lastDurationSeconds;
    private int maxDurationSeconds;
    private String actionIgnorePathsName;

    public UnifiedSearchJobTemplate() {
    }

    public UnifiedSearchJobTemplate(TaskTemplate plan, SchedulingService scheduler, PatternService patternService, Date lastRan) {
        super(plan, scheduler, ((SearchCommand)plan.getBaseCommand()).getConfig().getCommonFilter(), lastRan);
        SearchCommand sc = (SearchCommand)plan.getBaseCommand();
        UnifiedSearchConfiguration config = sc.getConfig();
        this.commonFilter = config.getCommonFilter() != null ? new SearchFilterCommonWeb(config.getCommonFilter(), patternService) : null;
        this.searchFilter = config.getSearch() != null ? new SearchFilter(config.getSearch()) : null;
        this.alfrescoFilter = config.getAlfresco() != null ? new AlfrescoSearchFilter(config.getAlfresco()) : null;
        this.o365Filter = config.getO365() != null ? new O365SearchFilter(config.getO365()) : null;
        this.googleFilter = config.getGoogle() != null ? new GoogleSearchFilter(config.getGoogle()) : null;
        this.atlassianFilter = config.getAtlassian() != null ? new AtlassianSearchFilter(config.getAtlassian()) : null;
        this.lastDurationSeconds = plan.getLastDurationSeconds();
        this.maxDurationSeconds = plan.getMaxDurationSeconds();
        this.actionIgnorePathsName = plan.getActionIgnorePathsName();
    }

    public SearchFilterCommonWeb getCommonFilter() {
        return this.commonFilter;
    }

    public SearchFilter getSearchFilter() {
        return this.searchFilter;
    }

    public AlfrescoSearchFilter getAlfrescoFilter() {
        return this.alfrescoFilter;
    }

    public O365SearchFilter getO365Filter() {
        return this.o365Filter;
    }

    public AtlassianSearchFilter getAtlassianFilter() {
        return this.atlassianFilter;
    }

    public GoogleSearchFilter getGoogleFilter() {
        return this.googleFilter;
    }

    public int getLastDurationSeconds() {
        return this.lastDurationSeconds;
    }

    public int getMaxDurationSeconds() {
        return this.maxDurationSeconds;
    }

    public String getActionIgnorePathsName() {
        return this.actionIgnorePathsName;
    }

    public UnifiedSearchConfiguration toConfig(FileExtensionStore fileExtManager, ContextWordStore contextWords, ClassificationLabelStore classStore) {
        EndpointSearchConfiguration searchConfig = null;
        O365SearchConfiguration o365SearchConfig = null;
        AlfrescoSearchConfiguration alfrescoSearchConfig = null;
        AtlassianSearchConfiguration atlassianSearchConfig = null;
        GoogleSearchConfiguration googleConfig = null;
        SearchFilterCommon common = null;
        if (this.getCommonFilter() != null) {
            common = this.getCommonFilter().toSearchFilterCommon(fileExtManager, contextWords, classStore);
        }
        if (this.getSearchFilter() != null) {
            searchConfig = this.getSearchFilter().toConfig();
        }
        if (this.getO365Filter() != null) {
            o365SearchConfig = this.getO365Filter().toConfig();
        }
        if (this.getAlfrescoFilter() != null) {
            alfrescoSearchConfig = this.getAlfrescoFilter().toConfig();
        }
        if (this.getAtlassianFilter() != null) {
            atlassianSearchConfig = this.getAtlassianFilter().toConfig();
        }
        if (this.getGoogleFilter() != null) {
            googleConfig = this.getGoogleFilter().toConfig();
        }
        UnifiedSearchConfiguration config = new UnifiedSearchConfiguration(common, searchConfig, o365SearchConfig, alfrescoSearchConfig, atlassianSearchConfig, googleConfig);
        return config;
    }

    public void setCommonFilter(SearchFilterCommonWeb commonFilter) {
        this.commonFilter = commonFilter;
    }

    public void setSearchFilter(SearchFilter searchFilter) {
        this.searchFilter = searchFilter;
    }

    public void setAlfrescoFilter(AlfrescoSearchFilter alfrescoFilter) {
        this.alfrescoFilter = alfrescoFilter;
    }

    public void setO365Filter(O365SearchFilter o365Filter) {
        this.o365Filter = o365Filter;
    }

    public void setAtlassianFilter(AtlassianSearchFilter atlassianFilter) {
        this.atlassianFilter = atlassianFilter;
    }

    public void setGoogleFilter(GoogleSearchFilter googleFilter) {
        this.googleFilter = googleFilter;
    }
}

