/*
 * Decompiled with CFR 0.152.
 */
package com.geolang.ascema.managerservice.rest.requests.tasks;

import com.geolang.ascema.endpointcommon.domain.JobState;
import com.geolang.ascema.endpointcommon.domain.searchconfig.UnifiedSearchConfiguration;
import com.geolang.ascema.managerdomain.domain.DeviceRegistration;
import com.geolang.ascema.managerdomain.domain.JobDeviceState;
import com.geolang.ascema.managerdomain.domain.TaskInstance;
import com.geolang.ascema.managerdomain.web.SearchFilter;
import com.geolang.ascema.managerdomain.web.WebJobState;
import com.geolang.ascema.managerservice.controllers.devices.DeviceService;
import com.geolang.ascema.managerservice.controllers.patterns.PatternService;
import com.geolang.ascema.managerservice.rest.requests.alfresco.AlfrescoSearchFilter;
import com.geolang.ascema.managerservice.rest.requests.atlassian.AtlassianSearchFilter;
import com.geolang.ascema.managerservice.rest.requests.google.GoogleSearchFilter;
import com.geolang.ascema.managerservice.rest.requests.o365.O365SearchFilter;
import com.geolang.ascema.managerservice.rest.requests.tasks.SearchFilterCommonWeb;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Optional;

public class UnifiedSearchJobInstance
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String id;
    private String name;
    private int priority;
    private boolean runOnAllDevices;
    private List<String> deviceIds;
    private List<WebJobState> states;
    private int maxDurationSeconds;
    private SearchFilterCommonWeb commonFilter;
    private SearchFilter searchFilter;
    private AlfrescoSearchFilter alfrescoFilter;
    private O365SearchFilter o365Filter;
    private GoogleSearchFilter googleFilter;
    private AtlassianSearchFilter atlassianFilter;
    private Date created;
    private String templateId;
    private boolean applyActionsAutomatically;

    public UnifiedSearchJobInstance() {
    }

    public UnifiedSearchJobInstance(TaskInstance plan, UnifiedSearchConfiguration config, DeviceService controller, PatternService patternService) {
        this.id = plan.getUid();
        this.name = plan.getDisplayName();
        this.templateId = plan.getParentTemplateId();
        this.runOnAllDevices = plan.isRunOnallDevices();
        this.created = plan.getCreated();
        this.applyActionsAutomatically = plan.isAlertAutomatically();
        this.commonFilter = new SearchFilterCommonWeb(config.getCommonFilter(), patternService);
        this.searchFilter = config.getSearch() != null ? new SearchFilter(config.getSearch()) : null;
        this.alfrescoFilter = config.getAlfresco() != null ? new AlfrescoSearchFilter(config.getAlfresco()) : null;
        this.o365Filter = config.getO365() != null ? new O365SearchFilter(config.getO365()) : null;
        this.googleFilter = config.getGoogle() != null ? new GoogleSearchFilter(config.getGoogle()) : null;
        this.atlassianFilter = config.getAtlassian() != null ? new AtlassianSearchFilter(config.getAtlassian()) : null;
        this.priority = plan.getPriority().ordinal();
        this.states = new ArrayList();
        this.deviceIds = new ArrayList();
        this.maxDurationSeconds = plan.maxDurationSeconds();
        for (JobDeviceState j : plan.getDeviceStates()) {
            JobState state = j.getState();
            String devicename = "";
            String deviceid = j.getDeviceId();
            this.deviceIds.add(deviceid);
            Optional reg = controller.getDeviceFromId(j.getDeviceId(), true);
            if (reg.isPresent()) {
                devicename = ((DeviceRegistration)reg.get()).getDeviceDescription();
            }
            this.states.add(new WebJobState(deviceid, devicename, state, j.getFilesSearched(), j.getBytesSearched(), j.getSearchDurationSeconds()));
        }
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public int getPriority() {
        return this.priority;
    }

    public boolean isRunOnAllDevices() {
        return this.runOnAllDevices;
    }

    public List<String> getDeviceIds() {
        return this.deviceIds;
    }

    public List<WebJobState> getStates() {
        return this.states;
    }

    public SearchFilterCommonWeb getCommonFilter() {
        return this.commonFilter;
    }

    public String getTemplateId() {
        return this.templateId;
    }

    public Date getCreated() {
        return this.created;
    }

    public SearchFilter getSearchFilter() {
        return this.searchFilter;
    }

    public AlfrescoSearchFilter getAlfrescoFilter() {
        return this.alfrescoFilter;
    }

    public AtlassianSearchFilter getAtlassianFilter() {
        return this.atlassianFilter;
    }

    public O365SearchFilter getO365Filter() {
        return this.o365Filter;
    }

    public GoogleSearchFilter getGoogleFilter() {
        return this.googleFilter;
    }

    public boolean isApplyActionsAutomatically() {
        return this.applyActionsAutomatically;
    }

    public int getMaxDurationSeconds() {
        return this.maxDurationSeconds;
    }
}

