/*
 * Decompiled with CFR 0.152.
 */
package com.geolang.ascema.managerservice.rest.requests.tasks;

import com.geolang.ascema.endpointcommon.domain.JobPriority;
import com.geolang.ascema.endpointcommon.domain.searchconfig.SearchFilterCommon;
import com.geolang.ascema.managerdomain.domain.Schedule;
import com.geolang.ascema.managerdomain.domain.TaskTemplate;
import com.geolang.ascema.managerdomain.web.WebSchedule;
import com.geolang.ascema.managerservice.controllers.SchedulingService;
import java.io.Serializable;
import java.util.Date;
import java.util.List;
import java.util.Optional;

public abstract class SearchTemplateBase
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String id;
    private String name;
    protected JobPriority priority;
    protected List<String> instanceIds;
    private WebSchedule schedule;
    private boolean alertAutomatically;
    private Date created;
    private Date lastRan;

    public SearchTemplateBase() {
    }

    public SearchTemplateBase(TaskTemplate plan, SchedulingService scheduler, SearchFilterCommon config, Date lastran) {
        this.id = plan.getUid();
        this.name = plan.getDisplayName();
        this.priority = plan.getPriority();
        this.instanceIds = plan.getInstanceIds();
        this.alertAutomatically = plan.isAlertAutomatically();
        this.created = plan.getCreated();
        this.lastRan = lastran;
        Optional opt = scheduler.getScheduleForTemplate(this.id);
        this.schedule = opt.isPresent() ? new WebSchedule((Schedule)opt.get()) : null;
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public JobPriority getPriority() {
        return this.priority;
    }

    public List<String> getInstanceIds() {
        return this.instanceIds;
    }

    public WebSchedule getSchedule() {
        return this.schedule;
    }

    public boolean isAlertAutomatically() {
        return this.alertAutomatically;
    }

    public Date getCreated() {
        return this.created;
    }

    public Date getLastRan() {
        return this.lastRan;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setPriority(JobPriority priority) {
        this.priority = priority;
    }

    public void setAlertAutomatically(boolean alertAutomatically) {
        this.alertAutomatically = alertAutomatically;
    }
}

