/*
 * Decompiled with CFR 0.152.
 */
package com.geolang.ascema.managerservice.rest.requests.tasks;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.geolang.ascema.domainmodelpublic.Confidence;
import com.geolang.ascema.domainmodelpublic.pattern.PatternContextWords;
import com.geolang.ascema.endpointcommon.domain.DeferredTime;
import com.geolang.ascema.endpointcommon.domain.DeferredTimeUnit;
import com.geolang.ascema.endpointcommon.domain.PatternConfig;
import com.geolang.ascema.endpointcommon.domain.actions.Action;
import com.geolang.ascema.endpointcommon.domain.actions.ActionCollection;
import com.geolang.ascema.endpointcommon.domain.searchconfig.SearchFilterCommon;
import com.geolang.ascema.managerdomain.domain.FileExtension;
import com.geolang.ascema.managerpersistence.ClassificationLabelStore;
import com.geolang.ascema.managerpersistence.ContextWordStore;
import com.geolang.ascema.managerpersistence.FileExtensionStore;
import com.geolang.ascema.managerservice.controllers.patterns.PatternService;
import com.geolang.ascema.managerservice.rest.requests.pattern.WebPattern;
import com.geolang.ascema.patternmatching.patterns.TruePattern;
import java.io.Serializable;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;

public class SearchFilterCommonWeb
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Set<String> extensionNames;
    private List<WebPattern> patterns;
    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="yyyy-MM-dd")
    private LocalDate startModifyDate;
    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="yyyy-MM-dd")
    private LocalDate endModifyDate;
    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="yyyy-MM-dd")
    private LocalDate startCreateDate;
    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="yyyy-MM-dd")
    private LocalDate endCreateDate;
    private boolean applyActionsAutomatically;
    private boolean undoActionsAutomatically;
    private boolean applyActionsDeferred;
    private int deferredUnit;
    private int deferredTimeValue;
    private List<Action> actions;
    private boolean searchByFilters;
    private boolean allFileExtensions;
    private List<String> classifications;
    private boolean allClassifications;

    public SearchFilterCommonWeb() {
    }

    public SearchFilterCommonWeb(SearchFilterCommon in, PatternService patternService) {
        this.startModifyDate = in.getStartModifyDate().isPresent() ? (LocalDate)in.getStartModifyDate().get() : null;
        this.endModifyDate = in.getEndModifyDate().isPresent() ? (LocalDate)in.getEndModifyDate().get() : null;
        this.startCreateDate = in.getStartCreateDate().isPresent() ? (LocalDate)in.getStartCreateDate().get() : null;
        this.endCreateDate = in.getEndCreateDate().isPresent() ? (LocalDate)in.getEndCreateDate().get() : null;
        this.extensionNames = in.getExtensionNames();
        this.patterns = new ArrayList();
        this.searchByFilters = in.isSearchByFilters();
        this.allFileExtensions = in.isAllFileExtensions();
        this.allClassifications = in.isAllClassifications();
        this.classifications = new ArrayList();
        if (in.getClassifications() != null) {
            this.classifications.addAll(in.getClassifications());
        }
        for (PatternConfig s : in.getPatterns()) {
            Optional pat = patternService.getWebpatternFromConfig(s);
            if (!pat.isPresent()) continue;
            this.patterns.add((WebPattern)pat.get());
        }
        ActionCollection ac = in.getActions();
        if (ac != null) {
            this.applyActionsAutomatically = ac.isApplyAutomatically();
            this.undoActionsAutomatically = ac.isUndoAutomatically();
            this.applyActionsDeferred = ac.isApplyActionsDeferred();
            DeferredTime dt = ac.getDeferredTime();
            if (dt != null) {
                this.deferredUnit = dt.getUnit().ordinal();
                this.deferredTimeValue = dt.getValue();
            }
            this.actions = ac.getActions();
        } else {
            this.actions = new ArrayList();
        }
    }

    public SearchFilterCommon toSearchFilterCommon(FileExtensionStore fileExtManager, ContextWordStore contextWords, ClassificationLabelStore classStore) {
        SearchFilterCommon ret = new SearchFilterCommon();
        ret.setEndCreateDate(this.getEndCreateDate());
        ret.setEndModifyDate(this.getEndModifyDate());
        ret.setStartCreateDate(this.getStartCreateDate());
        ret.setStartModifyDate(this.getStartModifyDate());
        ret.setSearchByFilters(this.searchByFilters);
        ret.setAllFileExtensions(this.allFileExtensions);
        HashSet classNames = new HashSet();
        if (this.classifications != null) {
            classNames.addAll(this.classifications);
        }
        ret.setAllClassifications(this.allClassifications);
        ret.setClassifications(classNames);
        if (!this.allFileExtensions) {
            ret.setExtensionNames(this.extensionNames);
            HashSet extensions = new HashSet();
            for (String extName : this.extensionNames) {
                Optional fe = fileExtManager.getByName(extName);
                if (!fe.isPresent()) continue;
                extensions.addAll(((FileExtension)fe.get()).getCleanExtensions());
            }
            if (extensions.isEmpty()) {
                ret.setAllFileExtensions(true);
            }
            ret.setExtensions(extensions);
        }
        if (this.searchByFilters) {
            ret.setSearchByFilters(true);
            TruePattern truepat = new TruePattern();
            ret.addPattern(truepat.getName(), truepat.getDisplayName(), Confidence.HIGH, 1, PatternContextWords.empty());
        } else {
            for (WebPattern pat : this.patterns) {
                ret.addPattern(pat.getName(), pat.getDisplayName(), Confidence.values()[pat.getConfidence().id], pat.getMinMatches(), contextWords.getPatternContextWords(pat.getDisplayName()));
            }
        }
        ActionCollection ac = new ActionCollection();
        ac.setApplyActionsDeferred(this.applyActionsDeferred);
        ac.setApplyAutomatically(this.applyActionsAutomatically);
        ac.setUndoAutomatically(this.undoActionsAutomatically);
        if (this.applyActionsDeferred) {
            ac.setDeferredTime(new DeferredTime(DeferredTimeUnit.values()[this.deferredUnit], this.deferredTimeValue));
        }
        if (this.actions != null) {
            for (Action a : this.actions) {
                ac.addAction(a);
            }
        }
        ret.setActions(ac);
        return ret;
    }

    public Set<String> getExtensionNames() {
        return this.extensionNames;
    }

    public void setExtensionNames(Set<String> extensionNames) {
        this.extensionNames = extensionNames;
    }

    public List<WebPattern> getPatterns() {
        return this.patterns;
    }

    public void setPatterns(List<WebPattern> patterns) {
        this.patterns = patterns;
    }

    public LocalDate getStartModifyDate() {
        return this.startModifyDate;
    }

    public void setStartModifyDate(LocalDate startModifyDate) {
        this.startModifyDate = startModifyDate;
    }

    public LocalDate getEndModifyDate() {
        return this.endModifyDate;
    }

    public void setEndModifyDate(LocalDate endModifyDate) {
        this.endModifyDate = endModifyDate;
    }

    public LocalDate getStartCreateDate() {
        return this.startCreateDate;
    }

    public void setStartCreateDate(LocalDate startCreateDate) {
        this.startCreateDate = startCreateDate;
    }

    public LocalDate getEndCreateDate() {
        return this.endCreateDate;
    }

    public void setEndCreateDate(LocalDate endCreateDate) {
        this.endCreateDate = endCreateDate;
    }

    public boolean isApplyActionsAutomatically() {
        return this.applyActionsAutomatically;
    }

    public void setApplyActionsAutomatically(boolean applyActionsAutomatically) {
        this.applyActionsAutomatically = applyActionsAutomatically;
    }

    public boolean isUndoActionsAutomatically() {
        return this.undoActionsAutomatically;
    }

    public void setUndoActionsAutomatically(boolean undoActionsAutomatically) {
        this.undoActionsAutomatically = undoActionsAutomatically;
    }

    public boolean isApplyActionsDeferred() {
        return this.applyActionsDeferred;
    }

    public void setApplyActionsDeferred(boolean applyActionsDeferred) {
        this.applyActionsDeferred = applyActionsDeferred;
    }

    public int getDeferredUnit() {
        return this.deferredUnit;
    }

    public void setDeferredUnit(int deferredUnit) {
        this.deferredUnit = deferredUnit;
    }

    public int getDeferredTimeValue() {
        return this.deferredTimeValue;
    }

    public void setDeferredTimeValue(int deferredTimeValue) {
        this.deferredTimeValue = deferredTimeValue;
    }

    public List<Action> getActions() {
        return this.actions;
    }

    public void setActions(List<Action> actions) {
        this.actions = actions;
    }

    public boolean isSearchByFilters() {
        return this.searchByFilters;
    }

    public void setSearchByFilters(boolean searchByFilters) {
        this.searchByFilters = searchByFilters;
    }

    public boolean isAllFileExtensions() {
        return this.allFileExtensions;
    }

    public void setAllFileExtensions(boolean allFileExtensions) {
        this.allFileExtensions = allFileExtensions;
    }

    public List<String> getClassifications() {
        return this.classifications;
    }

    public void setClassifications(List<String> classifications) {
        this.classifications = classifications;
    }

    public boolean isAllClassifications() {
        return this.allClassifications;
    }

    public void setAllClassifications(boolean allClassifications) {
        this.allClassifications = allClassifications;
    }
}

