/*
 * Decompiled with CFR 0.152.
 */
package com.geolang.ascema.managerservice.rest.requests.tasks;

import com.geolang.ascema.endpointcommon.domain.JobState;
import com.geolang.ascema.endpointcommon.domain.RTCommand;
import com.geolang.ascema.managerdomain.domain.DeviceRegistration;
import com.geolang.ascema.managerdomain.domain.JobDeviceState;
import com.geolang.ascema.managerdomain.domain.TaskInstance;
import com.geolang.ascema.managerdomain.web.WebJobState;
import com.geolang.ascema.managerservice.controllers.devices.DeviceService;
import com.geolang.ascema.managerservice.controllers.patterns.PatternService;
import com.geolang.ascema.managerservice.controllers.tasks.TaskManager;
import com.geolang.ascema.managerservice.rest.requests.tasks.RTConfig;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class RTTaskInstance
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String id;
    private String name;
    private RTConfig config;
    private List<String> deviceIds;
    private boolean runOnAllDevices;
    private List<WebJobState> states;
    private boolean alertAutomatically;
    private String actionIgnorePathsName;
    private Date created;

    public RTTaskInstance() {
    }

    public RTTaskInstance(TaskInstance plan, DeviceService controller, PatternService patternService, TaskManager taskManager) {
        this.id = plan.getUid();
        this.name = plan.getDisplayName();
        this.alertAutomatically = plan.isAlertAutomatically();
        this.runOnAllDevices = plan.isRunOnallDevices();
        this.actionIgnorePathsName = plan.getActionIgnorePathsName();
        this.created = plan.getCreated();
        RTCommand sc = (RTCommand)plan.getCommand();
        this.states = new ArrayList();
        this.deviceIds = new ArrayList();
        for (JobDeviceState j : plan.getDeviceStates()) {
            JobState state = j.getState();
            String devicename = "";
            String deviceid = j.getDeviceId();
            this.deviceIds.add(deviceid);
            Optional reg = controller.getDeviceFromId(j.getDeviceId(), true);
            if (reg.isPresent()) {
                DeviceRegistration dr = (DeviceRegistration)reg.get();
                if (!dr.isConnected()) {
                    state = JobState.NOT_AVAILABLE;
                }
                devicename = dr.getDeviceDescription();
            } else {
                state = JobState.NOT_AVAILABLE;
            }
            this.states.add(new WebJobState(deviceid, devicename, state, j.getFilesSearched(), j.getBytesSearched(), j.getSearchDurationSeconds()));
        }
        this.config = new RTConfig(sc.getConfig(), patternService);
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public RTConfig getConfig() {
        return this.config;
    }

    public void setConfig(RTConfig config) {
        this.config = config;
    }

    public List<String> getDeviceIds() {
        return this.deviceIds;
    }

    public void setDeviceIds(List<String> deviceIds) {
        this.deviceIds = deviceIds;
    }

    public boolean isRunOnAllDevices() {
        return this.runOnAllDevices;
    }

    public void setRunOnAllDevices(boolean runOnAllDevices) {
        this.runOnAllDevices = runOnAllDevices;
    }

    public List<WebJobState> getStates() {
        return this.states;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setStates(List<WebJobState> states) {
        this.states = states;
    }

    public boolean isAlertAutomatically() {
        return this.alertAutomatically;
    }

    public void setAlertAutomatically(boolean alertAutomatically) {
        this.alertAutomatically = alertAutomatically;
    }

    public String getActionIgnorePathsName() {
        return this.actionIgnorePathsName;
    }

    public void setActionIgnorePathsName(String actionIgnorePathsName) {
        this.actionIgnorePathsName = actionIgnorePathsName;
    }

    public Date getCreated() {
        return this.created;
    }

    public void setCreated(Date created) {
        this.created = created;
    }

    public int hashCode() {
        int hash = 7;
        hash = 37 * hash + Objects.hashCode(this.id);
        hash = 37 * hash + Objects.hashCode(this.name);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RTTaskInstance other = (RTTaskInstance)obj;
        if (!Objects.equals(this.id, other.id)) {
            return false;
        }
        return Objects.equals(this.name, other.name);
    }

    public String toString() {
        return "RTTaskInstance{id=" + this.id + ", name=" + this.name + ", config=" + String.valueOf(this.config) + ", deviceIds=" + String.valueOf(this.deviceIds) + ", runOnAllDevices=" + this.runOnAllDevices + ", states=" + String.valueOf(this.states) + "}";
    }
}

