/*
 * Decompiled with CFR 0.152.
 */
package com.geolang.ascema.managerservice.rest.requests.tasks;

import com.geolang.ascema.endpointcommon.domain.searchconfig.AlfrescoSearchConfiguration;
import com.geolang.ascema.endpointcommon.domain.searchconfig.AtlassianSearchConfiguration;
import com.geolang.ascema.endpointcommon.domain.searchconfig.GoogleSearchConfiguration;
import com.geolang.ascema.endpointcommon.domain.searchconfig.O365SearchConfiguration;
import com.geolang.ascema.endpointcommon.domain.searchconfig.SearchFilterCommon;
import com.geolang.ascema.endpointcommon.domain.searchconfig.rt.RTEndpointSearchConfiguration;
import com.geolang.ascema.endpointcommon.domain.searchconfig.rt.RTSearchConfiguration;
import com.geolang.ascema.managerdomain.web.RTEndpointFilter;
import com.geolang.ascema.managerpersistence.ClassificationLabelStore;
import com.geolang.ascema.managerpersistence.ContextWordStore;
import com.geolang.ascema.managerpersistence.FileExtensionStore;
import com.geolang.ascema.managerservice.controllers.patterns.PatternService;
import com.geolang.ascema.managerservice.rest.requests.alfresco.AlfrescoSearchFilter;
import com.geolang.ascema.managerservice.rest.requests.atlassian.AtlassianSearchFilter;
import com.geolang.ascema.managerservice.rest.requests.google.GoogleSearchFilter;
import com.geolang.ascema.managerservice.rest.requests.o365.O365SearchFilter;
import com.geolang.ascema.managerservice.rest.requests.tasks.SearchFilterCommonWeb;
import java.io.Serializable;

public class RTConfig
implements Serializable {
    private static final long serialVersionUID = 1L;
    private SearchFilterCommonWeb commonFilter;
    private RTEndpointFilter endpointFilter;
    private AlfrescoSearchFilter alfrescoFilter;
    private O365SearchFilter o365Filter;
    private AtlassianSearchFilter atlassianFilter;
    private GoogleSearchFilter googleFilter;

    public RTConfig() {
    }

    public RTConfig(RTSearchConfiguration in, PatternService patternService) {
        this.commonFilter = in.getCommon() != null ? new SearchFilterCommonWeb(in.getCommon(), patternService) : null;
        this.endpointFilter = in.getEndpoint() != null ? new RTEndpointFilter(in.getEndpoint()) : null;
        this.alfrescoFilter = in.getAlfresco() != null ? new AlfrescoSearchFilter(in.getAlfresco()) : null;
        this.o365Filter = in.getO365() != null ? new O365SearchFilter(in.getO365()) : null;
        this.googleFilter = in.getGoogle() != null ? new GoogleSearchFilter(in.getGoogle()) : null;
        this.atlassianFilter = in.getAtlassian() != null ? new AtlassianSearchFilter(in.getAtlassian()) : null;
    }

    public RTSearchConfiguration toRTProtectConfiguration(FileExtensionStore fileExtManager, ContextWordStore contextWords, ClassificationLabelStore classStore) {
        SearchFilterCommon common = this.commonFilter == null ? null : this.commonFilter.toSearchFilterCommon(fileExtManager, contextWords, classStore);
        RTEndpointSearchConfiguration endpoint = this.endpointFilter == null ? null : this.endpointFilter.toRTEndpointSearchConfiguration();
        O365SearchConfiguration o365 = this.o365Filter == null ? null : this.o365Filter.toConfig();
        AlfrescoSearchConfiguration alfresco = this.alfrescoFilter == null ? null : this.alfrescoFilter.toConfig();
        AtlassianSearchConfiguration atlassian = this.atlassianFilter == null ? null : this.atlassianFilter.toConfig();
        GoogleSearchConfiguration google = this.googleFilter == null ? null : this.googleFilter.toConfig();
        RTSearchConfiguration ret = new RTSearchConfiguration(common, endpoint, o365, alfresco, atlassian, google);
        return ret;
    }

    public SearchFilterCommonWeb getCommonFilter() {
        return this.commonFilter;
    }

    public void setCommonFilter(SearchFilterCommonWeb commonFilter) {
        this.commonFilter = commonFilter;
    }

    public RTEndpointFilter getEndpointFilter() {
        return this.endpointFilter;
    }

    public void setEndpointFilter(RTEndpointFilter endpointFilter) {
        this.endpointFilter = endpointFilter;
    }

    public AlfrescoSearchFilter getAlfrescoFilter() {
        return this.alfrescoFilter;
    }

    public void setAlfrescoFilter(AlfrescoSearchFilter alfrescoFilter) {
        this.alfrescoFilter = alfrescoFilter;
    }

    public O365SearchFilter getO365Filter() {
        return this.o365Filter;
    }

    public void setO365Filter(O365SearchFilter o365Filter) {
        this.o365Filter = o365Filter;
    }

    public AtlassianSearchFilter getAtlassianFilter() {
        return this.atlassianFilter;
    }

    public void setAtlassianFilter(AtlassianSearchFilter atlassianFilter) {
        this.atlassianFilter = atlassianFilter;
    }

    public GoogleSearchFilter getGoogleFilter() {
        return this.googleFilter;
    }

    public void setGoogleFilter(GoogleSearchFilter googleFilter) {
        this.googleFilter = googleFilter;
    }
}

