/*
 * Decompiled with CFR 0.152.
 */
package com.geolang.ascema.managerservice.rest.requests.tasks;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.geolang.ascema.endpointcommon.database.DatabaseCredentials;
import com.geolang.ascema.endpointcommon.database.DatabaseSearchCommand;
import com.geolang.ascema.endpointcommon.domain.searchconfig.DatabaseSearchConfiguration;
import com.geolang.ascema.endpointcommon.domain.searchconfig.SearchFilterCommon;
import com.geolang.ascema.managerdomain.domain.DatabaseCredentialStored;
import com.geolang.ascema.managerdomain.domain.TaskTemplate;
import com.geolang.ascema.managerdomain.web.DatabaseSearchFilter;
import com.geolang.ascema.managerdomain.web.WebSavedDatabaseCredentials;
import com.geolang.ascema.managerpersistence.ClassificationLabelStore;
import com.geolang.ascema.managerpersistence.ContextWordStore;
import com.geolang.ascema.managerpersistence.DatabaseCredentialsStore;
import com.geolang.ascema.managerpersistence.FileExtensionStore;
import com.geolang.ascema.managerservice.controllers.SchedulingService;
import com.geolang.ascema.managerservice.controllers.patterns.PatternService;
import com.geolang.ascema.managerservice.rest.requests.tasks.SearchFilterCommonWeb;
import com.geolang.ascema.managerservice.rest.requests.tasks.SearchTemplateBase;
import java.io.Serializable;
import java.util.Date;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DatabaseSearchJobTemplate
extends SearchTemplateBase
implements Serializable {
    private static final long serialVersionUID = 1L;
    private SearchFilterCommonWeb commonFilter;
    private DatabaseSearchFilter searchFilter;
    private int lastDurationSeconds;
    private int maxDurationSeconds;

    public DatabaseSearchJobTemplate() {
    }

    public DatabaseSearchJobTemplate(TaskTemplate plan, SchedulingService scheduler, PatternService patternService, DatabaseCredentialsStore dbcredsStore, Date lastRan) {
        super(plan, scheduler, ((DatabaseSearchCommand)plan.getBaseCommand()).getConfig().getCommonFilter(), lastRan);
        DatabaseSearchCommand sc = (DatabaseSearchCommand)plan.getBaseCommand();
        DatabaseSearchConfiguration config = sc.getConfig();
        this.commonFilter = config.getCommonFilter() != null ? new SearchFilterCommonWeb(config.getCommonFilter(), patternService) : null;
        Optional opt = dbcredsStore.getByName(config.getCredentialsDisplayName());
        WebSavedDatabaseCredentials creds = null;
        if (opt.isEmpty()) {
            Logger.getLogger(DatabaseSearchJobTemplate.class.getName()).log(Level.WARNING, "Failed to find saved db credentials {0}", config.getCredentialsDisplayName());
            try {
                DatabaseCredentialStored dummy = new DatabaseCredentialStored(config.getCredentialsDisplayName(), DatabaseCredentials.fromJSON((String)config.getDbCredentials()), "unknown");
                creds = new WebSavedDatabaseCredentials(dummy);
                creds.setInUse(true);
            }
            catch (JsonProcessingException ex) {
                Logger.getLogger(DatabaseSearchJobTemplate.class.getName()).log(Level.SEVERE, null, ex);
            }
        } else {
            creds = new WebSavedDatabaseCredentials((DatabaseCredentialStored)opt.get());
            creds.setInUse(true);
        }
        this.searchFilter = new DatabaseSearchFilter(creds, config.getQuery());
        this.lastDurationSeconds = plan.getLastDurationSeconds();
        this.maxDurationSeconds = plan.getMaxDurationSeconds();
    }

    public SearchFilterCommonWeb getCommonFilter() {
        return this.commonFilter;
    }

    public DatabaseSearchFilter getSearchFilter() {
        return this.searchFilter;
    }

    public int getLastDurationSeconds() {
        return this.lastDurationSeconds;
    }

    public int getMaxDurationSeconds() {
        return this.maxDurationSeconds;
    }

    public DatabaseSearchConfiguration toConfig(FileExtensionStore fileExtManager, ContextWordStore contextWords, ClassificationLabelStore classStore) {
        SearchFilterCommon common = null;
        if (this.getCommonFilter() != null) {
            common = this.getCommonFilter().toSearchFilterCommon(fileExtManager, contextWords, classStore);
        }
        WebSavedDatabaseCredentials creds = this.searchFilter.getDbCredentials();
        DatabaseSearchConfiguration config = new DatabaseSearchConfiguration(creds.getDisplayName(), creds.getJsonCredentials(), this.searchFilter.getQuery(), common);
        return config;
    }
}

