/*
 * Decompiled with CFR 0.152.
 */
package com.geolang.ascema.managerservice.rest.requests.tasks;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.geolang.ascema.endpointcommon.database.DatabaseCredentials;
import com.geolang.ascema.endpointcommon.domain.searchconfig.DatabaseSearchConfiguration;
import com.geolang.ascema.managerdomain.domain.DatabaseCredentialStored;
import com.geolang.ascema.managerdomain.domain.DeviceRegistration;
import com.geolang.ascema.managerdomain.domain.JobDeviceState;
import com.geolang.ascema.managerdomain.domain.TaskInstance;
import com.geolang.ascema.managerdomain.web.DatabaseSearchFilter;
import com.geolang.ascema.managerdomain.web.WebJobState;
import com.geolang.ascema.managerdomain.web.WebSavedDatabaseCredentials;
import com.geolang.ascema.managerpersistence.DatabaseCredentialsStore;
import com.geolang.ascema.managerservice.controllers.devices.DeviceService;
import com.geolang.ascema.managerservice.controllers.patterns.PatternService;
import com.geolang.ascema.managerservice.rest.requests.tasks.SearchFilterCommonWeb;
import java.io.Serializable;
import java.util.Date;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DatabaseSearchJobInstance
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String id;
    private String name;
    private int priority;
    private String deviceId;
    private WebJobState state;
    private int maxDurationSeconds;
    private SearchFilterCommonWeb commonFilter;
    private DatabaseSearchFilter searchFilter;
    private Date created;
    private String templateId;

    public DatabaseSearchJobInstance() {
    }

    public DatabaseSearchJobInstance(TaskInstance plan, DatabaseSearchConfiguration config, DeviceService controller, PatternService patternService, DatabaseCredentialsStore dbcredsStore) {
        this.id = plan.getUid();
        this.name = plan.getDisplayName();
        this.templateId = plan.getParentTemplateId();
        this.created = plan.getCreated();
        this.commonFilter = new SearchFilterCommonWeb(config.getCommonFilter(), patternService);
        Optional opt = dbcredsStore.getByName(config.getCredentialsDisplayName());
        WebSavedDatabaseCredentials creds = null;
        if (opt.isEmpty()) {
            Logger.getLogger(DatabaseSearchJobInstance.class.getName()).log(Level.WARNING, "Failed to find saved db credentials {0}", config.getCredentialsDisplayName());
            try {
                DatabaseCredentialStored dummy = new DatabaseCredentialStored(config.getCredentialsDisplayName(), DatabaseCredentials.fromJSON((String)config.getDbCredentials()), "unknown");
                creds = new WebSavedDatabaseCredentials(dummy);
                creds.setInUse(true);
            }
            catch (JsonProcessingException ex) {
                Logger.getLogger(DatabaseSearchJobInstance.class.getName()).log(Level.SEVERE, null, ex);
            }
        } else {
            creds = new WebSavedDatabaseCredentials((DatabaseCredentialStored)opt.get());
            creds.setInUse(true);
        }
        this.searchFilter = new DatabaseSearchFilter(creds, config.getQuery());
        this.priority = plan.getPriority().ordinal();
        this.maxDurationSeconds = plan.maxDurationSeconds();
        for (JobDeviceState j : plan.getDeviceStates()) {
            String devicename = "";
            this.deviceId = j.getDeviceId();
            Optional reg = controller.getDeviceFromId(j.getDeviceId(), true);
            if (reg.isPresent()) {
                devicename = ((DeviceRegistration)reg.get()).getDeviceDescription();
            }
            this.state = new WebJobState(this.deviceId, devicename, j.getState(), j.getFilesSearched(), j.getBytesSearched(), j.getSearchDurationSeconds());
        }
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public int getPriority() {
        return this.priority;
    }

    public SearchFilterCommonWeb getCommonFilter() {
        return this.commonFilter;
    }

    public String getTemplateId() {
        return this.templateId;
    }

    public Date getCreated() {
        return this.created;
    }

    public String getDeviceId() {
        return this.deviceId;
    }

    public WebJobState getState() {
        return this.state;
    }

    public DatabaseSearchFilter getSearchFilter() {
        return this.searchFilter;
    }

    public int getMaxDurationSeconds() {
        return this.maxDurationSeconds;
    }
}

