/*
 * Decompiled with CFR 0.152.
 */
package com.geolang.ascema.managerservice.rest.requests.retrieval;

import com.geolang.ascema.endpointcommon.domain.BaseCommand;
import com.geolang.ascema.endpointcommon.domain.searchconfig.SearchFilterCommon;
import com.geolang.ascema.managerdomain.domain.SubRepoTask;
import com.geolang.ascema.managerdomain.retrieval.EndpointSearchCommand;
import com.geolang.ascema.managerdomain.web.SearchFilter;
import com.geolang.ascema.managerservice.controllers.patterns.PatternService;
import com.geolang.ascema.managerservice.rest.requests.tasks.SearchFilterCommonWeb;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class SubRepoTemplate
implements Serializable {
    private static final long serialVersionUID = 42L;
    private SearchFilterCommonWeb common;
    private SearchFilter filter;
    private String id;
    private String name;
    private String retrievalTaskInstanceId;
    private String parentSubRepoTaskId;
    private final List<SubRepoTemplate> children = new ArrayList();

    public SubRepoTemplate() {
    }

    public SubRepoTemplate(SubRepoTask plan, PatternService patternService) {
        this.id = plan.getUid();
        this.name = plan.getDisplayName();
        this.retrievalTaskInstanceId = plan.getParentInstanceId();
        this.parentSubRepoTaskId = plan.getParentSubRepoTaskId();
        if (plan.isRepoFromSubSearch()) {
            EndpointSearchCommand sc = (EndpointSearchCommand)plan.getSubSearchCommand().get();
            this.common = new SearchFilterCommonWeb(sc.getSearchCommon(), patternService);
            this.filter = new SearchFilter(sc.getConfig());
        }
    }

    public SubRepoTemplate(SubRepoTask plan, PatternService patternService, BaseCommand parent) {
        this.id = plan.getUid();
        this.name = plan.getDisplayName();
        this.retrievalTaskInstanceId = plan.getParentInstanceId();
        this.parentSubRepoTaskId = plan.getParentSubRepoTaskId();
        if (plan.isRepoFromSubSearch()) {
            EndpointSearchCommand sc = (EndpointSearchCommand)plan.getSubSearchCommand().get();
            this.common = new SearchFilterCommonWeb(sc.getSearchCommon(), patternService);
            this.filter = new SearchFilter(sc.getConfig());
        } else {
            this.common = parent.getCommonFilter().isPresent() ? new SearchFilterCommonWeb((SearchFilterCommon)parent.getCommonFilter().get(), patternService) : null;
        }
    }

    public SearchFilter getFilter() {
        return this.filter;
    }

    public void setFilter(SearchFilter filter) {
        this.filter = filter;
    }

    public SearchFilterCommonWeb getCommon() {
        return this.common;
    }

    public void setCommon(SearchFilterCommonWeb common) {
        this.common = common;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getRetrievalTaskInstanceId() {
        return this.retrievalTaskInstanceId;
    }

    public void setRetrievalTaskInstanceId(String retrievalTaskInstanceId) {
        this.retrievalTaskInstanceId = retrievalTaskInstanceId;
    }

    public String getParentSubRepoTaskId() {
        return this.parentSubRepoTaskId;
    }

    public void setParentSubRepoTaskId(String parentSubRepoTaskId) {
        this.parentSubRepoTaskId = parentSubRepoTaskId;
    }

    public List<SubRepoTemplate> getChildren() {
        return this.children;
    }
}

