/*
 * Decompiled with CFR 0.152.
 */
package com.geolang.ascema.managerservice.rest.requests.pattern;

import com.geolang.ascema.domainmodelpublic.Confidence;
import com.geolang.ascema.domainmodelpublic.pattern.SpecialPatternType;
import com.geolang.ascema.managerdomain.datapoint.WebConfidenceLevel;
import com.geolang.ascema.managerdomain.web.PatternType;
import com.geolang.ascema.managerservice.controllers.patterns.Pattern;
import com.geolang.ascema.managerservice.controllers.patterns.PatternService;
import java.io.Serializable;
import java.util.Set;

public class WebPattern
implements Serializable {
    private static final long serialVersionUID = 1L;
    private WebConfidenceLevel confidence;
    private int patternType;
    private int minMatches;
    private String name;
    private String displayName;
    private String group;
    private String description;
    private boolean isKeyword;
    private boolean isSimilar;
    private boolean isKeywordList;
    private boolean isRegex;
    private boolean isFileName;
    private boolean isMetadata;
    private boolean isMipsLabel;
    private boolean isSaved;
    private Set<String> defaultClassificationLabels;
    private Set<String> classificationLabels;
    private Set<String> defaultContextWords;
    private boolean hasCustomContextWords;
    private boolean hasCustomClassificationLabels;

    public WebPattern(Pattern p, boolean saved, PatternService service) {
        this(p, service);
        this.isSaved = saved;
        if (saved) {
            this.group = "Saved";
        }
    }

    public WebPattern(Pattern p, PatternService service) {
        this.confidence = WebConfidenceLevel.fromConfidence((Confidence)p.getMinConfidence());
        this.minMatches = p.getMinMatches();
        this.name = p.getName();
        this.displayName = p.getDisplayName();
        this.group = p.getCountryName();
        this.description = p.getDescription();
        SpecialPatternType spt = p.getSpecialPatternType();
        this.patternType = PatternType.fromSpecialPatternType((SpecialPatternType)spt).getId();
        this.isSaved = false;
        this.isKeyword = spt.equals((Object)SpecialPatternType.KEYWORD);
        this.isSimilar = spt.equals((Object)SpecialPatternType.SIMILAR_FILE);
        this.isKeywordList = spt.equals((Object)SpecialPatternType.LISTKEYWORD);
        this.isRegex = spt.equals((Object)SpecialPatternType.REGEX);
        this.isFileName = spt.equals((Object)SpecialPatternType.FILENAME);
        this.isMetadata = spt.equals((Object)SpecialPatternType.METADATA);
        this.isMipsLabel = spt.equals((Object)SpecialPatternType.MIPS_LABEL);
        this.defaultContextWords = p.getDefaultContextWords();
        this.classificationLabels = service.getClassificationLabels(p.getDisplayName());
        this.hasCustomClassificationLabels = !this.classificationLabels.isEmpty();
        this.defaultClassificationLabels = p.getTags();
        if (this.classificationLabels.isEmpty()) {
            this.classificationLabels = p.getTags();
        }
        this.hasCustomContextWords = service.hasSavedContextWords(p.getDisplayName());
    }

    public WebPattern() {
    }

    public String getName() {
        return this.name;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getGroup() {
        return this.group;
    }

    public String getDescription() {
        return this.description;
    }

    public WebConfidenceLevel getConfidence() {
        return this.confidence;
    }

    public int getPatternType() {
        return this.patternType;
    }

    public boolean isIsFileName() {
        return this.isFileName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public boolean isIsKeyword() {
        return this.isKeyword;
    }

    public boolean isIsSimilar() {
        return this.isSimilar;
    }

    public boolean isIsKeywordList() {
        return this.isKeywordList;
    }

    public boolean isIsRegex() {
        return this.isRegex;
    }

    public boolean isIsMetadata() {
        return this.isMetadata;
    }

    public boolean isIsMipsLabel() {
        return this.isMipsLabel;
    }

    public int getMinMatches() {
        return this.minMatches;
    }

    public void setMinMatches(int minMatches) {
        this.minMatches = minMatches;
    }

    public Set<String> getClassificationLabels() {
        return this.classificationLabels;
    }

    public void setClassificationLabels(Set<String> classificationLabels) {
        this.classificationLabels = classificationLabels;
    }

    public boolean isIsSaved() {
        return this.isSaved;
    }

    public void setIsSaved(boolean isSaved) {
        this.isSaved = isSaved;
    }

    public Set<String> getDefaultContextWords() {
        return this.defaultContextWords;
    }

    public boolean isHasCustomContextWords() {
        return this.hasCustomContextWords;
    }

    public void setHasCustomContextWords(boolean hasCustomContextWords) {
        this.hasCustomContextWords = hasCustomContextWords;
    }

    public boolean isHasCustomClassificationLabels() {
        return this.hasCustomClassificationLabels;
    }

    public void setHasCustomClassificationLabels(boolean hasCustomClassificationLabels) {
        this.hasCustomClassificationLabels = hasCustomClassificationLabels;
    }

    public Set<String> getDefaultClassificationLabels() {
        return this.defaultClassificationLabels;
    }
}

