/*
 * Decompiled with CFR 0.152.
 */
package com.geolang.ascema.managerservice.rest.requests.o365;

import com.geolang.ascema.endpointcommon.domain.DeviceType;
import com.geolang.ascema.indexingcommon.endpoint.cloudcommon.CloudGroup;
import com.geolang.ascema.indexingcommon.endpoint.cloudcommon.CloudUser;
import java.io.Serializable;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;

public class CloudUsersAndGroups
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final TreeSet<CloudUser> users;
    private final TreeSet<CloudGroup> groups;
    private final int deviceType;

    public CloudUsersAndGroups(Set<CloudUser> users, Set<CloudGroup> groups, DeviceType type) {
        this.users = new TreeSet<CloudUser>(users);
        this.groups = new TreeSet<CloudGroup>(groups);
        this.deviceType = type.ordinal();
    }

    public Set<CloudUser> getUsers() {
        return this.users;
    }

    public Set<CloudGroup> getGroups() {
        return this.groups;
    }

    public int getDeviceType() {
        return this.deviceType;
    }

    public List<CloudGroup> getGroupsStartingWith(String prefix) {
        return this.groups.stream().filter(u -> this.startsWithIgnoreCase(u.getDisplayName(), prefix) || this.startsWithIgnoreCase(u.getEmail(), prefix)).collect(Collectors.toList());
    }

    public List<CloudUser> getUsersStartingWith(String prefix) {
        return this.users.stream().filter(u -> this.startsWithIgnoreCase(u.getDisplayName(), prefix) || this.startsWithIgnoreCase(u.getEmail(), prefix)).collect(Collectors.toList());
    }

    private boolean startsWithIgnoreCase(String str, String prefix) {
        return str != null && prefix != null && str.length() >= prefix.length() && str.regionMatches(true, 0, prefix, 0, prefix.length());
    }
}

