/*
 * Decompiled with CFR 0.152.
 */
package com.geolang.ascema.managerservice.rest.requests.atlassian;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.geolang.ascema.endpointcommon.domain.clouditems.AtlassianSpace;
import com.geolang.ascema.endpointcommon.domain.clouditems.BitbucketRepo;
import com.geolang.ascema.endpointcommon.domain.clouditems.JiraProject;
import com.geolang.ascema.endpointcommon.domain.searchconfig.AtlassianSearchConfiguration;
import com.geolang.ascema.indexingcommon.endpoint.atlassian.BitbucketHistoryType;
import com.geolang.ascema.managerdomain.web.WebAlertingConfig;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.Set;

public class AtlassianSearchFilter
implements Serializable {
    private static final long serialVersionUID = 1L;
    boolean searchConfluence;
    boolean searchJira;
    boolean searchBitbucket;
    private boolean searchConfluencePages;
    private boolean searchConfluenceComments;
    private boolean searchConfluenceBlog;
    private boolean searchConfluenceAttachments;
    private boolean searchAllSpaces;
    private Set<AtlassianSpace> specificSpaces;
    private boolean searchJiraIssues;
    private boolean searchJiraAttachments;
    private boolean searchJiraComments;
    private boolean searchJiraWorkflows;
    private boolean searchJiraHistory;
    private boolean searchAllProjects;
    private Set<JiraProject> specificProjects;
    private boolean searchAllRepos;
    private Set<BitbucketRepo> specificRepos;
    private int historyType;
    private int historyDepth;
    private boolean searchPullRequests;
    private boolean searchBitbucketComments;
    private boolean onlySearchDefaultBranch;
    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="yyyy-MM-dd HH:mm:ss")
    private LocalDateTime historyFromDate;
    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="yyyy-MM-dd HH:mm:ss")
    private LocalDateTime historyToDate;
    private boolean searchAllVersions;
    private WebAlertingConfig alertConfig;

    public AtlassianSearchFilter() {
    }

    public AtlassianSearchFilter(AtlassianSearchConfiguration config) {
        this.searchJira = config.isSearchJira();
        this.searchConfluence = config.isSearchConfluence();
        this.searchBitbucket = config.isSearchBitbucket();
        this.searchConfluencePages = config.isSearchPages();
        this.searchConfluenceComments = config.isSearchConfluenceComments();
        this.searchConfluenceBlog = config.isSearchBlog();
        this.searchConfluenceAttachments = config.isSearchConfluenceAttachments();
        this.searchJiraAttachments = config.isSearchJiraAttachments();
        this.searchJiraComments = config.isSearchJiraComments();
        this.searchJiraWorkflows = config.isSearchJiraWorkflows();
        this.searchJiraIssues = config.isSearchJiraIssues();
        this.searchJiraHistory = config.isSearchJiraHistory();
        this.alertConfig = new WebAlertingConfig(config.getAlertConfig());
        this.searchAllSpaces = config.isSearchAllSpaces();
        this.specificSpaces = config.getSpecificSpaces();
        this.searchAllProjects = config.isSearchAllProjects();
        this.specificProjects = config.getSpecificProjects();
        this.searchAllVersions = config.isSearchAllVersions();
        this.searchAllRepos = config.isSearchAllRepos();
        this.specificRepos = config.getSpecificRepos();
        this.historyType = config.getHistoryType() == null ? BitbucketHistoryType.CURRENT.ordinal() : config.getHistoryType().ordinal();
        this.historyDepth = config.getHistoryDepth();
        this.historyFromDate = config.getHistoryFromDateTime();
        this.historyToDate = config.getHistoryToDateTime();
        this.searchPullRequests = config.isSearchPullRequests();
        this.searchBitbucketComments = config.isSearchBitbucketComments();
        this.onlySearchDefaultBranch = config.isOnlySearchDefaultBranch();
    }

    public AtlassianSearchConfiguration toConfig() {
        AtlassianSearchConfiguration config = new AtlassianSearchConfiguration();
        config.setSearchJira(this.searchJira);
        config.setSearchConfluence(this.searchConfluence);
        config.setSearchBitbucket(this.searchBitbucket);
        config.setSearchPages(this.isSearchConfluencePages());
        config.setSearchConfluenceAttachments(this.isSearchConfluenceAttachments());
        config.setSearchConfluenceComments(this.isSearchConfluenceComments());
        config.setSearchBlog(this.isSearchConfluenceBlog());
        config.setSearchJiraAttachments(this.searchJiraAttachments);
        config.setSearchJiraComments(this.searchJiraComments);
        config.setSearchJiraWorkflows(this.searchJiraWorkflows);
        config.setSearchJiraIssues(this.searchJiraIssues);
        config.setSearchJiraHistory(this.searchJiraHistory);
        config.setSearchAllVersions(this.searchAllVersions);
        config.setSearchAllSpaces(this.isSearchAllSpaces());
        config.setSpecificSpaces(this.getSpecificSpaces());
        config.setSearchAllProjects(this.searchAllProjects);
        config.setSpecificProjects(this.specificProjects);
        config.setAlertConfig(this.alertConfig.toAlertingConfig());
        config.setSearchAllRepos(this.searchAllRepos);
        config.setSpecificRepos(this.specificRepos);
        config.setHistoryType(BitbucketHistoryType.values()[this.historyType]);
        config.setHistoryDepth(this.historyDepth);
        config.setHistoryFromDateTime(this.historyFromDate);
        config.setHistoryToDateTime(this.historyToDate);
        config.setSearchPullRequests(this.searchPullRequests);
        config.setSearchBitbucketComments(this.searchBitbucketComments);
        config.setOnlySearchDefaultBranch(this.onlySearchDefaultBranch);
        return config;
    }

    public boolean isSearchConfluencePages() {
        return this.searchConfluencePages;
    }

    public void setSearchConfluencePages(boolean searchConfluencePages) {
        this.searchConfluencePages = searchConfluencePages;
    }

    public boolean isSearchConfluenceComments() {
        return this.searchConfluenceComments;
    }

    public void setSearchConfluenceComments(boolean searchConfluenceComments) {
        this.searchConfluenceComments = searchConfluenceComments;
    }

    public boolean isSearchConfluenceBlog() {
        return this.searchConfluenceBlog;
    }

    public void setSearchConfluenceBlog(boolean searchConfluenceBlog) {
        this.searchConfluenceBlog = searchConfluenceBlog;
    }

    public boolean isSearchConfluenceAttachments() {
        return this.searchConfluenceAttachments;
    }

    public void setSearchConfluenceAttachments(boolean searchConfluenceAttachments) {
        this.searchConfluenceAttachments = searchConfluenceAttachments;
    }

    public boolean isSearchAllSpaces() {
        return this.searchAllSpaces;
    }

    public void setSearchAllSpaces(boolean searchAllSpaces) {
        this.searchAllSpaces = searchAllSpaces;
    }

    public Set<AtlassianSpace> getSpecificSpaces() {
        return this.specificSpaces;
    }

    public void setSpecificSpaces(Set<AtlassianSpace> specificSpaces) {
        this.specificSpaces = specificSpaces;
    }

    public boolean isSearchAllVersions() {
        return this.searchAllVersions;
    }

    public WebAlertingConfig getAlertConfig() {
        return this.alertConfig;
    }

    public void setAlertConfig(WebAlertingConfig alertConfig) {
        this.alertConfig = alertConfig;
    }

    public boolean isSearchJiraIssues() {
        return this.searchJiraIssues;
    }

    public void setSearchJiraIssues(boolean searchJiraIssues) {
        this.searchJiraIssues = searchJiraIssues;
    }

    public boolean isSearchJiraHistory() {
        return this.searchJiraHistory;
    }

    public void setSearchJiraHistory(boolean searchJiraHistory) {
        this.searchJiraHistory = searchJiraHistory;
    }

    public boolean isSearchJiraAttachments() {
        return this.searchJiraAttachments;
    }

    public void setSearchJiraAttachments(boolean searchJiraAttachments) {
        this.searchJiraAttachments = searchJiraAttachments;
    }

    public boolean isSearchJiraComments() {
        return this.searchJiraComments;
    }

    public void setSearchJiraComments(boolean searchJiraComments) {
        this.searchJiraComments = searchJiraComments;
    }

    public boolean isSearchJiraWorkflows() {
        return this.searchJiraWorkflows;
    }

    public void setSearchJiraWorkflows(boolean searchJiraWorkflows) {
        this.searchJiraWorkflows = searchJiraWorkflows;
    }

    public boolean isSearchAllProjects() {
        return this.searchAllProjects;
    }

    public void setSearchAllProjects(boolean searchAllProjects) {
        this.searchAllProjects = searchAllProjects;
    }

    public Set<JiraProject> getSpecificProjects() {
        return this.specificProjects;
    }

    public void setSpecificProjects(Set<JiraProject> specificProjects) {
        this.specificProjects = specificProjects;
    }

    public boolean isSearchAllRepos() {
        return this.searchAllRepos;
    }

    public void setSearchAllRepos(boolean searchAllRepos) {
        this.searchAllRepos = searchAllRepos;
    }

    public Set<BitbucketRepo> getSpecificRepos() {
        return this.specificRepos;
    }

    public void setSpecificRepos(Set<BitbucketRepo> specificRepos) {
        this.specificRepos = specificRepos;
    }

    public int getHistoryType() {
        return this.historyType;
    }

    public void setHistoryType(int historyType) {
        this.historyType = historyType;
    }

    public int getHistoryDepth() {
        return this.historyDepth;
    }

    public void setHistoryDepth(int historyDepth) {
        this.historyDepth = historyDepth;
    }

    public LocalDateTime getHistoryFromDate() {
        return this.historyFromDate;
    }

    public void setHistoryFromDate(LocalDateTime historyFromDate) {
        this.historyFromDate = historyFromDate;
    }

    public LocalDateTime getHistoryToDate() {
        return this.historyToDate;
    }

    public void setHistoryToDate(LocalDateTime historyToDate) {
        this.historyToDate = historyToDate;
    }

    public boolean isSearchConfluence() {
        return this.searchConfluence;
    }

    public void setSearchConfluence(boolean searchConfluence) {
        this.searchConfluence = searchConfluence;
    }

    public boolean isSearchJira() {
        return this.searchJira;
    }

    public void setSearchJira(boolean searchJira) {
        this.searchJira = searchJira;
    }

    public boolean isSearchBitbucket() {
        return this.searchBitbucket;
    }

    public void setSearchBitbucket(boolean searchBitbucket) {
        this.searchBitbucket = searchBitbucket;
    }

    public boolean isSearchPullRequests() {
        return this.searchPullRequests;
    }

    public void setSearchPullRequests(boolean searchPullRequests) {
        this.searchPullRequests = searchPullRequests;
    }

    public boolean isSearchBitbucketComments() {
        return this.searchBitbucketComments;
    }

    public void setSearchBitbucketComments(boolean searchBitbucketComments) {
        this.searchBitbucketComments = searchBitbucketComments;
    }

    public boolean isOnlySearchDefaultBranch() {
        return this.onlySearchDefaultBranch;
    }

    public void setOnlySearchDefaultBranch(boolean onlySearchDefaultBranch) {
        this.onlySearchDefaultBranch = onlySearchDefaultBranch;
    }
}

