/*
 * Decompiled with CFR 0.152.
 */
package com.geolang.ascema.managerservice.rest.requests.alfresco;

import com.geolang.ascema.endpointcommon.domain.PlatformSubType;
import com.geolang.ascema.indexingcommon.endpoint.cloudcommon.ConnectionStatus;
import java.io.Serializable;

public class WebConnectionStatus
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final boolean connected;
    private final String reason;
    private final int subType;
    private final String connectedHostName;
    private final String displayName;

    public static WebConnectionStatus fromConnectionStatus(ConnectionStatus s) {
        return new WebConnectionStatus(s.getCredentialsDisplayName(), s.isStatus(), s.getStatusReason(), s.getSubType().ordinal(), s.getConnectedHostName());
    }

    private WebConnectionStatus(String display, boolean connected, String reason, int subType, String connectedHostName) {
        this.connected = connected;
        this.reason = reason;
        this.subType = subType;
        this.connectedHostName = connectedHostName;
        this.displayName = display;
    }

    public WebConnectionStatus(String display, boolean ok, String reason) {
        this.displayName = display;
        this.connected = ok;
        this.reason = reason;
        this.connectedHostName = "";
        this.subType = PlatformSubType.NONE.ordinal();
    }

    public boolean isConnected() {
        return this.connected;
    }

    public String getReason() {
        return this.reason;
    }

    public int getSubType() {
        return this.subType;
    }

    public String getConnectedHostName() {
        return this.connectedHostName;
    }

    public String getDisplayName() {
        return this.displayName;
    }
}

