/*
 * Decompiled with CFR 0.152.
 */
package com.geolang.ascema.managerservice.rest.asyncmessages;

import com.geolang.ascema.endpointcommon.domain.Progress;
import com.geolang.ascema.managerevents.ProgressEvent;
import com.geolang.ascema.managerservice.rest.asyncmessages.AsyncMessageType;
import com.geolang.ascema.managerservice.rest.asyncmessages.BaseMessage;
import java.io.Serializable;

public class JobProgress
extends BaseMessage
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final String deviceId;
    private final String taskId;
    private final long totalFiles;
    private final long totalSize;
    private final int percentageCompleteGuess;
    private final int totalChunks;
    private final int chunksComplete;
    private final int chunksCompleteWithError;
    private final long durationSeconds;

    public JobProgress(ProgressEvent ev) {
        super(AsyncMessageType.JOB_PROGRESS);
        this.deviceId = ev.getDeviceId();
        this.taskId = ev.getTaskId();
        Progress p = ev.getProgress();
        this.percentageCompleteGuess = p.getPercentageCompleteGuess();
        this.totalFiles = p.getTotalFiles();
        this.totalSize = p.getTotalSize();
        this.chunksComplete = p.getChunksComplete();
        this.totalChunks = p.getTotalChunks();
        this.chunksCompleteWithError = p.getChunksCompleteWithError();
        this.durationSeconds = p.getDurationSeconds();
    }

    public String getDeviceId() {
        return this.deviceId;
    }

    public String getTaskId() {
        return this.taskId;
    }

    public long getTotalFiles() {
        return this.totalFiles;
    }

    public long getTotalSize() {
        return this.totalSize;
    }

    public int getPercentageCompleteGuess() {
        return this.percentageCompleteGuess;
    }

    public int getTotalChunks() {
        return this.totalChunks;
    }

    public int getChunksComplete() {
        return this.chunksComplete;
    }

    public int getChunksCompleteWithError() {
        return this.chunksCompleteWithError;
    }

    public long getDurationSeconds() {
        return this.durationSeconds;
    }
}

