/*
 * Decompiled with CFR 0.152.
 */
package com.geolang.ascema.managerservice.rest;

import com.geolang.ascema.managerdomain.domain.Notification;
import com.geolang.ascema.managerdomain.web.ChangePwdRequest;
import com.geolang.ascema.managerdomain.web.RegisterUserRequest;
import com.geolang.ascema.managerdomain.web.SetSysAdminPassword;
import com.geolang.ascema.managerdomain.web.UserRole;
import com.geolang.ascema.managerdomain.web.WebUserNotification;
import com.geolang.ascema.managerpersistence.NotificationStore;
import com.geolang.ascema.managerservice.rest.exceptions.SysAdminAlreadySetException;
import com.geolang.ascema.managerservice.rest.security.RateLimiter;
import com.geolang.ascema.managerservice.rest.security.UserStore;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import jakarta.servlet.http.HttpServletRequest;
import java.beans.PropertyEditor;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.security.authentication.LockedException;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.web.bind.WebDataBinder;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.InitBinder;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/users"})
public class UserRestService {
    private static final Logger LOG = Logger.getLogger(UserRestService.class.getName());
    private final String SYS_ADMIN = "administrator";
    private final LoadingCache<String, RateLimiter> ipToRateLimitHintCache = CacheBuilder.newBuilder().expireAfterWrite(100L, TimeUnit.SECONDS).removalListener(removal -> ((RateLimiter)removal.getValue()).stop()).build((CacheLoader)new /* Unavailable Anonymous Inner Class!! */);
    @Autowired
    UserStore userStore;
    @Autowired
    NotificationStore notificationsStore;
    @Autowired
    private HttpServletRequest request;

    @CrossOrigin(origins={"*"}, maxAge=4800L, allowCredentials="false")
    @GetMapping(value={"/ping"})
    public boolean ping() {
        return true;
    }

    @RequestMapping(value={"/401"})
    public ResponseEntity<String> fourZeroOne() {
        Exception ex = (Exception)this.request.getAttribute("SPRING_SECURITY_LAST_EXCEPTION");
        if (ex instanceof LockedException) {
            return new ResponseEntity((Object)"Account is blocked after too many attempts. Try again in 15 minutes", (HttpStatusCode)HttpStatus.LOCKED);
        }
        return new ResponseEntity((Object)"Bad Credentials", (HttpStatusCode)HttpStatus.UNAUTHORIZED);
    }

    @PostMapping(value={"/sign-up"})
    public boolean signUp(@RequestBody RegisterUserRequest lr) {
        Optional ret = this.userStore.registerNewUserAccount(lr.getUser(), lr.getPass(), lr.getHint(), lr.isIsAdmin(), lr.isIsAuditor());
        return ret.isPresent();
    }

    @PostMapping(value={"/set-sysadmin-pass"})
    public void setSysAdminPassword(@RequestBody SetSysAdminPassword lr) {
        boolean sysadminexists;
        try {
            sysadminexists = this.userStore.loadUserByUsername("administrator") != null;
        }
        catch (UsernameNotFoundException ex) {
            sysadminexists = false;
        }
        if (sysadminexists) {
            throw new SysAdminAlreadySetException();
        }
        this.userStore.registerNewUserAccount("administrator", lr.getPass(), lr.getHint(), true, false);
    }

    @GetMapping(value={"/check/{user}"})
    public boolean exists(@PathVariable(value="user") String user) {
        try {
            return this.userStore.loadUserByUsername(user) != null;
        }
        catch (UsernameNotFoundException ex) {
            return false;
        }
    }

    @GetMapping(value={"/checkadminexists"})
    public boolean adminExists() {
        try {
            return this.userStore.loadUserByUsername("administrator") != null;
        }
        catch (UsernameNotFoundException ex) {
            return false;
        }
    }

    @GetMapping(value={"/userroles"})
    public List<UserRole> getAllUsers() {
        return this.userStore.getAllLocal();
    }

    @PostMapping(value={"/setuserrole"})
    public boolean setUserRole(Principal principal, @RequestBody UserRole userRole) {
        return this.userStore.setUserRole(principal.getName(), userRole);
    }

    @DeleteMapping(value={"/delete/{user:.+}"})
    public boolean deleteUser(@PathVariable(value="user") String user) {
        return this.userStore.removeUser(user);
    }

    @PostMapping(value={"/changepwd"})
    public boolean changePwd(Principal principal, @RequestBody ChangePwdRequest lr) {
        try {
            return this.userStore.setPassword(principal.getName(), lr.getOld(), lr.getPass(), lr.getHint());
        }
        catch (UsernameNotFoundException ex) {
            return false;
        }
    }

    @PostMapping(value={"/setpw"})
    public boolean setpw(@RequestBody RegisterUserRequest req) {
        try {
            Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
            String caller = authentication.getName();
            if (!authentication.getAuthorities().contains(new SimpleGrantedAuthority("ROLE_ADMIN"))) {
                LOG.log(Level.INFO, "{0} cannot set password for {1}", new Object[]{caller, req.getUser()});
                return false;
            }
            LOG.log(Level.INFO, "{0} is an admin. Setting pwd for {1}", new Object[]{caller, req.getUser()});
            return this.userStore.setPasswordFromAdmin(req.getUser(), req.getPass(), req.getHint());
        }
        catch (UsernameNotFoundException ex) {
            return false;
        }
    }

    @GetMapping(value={"/hint/{user}"})
    public String getHint(HttpServletRequest request, @PathVariable(value="user") String user) {
        String from = request.getRemoteHost();
        try {
            RateLimiter ratelimiter = (RateLimiter)this.ipToRateLimitHintCache.get((Object)from);
            boolean allow = ratelimiter.tryAcquire();
            if (!allow) {
                LOG.warning("Rate limit getHint");
                return "";
            }
            return this.userStore.getHint(user);
        }
        catch (ExecutionException ex) {
            Logger.getLogger(UserRestService.class.getName()).log(Level.SEVERE, null, ex);
            return "";
        }
    }

    @RequestMapping(value={"/user"})
    public Principal user(Principal user) {
        return user;
    }

    @GetMapping(value={"/locked/{user}"})
    public long lockedseconds(@PathVariable(value="user") String user) {
        return this.userStore.getLockedSeconds(user);
    }

    @GetMapping(value={"/notifications"})
    public List<WebUserNotification> getNotifications(Principal principal) {
        if (principal == null) {
            return Collections.emptyList();
        }
        Optional opt = this.notificationsStore.getAllNotifications(principal.getName());
        if (opt.isPresent()) {
            List notifications = (List)opt.get();
            ArrayList<WebUserNotification> ret = new ArrayList<WebUserNotification>();
            for (Notification n : notifications) {
                ret.add(new WebUserNotification(n));
            }
            return ret;
        }
        return Collections.emptyList();
    }

    @PostMapping(value={"/notifications/delete"})
    public boolean deleteNotification(Principal principal, @RequestParam(value="notificationid") String notificationid) {
        if (principal == null) {
            return false;
        }
        return this.notificationsStore.deleteNotification(principal.getName(), notificationid);
    }

    @DeleteMapping(value={"notifications/deleteall"})
    public boolean deleteAllNotifications(Principal principal) {
        if (principal == null) {
            return false;
        }
        return this.notificationsStore.deleteAllNotifications(principal.getName());
    }

    @PatchMapping(value={"/notifications/read"})
    public boolean setReadByUser(Principal principal, @RequestParam(value="notificationid") String notificationid) {
        if (principal == null) {
            return false;
        }
        return this.notificationsStore.markNotificationasread(principal.getName(), notificationid);
    }

    @InitBinder
    public void initBinder(WebDataBinder dataBinder) {
        dataBinder.registerCustomEditor(UserRole.class, (PropertyEditor)new /* Unavailable Anonymous Inner Class!! */);
    }
}

