/*
 * Decompiled with CFR 0.152.
 */
package com.geolang.ascema.managerservice.rest;

import com.geolang.ascema.endpointcommon.domain.BaseCommand;
import com.geolang.ascema.endpointcommon.domain.JobState;
import com.geolang.ascema.endpointcommon.domain.SearchCommand;
import com.geolang.ascema.endpointcommon.domain.actions.ActionCollection;
import com.geolang.ascema.endpointcommon.domain.actions.command.ActionResult;
import com.geolang.ascema.endpointcommon.domain.searchconfig.UnifiedSearchConfiguration;
import com.geolang.ascema.managerdomain.domain.JobDeviceState;
import com.geolang.ascema.managerdomain.domain.Schedule;
import com.geolang.ascema.managerdomain.domain.TaskInstance;
import com.geolang.ascema.managerdomain.domain.TaskTemplate;
import com.geolang.ascema.managerdomain.dto.DTOPatternCount;
import com.geolang.ascema.managerdomain.web.RunCommand;
import com.geolang.ascema.managerdomain.web.SearchFilter;
import com.geolang.ascema.managerdomain.web.SearchStateSummary;
import com.geolang.ascema.managerdomain.web.SearchStateSummaryCollection;
import com.geolang.ascema.managerdomain.web.SmallDetails;
import com.geolang.ascema.managerdomain.web.WebSchedule;
import com.geolang.ascema.managerpersistence.ClassificationLabelStore;
import com.geolang.ascema.managerpersistence.ContextWordStore;
import com.geolang.ascema.managerpersistence.FileExtensionStore;
import com.geolang.ascema.managerpersistence.IDataPointRepo;
import com.geolang.ascema.managerservice.controllers.PathCollectionController;
import com.geolang.ascema.managerservice.controllers.SchedulingService;
import com.geolang.ascema.managerservice.controllers.devices.DeviceService;
import com.geolang.ascema.managerservice.controllers.patterns.PatternService;
import com.geolang.ascema.managerservice.controllers.tasks.JobRunner;
import com.geolang.ascema.managerservice.controllers.tasks.JobStateUpdater;
import com.geolang.ascema.managerservice.controllers.tasks.TaskManager;
import com.geolang.ascema.managerservice.license.LicenseManager;
import com.geolang.ascema.managerservice.rest.requests.alfresco.AlfrescoSearchFilter;
import com.geolang.ascema.managerservice.rest.requests.atlassian.AtlassianSearchFilter;
import com.geolang.ascema.managerservice.rest.requests.o365.O365SearchFilter;
import com.geolang.ascema.managerservice.rest.requests.tasks.UnifiedSearchJobInstance;
import com.geolang.ascema.managerservice.rest.requests.tasks.UnifiedSearchJobTemplate;
import java.beans.PropertyEditor;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.lang3.tuple.ImmutableTriple;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.WebDataBinder;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.InitBinder;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/unified"})
public class UnifiedSearchRestService {
    private static final Logger LOG = Logger.getLogger(UnifiedSearchRestService.class.getName());
    @Autowired
    private DeviceService endpointController;
    @Autowired
    private TaskManager taskManager;
    @Autowired
    private JobRunner jobRunner;
    @Autowired
    @Lazy
    JobStateUpdater jobStateUpdater;
    @Autowired
    private FileExtensionStore fileExtManager;
    @Autowired
    private SchedulingService scheduler;
    @Autowired
    private PatternService patternService;
    @Autowired
    private LicenseManager licenseManager;
    @Autowired
    private IDataPointRepo dpRepo;
    @Autowired
    private PathCollectionController pathCollectionController;
    @Autowired
    private ContextWordStore contextWords;
    @Autowired
    private ClassificationLabelStore classificationLabelsStore;

    @RequestMapping(value={"/templates"})
    List<UnifiedSearchJobTemplate> getAllTemplates() {
        ArrayList<UnifiedSearchJobTemplate> ret = new ArrayList<UnifiedSearchJobTemplate>();
        ArrayList jps = this.taskManager.getAllTemplatesOfType(BaseCommand.CommandType.UNIFIED_SEARCH);
        for (TaskTemplate jp : jps) {
            Date lastRan = this.taskManager.getLastRanOrNull(jp.getUid());
            UnifiedSearchJobTemplate sjt = new UnifiedSearchJobTemplate(jp, this.scheduler, this.patternService, lastRan);
            ret.add(sjt);
        }
        return ret;
    }

    @RequestMapping(value={"/template/{id}"})
    UnifiedSearchJobTemplate getTemplate(@PathVariable(value="id") String templateId) {
        TaskTemplate tt = this.taskManager.getTemplateFromId(templateId);
        if (tt != null) {
            Date lastRan = this.taskManager.getLastRanOrNull(tt.getUid());
            return new UnifiedSearchJobTemplate(tt, this.scheduler, this.patternService, lastRan);
        }
        return null;
    }

    @RequestMapping(value={"/templates/ids"})
    List<SmallDetails> getAllTemplatesIds() {
        ArrayList<SmallDetails> ret = new ArrayList<SmallDetails>();
        for (ImmutableTriple t : this.taskManager.getAllSearchTemplatesIdsOfType(BaseCommand.CommandType.UNIFIED_SEARCH)) {
            ret.add(new SmallDetails((String)t.left, (String)t.middle, (Date)t.right, "", false));
        }
        return ret;
    }

    @PostMapping(value={"/check"})
    public boolean exists(@RequestParam(value="templatename") String templatename) {
        return this.taskManager.searchOrRTNameExists(templatename);
    }

    @PostMapping(value={"/valid"})
    public boolean validName(@RequestParam(value="templatename") String templatename) {
        return TaskManager.isValidTemplateName((String)templatename);
    }

    @PostMapping(value={"/template/add"})
    public ResponseEntity<UnifiedSearchJobTemplate> add(Principal principal, @RequestBody UnifiedSearchJobTemplate s) {
        if (this.licenseManager.isExpired()) {
            LOG.warning("License expired - not creating search");
            return ResponseEntity.status((HttpStatusCode)HttpStatus.NOT_ACCEPTABLE).body(null);
        }
        String name = "unknown";
        if (principal != null) {
            name = principal.getName();
        }
        if (this.taskManager.templateExists(s.getName())) {
            return ResponseEntity.status((HttpStatusCode)HttpStatus.CONFLICT).body(null);
        }
        if (!TaskManager.isValidTemplateName((String)s.getName())) {
            LOG.log(Level.WARNING, "not valid name {0}", s.getName());
            return ResponseEntity.status((HttpStatusCode)HttpStatus.NOT_ACCEPTABLE).body(null);
        }
        UnifiedSearchConfiguration config = s.toConfig(this.fileExtManager, this.contextWords, this.classificationLabelsStore);
        SearchCommand command = new SearchCommand(config);
        UnifiedSearchJobTemplate t = new UnifiedSearchJobTemplate(this.taskManager.addTemplate(name, (BaseCommand)command, s.getName(), s.getPriority(), s.isAlertAutomatically(), s.getActionIgnorePathsName()), this.scheduler, this.patternService, null);
        return new ResponseEntity((Object)t, (HttpStatusCode)HttpStatus.OK);
    }

    @PostMapping(value={"/template/rename"})
    public boolean renameTemplate(Principal principal, @RequestParam(value="id") String templateId, @RequestParam(value="name") String newName) {
        String name = "unknown";
        if (principal != null) {
            name = principal.getName();
        }
        LOG.log(Level.INFO, "rename template {0} to {1} by {2}", new Object[]{templateId, newName, name});
        return this.taskManager.renameTemplate(templateId, newName);
    }

    @PostMapping(value={"/template/setactionignorename"})
    public ResponseEntity<UnifiedSearchJobTemplate> associateTemplateWithIgnorePathCollection(Principal principal, @RequestParam(value="id") String templateId, @RequestParam(value="name") String pathCollectionName) {
        String name = "unknown";
        if (principal != null) {
            name = principal.getName();
        }
        if (!pathCollectionName.isBlank()) {
            boolean exists = this.pathCollectionController.existsByName(pathCollectionName);
            if (!exists) {
                LOG.log(Level.WARNING, "No Path Collection found with name {0}", pathCollectionName);
                return ResponseEntity.status((HttpStatusCode)HttpStatus.NOT_FOUND).body(null);
            }
        } else {
            LOG.info("Empty path collection name - unsetting");
        }
        LOG.log(Level.INFO, "associate template {0} with patch collection {1}, done by {2}", new Object[]{templateId, pathCollectionName, name});
        Optional opt = this.pathCollectionController.setTemplateActionIgnorePathsName(templateId, pathCollectionName);
        if (opt.isEmpty()) {
            return ResponseEntity.status((HttpStatusCode)HttpStatus.NOT_ACCEPTABLE).body(null);
        }
        return new ResponseEntity((Object)new UnifiedSearchJobTemplate((TaskTemplate)opt.get(), this.scheduler, this.patternService, this.taskManager.getLastRanOrNull(templateId)), (HttpStatusCode)HttpStatus.OK);
    }

    @DeleteMapping(value={"/template/{searchJobTemplateId}"})
    public boolean deleteTemplate(Principal principal, @PathVariable(value="searchJobTemplateId") String searchJobTemplateId) {
        String name = "unknown";
        if (principal != null) {
            name = principal.getName();
        }
        return this.taskManager.deleteTemplate(name, searchJobTemplateId);
    }

    @RequestMapping(value={"/template/statesummary/{searchJobTemplateId}"})
    public List<SearchStateSummary> getStateSummaryForTemplate(@PathVariable(value="searchJobTemplateId") String templateId) {
        return this.taskManager.getStateSummariesForTemplate(templateId);
    }

    @RequestMapping(value={"/template/statesummaries"})
    public List<SearchStateSummaryCollection> getAllStateSummaries() {
        return this.taskManager.getAllSummaries(BaseCommand.CommandType.UNIFIED_SEARCH);
    }

    @RequestMapping(value={"/instances/{searchJobTemplateId}"})
    List<UnifiedSearchJobInstance> getAllInstancesForTemplate(@PathVariable(value="searchJobTemplateId") String searchJobTemplateId) {
        ArrayList<UnifiedSearchJobInstance> ret = new ArrayList<UnifiedSearchJobInstance>();
        List jps = this.taskManager.getAllInstancesForTemplate(searchJobTemplateId);
        for (TaskInstance jp : jps) {
            UnifiedSearchJobInstance sjt = new UnifiedSearchJobInstance(jp, ((SearchCommand)jp.getCommand()).getConfig(), this.endpointController, this.patternService);
            ret.add(sjt);
        }
        return ret;
    }

    @RequestMapping(value={"/instancenames/{searchJobTemplateId}"})
    List<SmallDetails> getAllInstancesNamesForTemplate(@PathVariable(value="searchJobTemplateId") String searchJobTemplateId) {
        ArrayList<SmallDetails> ret = new ArrayList<SmallDetails>();
        List jps = this.taskManager.getAllInstancesForTemplate(searchJobTemplateId);
        for (TaskInstance jp : jps) {
            if (!jp.getCommandType().equals((Object)BaseCommand.CommandType.UNIFIED_SEARCH)) continue;
            SearchCommand command = (SearchCommand)jp.getCommand();
            String actionDisplay = "";
            ActionCollection actions = command.getConfig().getCommonFilter().getActions();
            if (actions.hasActions()) {
                actionDisplay = actions.getActionDisplayName();
            }
            boolean allCancelled = true;
            for (JobDeviceState state : jp.getDeviceStates()) {
                if (state.getState().isCancelled()) continue;
                allCancelled = false;
                break;
            }
            ret.add(new SmallDetails(jp.getUid(), jp.getDisplayName(), jp.getCreated(), actionDisplay, allCancelled));
        }
        return ret;
    }

    @RequestMapping(value={"/instance/{searchJobInstanceId}"})
    ResponseEntity<UnifiedSearchJobInstance> getInstanceFromId(@PathVariable(value="searchJobInstanceId") String searchJobInstanceId) {
        Optional opt = this.taskManager.getTaskInstanceFromId(searchJobInstanceId);
        if (!opt.isPresent()) {
            return new ResponseEntity((HttpStatusCode)HttpStatus.NOT_FOUND);
        }
        TaskInstance instance = (TaskInstance)opt.get();
        UnifiedSearchJobInstance ret = new UnifiedSearchJobInstance(instance, ((SearchCommand)instance.getCommand()).getConfig(), this.endpointController, this.patternService);
        return new ResponseEntity((Object)ret, (HttpStatusCode)HttpStatus.OK);
    }

    @RequestMapping(value={"/instance/{searchJobInstanceId}/patterntotals"})
    ResponseEntity<List<DTOPatternCount>> getPatternTotals(@PathVariable(value="searchJobInstanceId") String searchJobInstanceId) {
        List counts = this.dpRepo.getPatternCountsForTaskId(searchJobInstanceId);
        return new ResponseEntity((Object)counts, (HttpStatusCode)HttpStatus.OK);
    }

    @PostMapping(value={"/cancel"})
    public boolean cancel(@RequestParam(value="searchJobInstanceId") String searchJobInstanceId, @RequestParam(value="deviceId") String deviceId) {
        return this.taskManager.cancelJob(searchJobInstanceId, deviceId);
    }

    @PostMapping(value={"/pause"})
    public boolean pause(@RequestParam(value="searchJobInstanceId") String searchJobInstanceId, @RequestParam(value="deviceId") String deviceId) {
        return this.taskManager.pauseJob(searchJobInstanceId, deviceId, false);
    }

    @PostMapping(value={"/resume"})
    public boolean resume(@RequestParam(value="searchJobInstanceId") String searchJobInstanceId, @RequestParam(value="deviceId") String deviceId) {
        return this.taskManager.resumeJob(searchJobInstanceId, deviceId);
    }

    @PostMapping(value={"/pauseall"})
    public boolean pauseAll(@RequestParam(value="searchJobInstanceId") String searchJobInstanceId) {
        return this.taskManager.pauseAllJobs(searchJobInstanceId);
    }

    @PostMapping(value={"/resumeall"})
    public boolean resumeAll(@RequestParam(value="searchJobInstanceId") String searchJobInstanceId) {
        return this.taskManager.resumeAllJobs(searchJobInstanceId);
    }

    @PostMapping(value={"/done"})
    public boolean done(@RequestParam(value="searchJobInstanceId") String searchJobInstanceId, @RequestParam(value="deviceId") String deviceId) {
        return this.jobStateUpdater.updateJobState(searchJobInstanceId, deviceId, JobState.DONE, Optional.empty(), "from ui", ActionResult.createEmptyResult());
    }

    @DeleteMapping(value={"/delete/{searchJobInstanceId}"})
    public boolean delete(Principal principal, @PathVariable(value="searchJobInstanceId") String searchJobInstanceId) {
        String name = "unknown";
        if (principal != null) {
            name = principal.getName();
        }
        return this.taskManager.deleteTaskInstance(name, searchJobInstanceId);
    }

    @PostMapping(value={"/run"})
    public ResponseEntity<UnifiedSearchJobInstance> run(Principal principal, @RequestBody RunCommand com) {
        TaskTemplate template;
        if (this.licenseManager.isExpired()) {
            LOG.warning("License expired - not running search");
            return ResponseEntity.status((HttpStatusCode)HttpStatus.NOT_ACCEPTABLE).body(null);
        }
        String name = "unknown";
        if (principal != null) {
            name = principal.getName();
        }
        if ((template = this.taskManager.getTemplateFromId(com.getTemplateId())) == null) {
            return new ResponseEntity(null, (HttpStatusCode)HttpStatus.NOT_FOUND);
        }
        if (com.isRunOnAllDevices()) {
            TaskInstance plan = this.jobRunner.runCommandOnAllDevices(name, template, com.getName(), com.getPriority(), com.isAlertAutomatically(), false, com.isOverrideQuietTime());
            return new ResponseEntity((Object)new UnifiedSearchJobInstance(plan, ((SearchCommand)plan.getCommand()).getConfig(), this.endpointController, this.patternService), (HttpStatusCode)HttpStatus.OK);
        }
        TaskInstance plan = this.jobRunner.runCommandOnDevices(name, template, com.getName(), com.getPriority(), com.getDeviceIds(), com.isAlertAutomatically(), false, com.isOverrideQuietTime());
        return new ResponseEntity((Object)new UnifiedSearchJobInstance(plan, ((SearchCommand)plan.getCommand()).getConfig(), this.endpointController, this.patternService), (HttpStatusCode)HttpStatus.OK);
    }

    @PostMapping(value={"/schedule"})
    public boolean schedule(Principal principal, @RequestBody WebSchedule sched) {
        Schedule s = new Schedule(sched, principal.getName());
        return this.scheduler.addSchedule(s);
    }

    @DeleteMapping(value={"/schedule/{searchJobTemplateId}"})
    public boolean deleteSchedule(@PathVariable(value="searchJobTemplateId") String searchJobTemplateId) {
        return this.scheduler.removeSchedule(searchJobTemplateId);
    }

    @RequestMapping(value={"/schedule/{searchJobTemplateId}"})
    ResponseEntity<WebSchedule> getScheduleForTemplate(@PathVariable(value="searchJobTemplateId") String searchJobTemplateId) {
        Optional sched = this.scheduler.getScheduleForTemplate(searchJobTemplateId);
        if (sched.isPresent()) {
            return new ResponseEntity((Object)new WebSchedule((Schedule)sched.get()), (HttpStatusCode)HttpStatus.OK);
        }
        return new ResponseEntity(null, (HttpStatusCode)HttpStatus.NOT_FOUND);
    }

    @InitBinder
    public void initBinder(WebDataBinder dataBinder) {
        dataBinder.registerCustomEditor(RunCommand.class, (PropertyEditor)new /* Unavailable Anonymous Inner Class!! */);
        dataBinder.registerCustomEditor(SearchFilter.class, (PropertyEditor)new /* Unavailable Anonymous Inner Class!! */);
        dataBinder.registerCustomEditor(AlfrescoSearchFilter.class, (PropertyEditor)new /* Unavailable Anonymous Inner Class!! */);
        dataBinder.registerCustomEditor(O365SearchFilter.class, (PropertyEditor)new /* Unavailable Anonymous Inner Class!! */);
        dataBinder.registerCustomEditor(AtlassianSearchFilter.class, (PropertyEditor)new /* Unavailable Anonymous Inner Class!! */);
        dataBinder.registerCustomEditor(WebSchedule.class, (PropertyEditor)new /* Unavailable Anonymous Inner Class!! */);
        dataBinder.registerCustomEditor(UnifiedSearchJobTemplate.class, (PropertyEditor)new /* Unavailable Anonymous Inner Class!! */);
    }
}

