/*
 * Decompiled with CFR 0.152.
 */
package com.geolang.ascema.managerservice.rest;

import java.time.LocalDateTime;
import java.time.temporal.ChronoUnit;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;

public class TimedCompletableFuture<T> {
    private final CompletableFuture<T> future;
    private LocalDateTime expires;

    public TimedCompletableFuture(CompletableFuture<T> future, int seconds) {
        this.future = future;
        this.expires = LocalDateTime.now().plus(seconds, ChronoUnit.SECONDS);
    }

    public CompletableFuture<T> getFuture() {
        return this.future;
    }

    public void resetTimeout(int seconds) {
        this.expires = LocalDateTime.now().plus(seconds, ChronoUnit.SECONDS);
    }

    public boolean expired() {
        return LocalDateTime.now().isAfter(this.expires);
    }

    public int hashCode() {
        int hash = 5;
        hash = 97 * hash + Objects.hashCode(this.future);
        hash = 97 * hash + Objects.hashCode(this.expires);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TimedCompletableFuture other = (TimedCompletableFuture)obj;
        if (!Objects.equals(this.future, other.future)) {
            return false;
        }
        return Objects.equals(this.expires, other.expires);
    }
}

