/*
 * Decompiled with CFR 0.152.
 */
package com.geolang.ascema.managerservice.rest;

import com.geolang.ascema.endpointcommon.domain.BaseCommand;
import com.geolang.ascema.endpointcommon.domain.searchconfig.EndpointSearchConfiguration;
import com.geolang.ascema.endpointcommon.domain.searchconfig.SearchFilterCommon;
import com.geolang.ascema.managerdomain.domain.SubRepoTask;
import com.geolang.ascema.managerdomain.domain.TaskInstance;
import com.geolang.ascema.managerdomain.dto.GroupBy;
import com.geolang.ascema.managerdomain.web.SearchFilter;
import com.geolang.ascema.managerpersistence.ClassificationLabelStore;
import com.geolang.ascema.managerpersistence.ContextWordStore;
import com.geolang.ascema.managerpersistence.FileExtensionStore;
import com.geolang.ascema.managerpersistence.results.DataPoint;
import com.geolang.ascema.managerpersistence.results.DataPointSlice;
import com.geolang.ascema.managerservice.controllers.patterns.PatternService;
import com.geolang.ascema.managerservice.controllers.retrieval.SubSearchManager;
import com.geolang.ascema.managerservice.controllers.retrieval.SubTaskCreator;
import com.geolang.ascema.managerservice.controllers.tasks.TaskManager;
import com.geolang.ascema.managerservice.license.LicenseManager;
import com.geolang.ascema.managerservice.rest.requests.retrieval.CreateRepoCommand;
import com.geolang.ascema.managerservice.rest.requests.retrieval.SubRepoTemplate;
import com.geolang.ascema.managerservice.rest.requests.retrieval.SubSearchDataSliceRequest;
import java.beans.PropertyEditor;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.CacheControl;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.WebDataBinder;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.InitBinder;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/subsearch"})
public class SubSearchRestService {
    private static final Logger LOG = Logger.getLogger(SubSearchRestService.class.getName());
    @Autowired
    private SubSearchManager subSearchManager;
    @Autowired
    private PatternService patternService;
    @Autowired
    private FileExtensionStore fileExtManager;
    @Autowired
    private SubTaskCreator creator;
    @Autowired
    private LicenseManager licenseManager;
    @Autowired
    private ContextWordStore contextWords;
    @Autowired
    private ClassificationLabelStore classificationLabelsStore;

    @RequestMapping(value={"/templates/{id}"})
    List<SubRepoTemplate> getTemplates(@PathVariable(value="id") String taskInstanceId) {
        ArrayList<SubRepoTemplate> ret = new ArrayList<SubRepoTemplate>();
        Optional parentRetrievalTask = this.subSearchManager.getSubSearchTasksParentForInstance(taskInstanceId);
        if (parentRetrievalTask.isEmpty()) {
            return Collections.emptyList();
        }
        BaseCommand parentBaseCommand = ((TaskInstance)parentRetrievalTask.get()).getCommand();
        for (SubRepoTask task : ((TaskInstance)parentRetrievalTask.get()).getsubRepoTasks()) {
            ret.add(new SubRepoTemplate(task, this.patternService, parentBaseCommand));
        }
        HashMap lookup = new HashMap();
        ret.forEach(x -> lookup.put(x.getId(), x));
        lookup.values().forEach(item -> {
            if (lookup.containsKey(item.getParentSubRepoTaskId())) {
                SubRepoTemplate proposedParent = (SubRepoTemplate)lookup.get(item.getParentSubRepoTaskId());
                proposedParent.getChildren().add(item);
            }
        });
        return lookup.values().stream().filter(x -> x.getParentSubRepoTaskId().isEmpty()).collect(Collectors.toList());
    }

    @GetMapping(value={"/check/{parentTaskId}/{name}"})
    public boolean exists(@PathVariable(value="parentTaskId") String parentTaskId, @PathVariable(value="name") String name) {
        return this.subSearchManager.templateExists(parentTaskId, name);
    }

    @PostMapping(value={"/valid"})
    public boolean validName(@RequestParam(value="name") String templatename) {
        return TaskManager.isValidTemplateName((String)templatename);
    }

    @PostMapping(value={"/template/runsearch"})
    public ResponseEntity<SubRepoTemplate> runsearch(Principal principal, @RequestBody SubRepoTemplate s) {
        if (this.licenseManager.isExpired()) {
            LOG.warning("License expired - not creating search");
            return ResponseEntity.status((HttpStatusCode)HttpStatus.NOT_ACCEPTABLE).body(null);
        }
        String name = "unknown";
        if (principal != null) {
            name = principal.getName();
        }
        EndpointSearchConfiguration config = s.getFilter().toConfig();
        SearchFilterCommon common = s.getCommon().toSearchFilterCommon(this.fileExtManager, this.contextWords, this.classificationLabelsStore);
        Optional task = s.getParentSubRepoTaskId() != null && !s.getParentSubRepoTaskId().isEmpty() ? this.creator.addSubSearchToSubSearch(name, config, common, s.getName(), s.getRetrievalTaskInstanceId(), s.getParentSubRepoTaskId()) : this.creator.addSubSearchToInstance(name, config, common, s.getName(), s.getRetrievalTaskInstanceId());
        if (!task.isPresent()) {
            return new ResponseEntity((HttpStatusCode)HttpStatus.NOT_FOUND);
        }
        SubRepoTemplate t = new SubRepoTemplate((SubRepoTask)task.get(), this.patternService);
        this.subSearchManager.createRepoFromSearch((SubRepoTask)task.get());
        return new ResponseEntity((Object)t, (HttpStatusCode)HttpStatus.OK);
    }

    @PostMapping(value={"/template/runcreaterepo"})
    public ResponseEntity<SubRepoTemplate> runcreaterepo(Principal principal, @RequestBody CreateRepoCommand s) {
        Optional task;
        if (this.licenseManager.isExpired()) {
            LOG.warning("License expired - not creating repo");
            return ResponseEntity.status((HttpStatusCode)HttpStatus.NOT_ACCEPTABLE).body(null);
        }
        String name = "unknown";
        if (principal != null) {
            name = principal.getName();
        }
        if (!(task = s.getParentSubRepoTaskId() != null && !s.getParentSubRepoTaskId().isEmpty() ? this.creator.addCreateRepoTaskToSubSearch(name, s.getRepoPaths(), s.isSelectAll(), s.getName(), s.getInstanceId(), s.getParentSubRepoTaskId()) : this.creator.addCreateRepoTaskToInstance(name, s.getRepoPaths(), s.isSelectAll(), s.getName(), s.getInstanceId())).isPresent()) {
            return new ResponseEntity((HttpStatusCode)HttpStatus.NOT_FOUND);
        }
        SubRepoTemplate t = new SubRepoTemplate((SubRepoTask)task.get(), this.patternService);
        this.subSearchManager.createRepoFromRepo((SubRepoTask)task.get());
        return new ResponseEntity((Object)t, (HttpStatusCode)HttpStatus.OK);
    }

    @PostMapping(value={"/subslice"})
    ResponseEntity<List<DataPoint>> getSubSlice(@RequestParam(value="req") SubSearchDataSliceRequest res) {
        GroupBy gb = GroupBy.values()[res.getGroupby()];
        List ret = this.subSearchManager.getSubSlice(res.getTaskInstanceId(), res.getSubSearchTaskId(), res.getKey(), res.getFilterString(), gb, res.getStart(), res.getRows());
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().cacheControl(CacheControl.maxAge((long)10L, (TimeUnit)TimeUnit.SECONDS))).body((Object)ret);
    }

    @PostMapping(value={"/get"})
    ResponseEntity<DataPointSlice> getLatestResults(@RequestParam(value="req") SubSearchDataSliceRequest res) {
        GroupBy gb = GroupBy.values()[res.getGroupby()];
        Optional ret = this.subSearchManager.getResultsSlice(res.isForceRefresh(), res.getTaskInstanceId(), res.getSubSearchTaskId(), res.getFilterString(), gb, res.getStart(), res.getRows());
        if (!ret.isPresent()) {
            return ResponseEntity.status((HttpStatusCode)HttpStatus.UNPROCESSABLE_ENTITY).body(null);
        }
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().cacheControl(CacheControl.maxAge((long)10L, (TimeUnit)TimeUnit.SECONDS))).body((Object)((DataPointSlice)ret.get()));
    }

    @InitBinder
    public void initBinder(WebDataBinder dataBinder) {
        dataBinder.registerCustomEditor(SearchFilter.class, (PropertyEditor)new /* Unavailable Anonymous Inner Class!! */);
        dataBinder.registerCustomEditor(SubSearchDataSliceRequest.class, (PropertyEditor)new /* Unavailable Anonymous Inner Class!! */);
        dataBinder.registerCustomEditor(SubRepoTemplate.class, (PropertyEditor)new /* Unavailable Anonymous Inner Class!! */);
        dataBinder.registerCustomEditor(CreateRepoCommand.class, (PropertyEditor)new /* Unavailable Anonymous Inner Class!! */);
    }
}

