/*
 * Decompiled with CFR 0.152.
 */
package com.geolang.ascema.managerservice.rest;

import com.geolang.ascema.endpointcommon.domain.ConfiguredAlertMethods;
import com.geolang.ascema.managercore.auditlog.AuditLogFormat;
import com.geolang.ascema.managercore.domain.ManagerRole;
import com.geolang.ascema.managercore.settings.SettingsFile;
import com.geolang.ascema.managercore.settings.WorkingFolder;
import com.geolang.ascema.managerdomain.web.PortsInfo;
import com.geolang.ascema.managerdomain.web.SMTPSettings;
import com.geolang.ascema.managerdomain.web.UISSLSettings;
import com.geolang.ascema.managerdomain.web.WebFolder;
import com.geolang.ascema.managerdomain.web.WebLDAPConfig;
import com.geolang.ascema.managerdomain.web.WebSecondaryConfig;
import com.geolang.ascema.managerdomain.web.importexport.ImportExportFormat;
import com.geolang.ascema.managerservice.Application;
import com.geolang.ascema.managerservice.LoggingSettings;
import com.geolang.ascema.managerservice.auditlog.AuditLogConfigurator;
import com.geolang.ascema.managerservice.controllers.AlertingController;
import com.geolang.ascema.managerservice.controllers.BuildVersion;
import com.geolang.ascema.managerservice.controllers.DerbyBackup;
import com.geolang.ascema.managerservice.controllers.FolderBrowser;
import com.geolang.ascema.managerservice.controllers.ImportExportService;
import com.geolang.ascema.managerservice.controllers.MailSender;
import com.geolang.ascema.managerservice.controllers.ProxySettings;
import com.geolang.ascema.managerservice.controllers.jettyssl.JettySSL;
import com.geolang.ascema.managerservice.license.LicenseManager;
import com.geolang.ascema.managerservice.messaging.JMSManager;
import com.geolang.ascema.managerservice.rest.DataValidation;
import com.geolang.ascema.managerservice.rest.security.ad.LDAPConfig;
import java.beans.PropertyEditor;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.security.Principal;
import java.time.Instant;
import java.time.ZoneId;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.io.IOUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.core.io.Resource;
import org.springframework.core.io.UrlResource;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.WebDataBinder;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.InitBinder;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/api/admin/settings"})
public class SettingsRestService {
    private static final Logger LOG = Logger.getLogger(SettingsRestService.class.getName());
    @Autowired
    private JMSManager jmsManager;
    @Autowired
    private ProxySettings proxySettings;
    @Autowired
    private AuditLogConfigurator auditLogManager;
    @Autowired
    private LicenseManager licenseManager;
    @Autowired
    AlertingController alertController;
    @Autowired
    private JettySSL jettyssl;
    @Autowired
    private DerbyBackup derbyBackup;
    @Autowired
    private BuildVersion buildVersion;
    @Autowired
    private ImportExportService importExport;
    private final SettingsFile settings = SettingsFile.getInstance();

    @GetMapping(value={"/restart"})
    void restart() {
        Application.restart();
    }

    @PostMapping(value={"/policytext"})
    public void setPolicyTextString(@RequestParam(value="policytext") String text) {
        String withoutxss = DataValidation.stripXSS((String)text);
        if (!withoutxss.equals(text)) {
            LOG.warning("Stripped potential XSS from policytext");
        }
        this.settings.setPolicyTextString(withoutxss);
    }

    @GetMapping(value={"/policytext"})
    public ResponseEntity<String> getPolicyTextString() {
        String ret = this.settings.getPolicyTextString();
        if (ret.isEmpty()) {
            return ResponseEntity.status((HttpStatusCode)HttpStatus.NO_CONTENT).body((Object)"");
        }
        return ResponseEntity.status((HttpStatusCode)HttpStatus.OK).body((Object)ret);
    }

    @PostMapping(value={"/policyurl"})
    public void setPolicyUrl(@RequestParam(value="policyurl") String url) {
        this.settings.setPolicyURL(url);
    }

    @GetMapping(value={"/policyurl"})
    public ResponseEntity<String> getPolicyUrl() {
        String ret = this.settings.getPolicyURL();
        if (ret.isEmpty()) {
            return ResponseEntity.status((HttpStatusCode)HttpStatus.NO_CONTENT).body((Object)"");
        }
        return ResponseEntity.status((HttpStatusCode)HttpStatus.OK).body((Object)ret);
    }

    @GetMapping(value={"/sharedsecret"})
    public ResponseEntity<String> getSharedSecret() {
        return ResponseEntity.status((HttpStatusCode)HttpStatus.OK).body((Object)"NOT_THE_SECRET");
    }

    @GetMapping(value={"/portInfo"})
    public PortsInfo getPortInfo() {
        return new PortsInfo();
    }

    @PostMapping(value={"/portInfo"})
    public boolean putPortInfo(@RequestParam(value="info") PortsInfo info) {
        this.settings.setJMDNSPort(info.getJmDnsPort());
        this.settings.setMessageServerPort(info.getMessageServerPort());
        this.settings.setUDPDiscoveryPort(info.getUdpPort());
        LOG.log(Level.INFO, "set jmdns={0} messages server port={1} udpPort={2}", new Object[]{info.getJmDnsPort(), info.getMessageServerPort(), info.getUdpPort()});
        return true;
    }

    @PostMapping(value={"/masterport"})
    public boolean putMasterPort(@RequestParam(value="port") int port) {
        return this.jmsManager.setMasterPort(port);
    }

    @GetMapping(value={"/proxyuiport"})
    public ResponseEntity<Integer> getProxyUIPort() {
        SettingsRestService settingsRestService = this;
        return ResponseEntity.status((HttpStatusCode)HttpStatus.OK).body((Object)settingsRestService.proxySettings.getPort());
    }

    @PostMapping(value={"/proxyuiport"})
    public void putProxyUIPort(@RequestParam(value="port") int port) {
        this.proxySettings.setPort(port);
    }

    @GetMapping(value={"/uihost"})
    public ResponseEntity<String> getUIHost() {
        SettingsRestService settingsRestService = this;
        return ResponseEntity.status((HttpStatusCode)HttpStatus.OK).body((Object)settingsRestService.proxySettings.getHost());
    }

    @PostMapping(value={"/uihost"})
    public boolean putUIHost(@RequestParam(value="host") String host) {
        this.proxySettings.setHost(host);
        return true;
    }

    @GetMapping(value={"/uiport"})
    public ResponseEntity<Integer> getUIPort() {
        return ResponseEntity.status((HttpStatusCode)HttpStatus.OK).body((Object)this.settings.getUIPort());
    }

    @PostMapping(value={"/uiport"})
    public boolean putUIPort(@RequestParam(value="port") int port) {
        LOG.log(Level.INFO, "Set http UI Port {0}", port);
        this.settings.setUIPort(port);
        return true;
    }

    @GetMapping(value={"/uiprot"})
    public ResponseEntity<String> getUIProtocol() {
        SettingsRestService settingsRestService = this;
        return ResponseEntity.status((HttpStatusCode)HttpStatus.OK).body((Object)settingsRestService.proxySettings.getProtocol());
    }

    @PostMapping(value={"/uiprot"})
    public boolean putUIProtocol(@RequestParam(value="prot") String prot) {
        this.proxySettings.setProtocol(prot);
        return true;
    }

    @GetMapping(value={"/primarymainui"})
    public boolean getPrimaryIsMainUI() {
        SettingsRestService settingsRestService = this;
        return settingsRestService.proxySettings.getPrimaryIsMainUI();
    }

    @PostMapping(value={"/primarymainui"})
    public boolean setPrimaryIsMainUI(@RequestParam(value="main") boolean main) {
        return this.proxySettings.setPrimaryIsMainUI(main);
    }

    @GetMapping(value={"/serverlog"})
    public ResponseEntity<String> getServerlog() {
        String serverlog = LoggingSettings.getServerLog();
        if (serverlog.isEmpty()) {
            return ResponseEntity.status((HttpStatusCode)HttpStatus.NO_CONTENT).body((Object)"");
        }
        return ResponseEntity.status((HttpStatusCode)HttpStatus.OK).body((Object)serverlog);
    }

    @GetMapping(value={"/auditindividual"})
    public boolean getAuditIndividualMatches() {
        return this.settings.getAuditIndividualMatches();
    }

    @PostMapping(value={"/auditindividual"})
    public boolean setAuditIndividualMatches(@RequestParam(value="set") boolean set) {
        this.settings.setAuditIndividualMatches(set);
        return true;
    }

    @GetMapping(value={"/auditlog"})
    public ResponseEntity<String> getAuditlog() {
        Optional pathOpt = this.auditLogManager.getLogFilePath();
        String serverlog = "";
        if (pathOpt.isPresent()) {
            Path path = (Path)pathOpt.get();
            try {
                byte[] encoded = Files.readAllBytes(path);
                serverlog = new String(encoded, Charset.defaultCharset());
            }
            catch (IOException ex) {
                Logger.getLogger(SettingsRestService.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        if (serverlog.isEmpty()) {
            return ResponseEntity.status((HttpStatusCode)HttpStatus.NO_CONTENT).body((Object)"");
        }
        return ResponseEntity.status((HttpStatusCode)HttpStatus.OK).body((Object)serverlog);
    }

    @GetMapping(value={"/managerrole"})
    public String getManagerRole() {
        return this.settings.getManagerRole().getDisplayName();
    }

    @GetMapping(value={"/issecondary"})
    public boolean getIsSecondary() {
        return this.settings.getManagerRole().equals((Object)ManagerRole.SECONDARY);
    }

    @GetMapping(value={"/isprimary"})
    public boolean getIsPrimary() {
        return this.settings.getManagerRole().equals((Object)ManagerRole.PRIMARY);
    }

    @GetMapping(value={"/isstandalone"})
    public boolean getIsStandalone() {
        return this.settings.getManagerRole().equals((Object)ManagerRole.STANDALONE);
    }

    @GetMapping(value={"/availablemanagerroles"})
    public List<String> getManagerRoles() {
        ArrayList<String> ret = new ArrayList<String>();
        if (this.licenseManager.getMaxSecondaryManagers() <= 0) {
            ret.add(ManagerRole.STANDALONE.getDisplayName());
            ret.add(ManagerRole.SECONDARY.getDisplayName());
        } else {
            for (ManagerRole r : ManagerRole.values()) {
                ret.add(r.getDisplayName());
            }
        }
        return ret;
    }

    @PostMapping(value={"/setmanagerrole"})
    public boolean putManagerRole(@RequestParam(value="role") String s) {
        ManagerRole role = ManagerRole.fromString((String)s);
        return this.jmsManager.setManagerRole(role);
    }

    @GetMapping(value={"/masterurl"})
    public String getMasterHost() {
        return this.settings.getMasterHost();
    }

    @PostMapping(value={"/setmasterurl"})
    public boolean putMasterUrl(@RequestParam(value="url") String url) {
        return this.jmsManager.setMasterUrl(url);
    }

    @GetMapping(value={"/serverlocation"})
    public String getServerLocation() {
        return this.settings.getManagerName();
    }

    @GetMapping(value={"/attachedslaves"})
    public List<WebSecondaryConfig> getAttachedSlaves() {
        return this.jmsManager.getAttachedSlaves();
    }

    @GetMapping(value={"/numattachedslaves"})
    public int getNumAttachedSlaves() {
        return this.jmsManager.getAttachedSlaves().size();
    }

    @DeleteMapping(value={"/deleteslave/{name}"})
    public boolean deleteSlave(@PathVariable(value="name") String name) {
        return this.jmsManager.deleteSlave(name);
    }

    @PostMapping(value={"/setserverlocation"})
    public boolean putServerLocation(@RequestParam(value="location") String loc) {
        return this.jmsManager.setServerName(loc);
    }

    @PostMapping(value={"/alerturl"})
    public boolean setAlertUrl(@RequestParam(value="url") String url) {
        this.settings.setIndividualReportsUrl(url);
        return true;
    }

    @PostMapping(value={"/o365alerturl"})
    public boolean setO365AlertUrl(@RequestParam(value="url") String url) {
        this.settings.setO365ReportsUrl(url);
        return true;
    }

    @PostMapping(value={"/googlealerturl"})
    public boolean setGoogleAlertUrl(@RequestParam(value="url") String url) {
        this.settings.setGoogleReportsUrl(url);
        return true;
    }

    @PostMapping(value={"/atlassianalerturl"})
    public boolean setAtlassianAlertUrl(@RequestParam(value="url") String url) {
        this.settings.setAtlassianReportsUrl(url);
        return true;
    }

    @GetMapping(value={"/auditformat"})
    public ResponseEntity<AuditLogFormat> getAuditFormat() {
        AuditLogFormat ret = this.settings.getAuditLogFormat();
        return ResponseEntity.status((HttpStatusCode)HttpStatus.OK).body((Object)ret);
    }

    @PostMapping(value={"/auditformat"})
    public boolean putAuditLogFormat(@RequestParam(value="format") String f) {
        Integer i = Integer.valueOf(f);
        AuditLogFormat format = AuditLogFormat.values()[i];
        LOG.log(Level.INFO, "Set Use audit log format {0}", format.toString());
        this.settings.setAuditLogFormat(format);
        return true;
    }

    @GetMapping(value={"/splunkenabled"})
    public ResponseEntity<Boolean> getSplunkEnabled() {
        Boolean ret = this.settings.getUseSplunkTcp();
        return ResponseEntity.status((HttpStatusCode)HttpStatus.OK).body((Object)ret);
    }

    @PostMapping(value={"/splunkenabled"})
    public boolean putSplunkEnabled(@RequestParam(value="enabled") boolean b) {
        LOG.log(Level.INFO, "Set Use splunk tcp{0}", b);
        this.settings.setUseSplunkTcp(b);
        this.auditLogManager.updateAppenders();
        return true;
    }

    @GetMapping(value={"/splunkport"})
    public ResponseEntity<Integer> getSplunkPort() {
        return ResponseEntity.status((HttpStatusCode)HttpStatus.OK).body((Object)this.settings.getSplunkPort());
    }

    @GetMapping(value={"/splunkhost"})
    public String getSplunkHost() {
        return this.settings.getSplunkHost();
    }

    @GetMapping(value={"/splunkssl"})
    public boolean getSplunkSSL() {
        return this.settings.getSplunkUseSSL();
    }

    @PostMapping(value={"/splunklocation"})
    public boolean putSplunkUrlAndPort(@RequestParam(value="host") String host, @RequestParam(value="port") int port, @RequestParam(value="ssl") boolean ssl) {
        LOG.log(Level.INFO, "Set Splunk Host {0}", host);
        this.settings.setSplunkHost(host);
        LOG.log(Level.INFO, "Set Splunk Port {0}", port);
        this.settings.setSplunkPort(port);
        LOG.log(Level.INFO, "Set Splunk ssl {0}", ssl);
        this.settings.setSplunkUseSSL(ssl);
        return true;
    }

    @GetMapping(value={"/smtp"})
    public ResponseEntity<SMTPSettings> getSMTPSettings() {
        SMTPSettings ret = new SMTPSettings();
        ret.setCcEmail(this.settings.getSMTPAlertCC());
        ret.setFromEmail(this.settings.getSMTPAlertFrom());
        ret.setHost(this.settings.getSMTPHost());
        ret.setPort(this.settings.getSMTPPort());
        ret.setUseSSL(this.settings.getUseSMTPSSL());
        ret.setUseStartSSL(this.settings.getUseSMTPStartSSL());
        ret.setUser(this.settings.getSMTPUser());
        ret.setProtocol(this.settings.getSMTPProt());
        ret.setPwd("##DUMMY##");
        return ResponseEntity.status((HttpStatusCode)HttpStatus.OK).body((Object)ret);
    }

    @PostMapping(value={"/smtp"})
    public boolean putSMTPSettings(@RequestParam(value="settings") SMTPSettings b) {
        LOG.log(Level.INFO, "Set smtp");
        this.settings.setSMTPAlertCC(b.getCcEmail().trim());
        this.settings.setSMTPAlertFrom(b.getFromEmail().trim());
        this.settings.setSMTPHost(b.getHost().trim());
        this.settings.setSMTPPort(b.getPort());
        this.settings.setUseSMPTSSL(b.isUseSSL());
        this.settings.setUseSMPTStartSSL(b.isUseStartSSL());
        this.settings.setSMTPProt(b.getProtocol());
        if (b.getPwd() != null && !b.getPwd().isEmpty() && !b.getPwd().equals("##DUMMY##")) {
            this.settings.setSMTPPwd(b.getPwd());
        }
        this.settings.setSMTPUSer(b.getUser().trim());
        return true;
    }

    @PostMapping(value={"/smtptest"})
    public String testSMTPSettings(@RequestParam(value="settings") SMTPSettings b, @RequestParam(value="to") String to) {
        boolean ok;
        if (b.getPwd().equals("##DUMMY##")) {
            b.setPwd(SettingsFile.getInstance().getSMTPPwd());
        }
        if (ok = MailSender.send((SMTPSettings)b, (String)to, (String)"test alert", (String)"Test of Data Discovery email alerting")) {
            return "OK";
        }
        return MailSender.getLastErrorMessage();
    }

    @GetMapping(value={"/o365alertfrom"})
    public ResponseEntity<String> getO365AlertFrom() {
        String ret = this.settings.getO365AlertFrom();
        return ResponseEntity.status((HttpStatusCode)HttpStatus.OK).body((Object)ret);
    }

    @PostMapping(value={"/o365alertfrom"})
    public boolean putO365AlertFrom(@RequestParam(value="from") String from) {
        LOG.log(Level.INFO, "Set O365 alert from {0}", from);
        this.settings.setO365AlertFrom(from);
        return true;
    }

    @GetMapping(value={"/o365alertcc"})
    public ResponseEntity<String> getO365AlertCC() {
        String ret = this.settings.getO365AlertCC();
        return ResponseEntity.status((HttpStatusCode)HttpStatus.OK).body((Object)ret);
    }

    @PostMapping(value={"/o365alertcc"})
    public boolean putO365AlertCC(@RequestParam(value="cc") String cc) {
        LOG.log(Level.INFO, "Set O365 alert cc {0}", cc);
        this.settings.setO365AlertCC(cc);
        return true;
    }

    @GetMapping(value={"/googlealertcc"})
    public ResponseEntity<String> getGoogleAlertCC() {
        String ret = this.settings.getGmailAlertCC();
        return ResponseEntity.status((HttpStatusCode)HttpStatus.OK).body((Object)ret);
    }

    @PostMapping(value={"/googlealertcc"})
    public boolean putGoogleAlertCC(@RequestParam(value="cc") String cc) {
        LOG.log(Level.INFO, "Set Google alert cc {0}", cc);
        this.settings.setGmailAlertCC(cc);
        return true;
    }

    @GetMapping(value={"/alertconfig"})
    public ResponseEntity<ConfiguredAlertMethods> getAlertConfig() {
        ConfiguredAlertMethods ret = this.alertController.getConfigSettings();
        return ResponseEntity.status((HttpStatusCode)HttpStatus.OK).body((Object)ret);
    }

    @PostMapping(value={"/alertconfig"})
    public boolean putAlertConfig(@RequestParam(value="settings") ConfiguredAlertMethods b) {
        LOG.log(Level.INFO, "Set alert settings {0}", b);
        this.alertController.saveConfig(b);
        return true;
    }

    @PostMapping(value={"/nouissl"})
    public boolean stopIUSSL(@RequestParam(value="port") int port) {
        this.settings.setUISSL(false);
        if (port != this.settings.getUISSLPort()) {
            this.settings.setUIPort(port);
            LOG.log(Level.INFO, "unset ssl for UI port is now {0}", port);
        } else {
            LOG.log(Level.INFO, "unset ssl for UI port is now {0}", this.settings.getUIPort());
        }
        return true;
    }

    @GetMapping(value={"/uisslconfig"})
    public ResponseEntity<UISSLSettings> getUISSLConfig() {
        UISSLSettings ret = UISSLSettings.fromSettingsFile((SettingsFile)this.settings);
        return ResponseEntity.status((HttpStatusCode)HttpStatus.OK).body((Object)ret);
    }

    @PostMapping(value={"/uisslfromcerts"})
    public boolean putUISSLConfigFromCerts(@RequestParam(value="key") MultipartFile key, @RequestParam(value="certs") MultipartFile certs, @RequestParam(value="certs2") MultipartFile certs2, @RequestParam(value="port") int port) {
        InputStream keyStr = null;
        try {
            LOG.log(Level.INFO, "Set ui ssl settings from certs");
            keyStr = key.getInputStream();
            Optional<Object> certStr = Optional.empty();
            Optional<Object> certStr2 = Optional.empty();
            if (certs != null && !certs.isEmpty()) {
                certStr = Optional.of(certs.getInputStream());
            }
            if (certs2 != null && !certs2.isEmpty()) {
                certStr2 = Optional.of(certs2.getInputStream());
            }
            return this.jettyssl.fromCerts(keyStr, certStr, certStr2, port);
        }
        catch (IOException ex) {
            Logger.getLogger(SettingsRestService.class.getName()).log(Level.SEVERE, null, ex);
            return false;
        }
    }

    @PostMapping(value={"/uisslfromcertspath"})
    public boolean putUISSLConfigFromCertsPath(@RequestParam(value="key") String key, @RequestParam(value="certs") String certs, @RequestParam(value="certs2") String certs2, @RequestParam(value="port") int port) {
        LOG.log(Level.INFO, "Set ui ssl settings from file");
        Optional<Object> certOpt = Optional.empty();
        Optional<Object> certOpt2 = Optional.empty();
        if (certs != null && !certs.isEmpty()) {
            certOpt = Optional.of(certs);
        }
        if (certs2 != null && !certs2.isEmpty()) {
            certOpt2 = Optional.of(certs2);
        }
        return this.jettyssl.fromCertsPath(key, certOpt, certOpt2, port);
    }

    @PostMapping(value={"/uisslfromkeystore"})
    public boolean putUISSLConfigFromKeyStore(@RequestParam(value="keystore") MultipartFile keystore, @RequestParam(value="keystorepwd") String keystorepwd, @RequestParam(value="keypwd") String keypwd, @RequestParam(value="alias") String alias, @RequestParam(value="port") int port) {
        InputStream keyStr = null;
        try {
            LOG.log(Level.INFO, "Set ui ssl settings from ks");
            keyStr = keystore.getInputStream();
            byte[] bytes = IOUtils.toByteArray((InputStream)keyStr);
            String name = keystore.getOriginalFilename();
            return this.jettyssl.fromKeyStore(bytes, name, keystorepwd, keypwd, alias, port);
        }
        catch (IOException ex) {
            Logger.getLogger(SettingsRestService.class.getName()).log(Level.SEVERE, null, ex);
            return false;
        }
    }

    @PostMapping(value={"/uisslfromkeystorepath"})
    public boolean putUISSLConfigFromKeyStorePath(@RequestParam(value="keystore") String keystore, @RequestParam(value="keystorepwd") String keystorepwd, @RequestParam(value="keypwd") String keypwd, @RequestParam(value="alias") String alias, @RequestParam(value="port") int port) {
        LOG.log(Level.INFO, "Set ui ssl settings from ks path");
        return this.jettyssl.fromKeyStorePath(keystore, keystorepwd, keypwd, alias, port);
    }

    @PostMapping(value={"/getsubdir"})
    public List<WebFolder> getSubDir(@RequestParam(value="path") String path, @RequestParam(value="ext") List<String> extensions) {
        FolderBrowser fsbrowser = new FolderBrowser(extensions);
        return fsbrowser.browse(path);
    }

    @GetMapping(value={"/buildversion"})
    public String getBuildInfo() {
        return this.buildVersion.getBuildVersionAtTime();
    }

    @PostMapping(value={"/unsetlogo"})
    public boolean unsetLogo() {
        Path folder = WorkingFolder.getIconFolder().toPath();
        String filename = "logo.stored";
        try {
            Files.delete(folder.resolve(filename));
            return true;
        }
        catch (NoSuchFileException e) {
            LOG.info("No logo file to unset");
            return true;
        }
        catch (IOException ex) {
            Logger.getLogger(SettingsRestService.class.getName()).log(Level.SEVERE, null, ex);
            return false;
        }
    }

    @PostMapping(value={"/uploadlogo"})
    public boolean handleLogoFileUpload(@RequestParam(value="file") MultipartFile file) {
        boolean bl;
        block8: {
            Path folder = WorkingFolder.getIconFolder().toPath();
            String filename = "logo.stored";
            InputStream inputStream = file.getInputStream();
            try {
                Files.copy(inputStream, folder.resolve(filename), StandardCopyOption.REPLACE_EXISTING);
                LOG.log(Level.INFO, "Stored logo {0}", file.getOriginalFilename());
                bl = true;
                if (inputStream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException ex) {
                    Logger.getLogger(SettingsRestService.class.getName()).log(Level.SEVERE, null, ex);
                    return false;
                }
            }
            inputStream.close();
        }
        return bl;
    }

    @GetMapping(value={"/logo"})
    public ResponseEntity<Resource> getLogo() {
        try {
            Path folder = WorkingFolder.getIconFolder().toPath();
            String filename = "logo.stored";
            Path toFile = folder.resolve(filename);
            UrlResource resource = new UrlResource(toFile.toUri());
            if (resource.exists() || resource.isReadable()) {
                return ResponseEntity.ok().contentType(MediaType.APPLICATION_OCTET_STREAM).body((Object)resource);
            }
        }
        catch (MalformedURLException ex) {
            Logger.getLogger(SettingsRestService.class.getName()).log(Level.SEVERE, null, ex);
        }
        return ResponseEntity.notFound().build();
    }

    @GetMapping(value={"/companyname"})
    public ResponseEntity<String> getCompanyName() {
        String ret = this.settings.getCompanyName();
        return ResponseEntity.status((HttpStatusCode)HttpStatus.OK).body((Object)ret);
    }

    @PostMapping(value={"/companyname"})
    public boolean putCompanyName(@RequestParam(value="name") String name) {
        LOG.log(Level.INFO, "Set company name {0}", name);
        this.settings.setCompanyName(name);
        return true;
    }

    @GetMapping(value={"/defaultalertsubject"})
    public ResponseEntity<String> getDefaultAlertSubject() {
        String ret = this.settings.getDefaultAlertSubject();
        return ResponseEntity.status((HttpStatusCode)HttpStatus.OK).body((Object)ret);
    }

    @PostMapping(value={"/defaultalertsubject"})
    public boolean putDefaultAlertSubject(@RequestParam(value="alert_subject") String alertSubject) {
        LOG.log(Level.INFO, "Set Default Alert Subject {0}", alertSubject);
        this.settings.setDefaultAlertSubject(alertSubject);
        return true;
    }

    @GetMapping(value={"/datarepo"})
    public String getDataRepo() {
        String ret = this.settings.getDataRepository();
        if (ret.isEmpty()) {
            ret = WorkingFolder.getDefaultDataRepoFolder();
        }
        return ret;
    }

    @PostMapping(value={"/datarepo"})
    public boolean putDataRepo(@RequestParam(value="folder") String folder) {
        File f = new File(folder);
        if (!f.exists()) {
            LOG.log(Level.WARNING, "Folder does not exist {0}", folder);
            return false;
        }
        if (!f.isDirectory()) {
            LOG.log(Level.WARNING, "Not a folder {0}", folder);
            return false;
        }
        this.settings.setDataRepository(folder);
        return true;
    }

    @GetMapping(value={"/ldapindividualreports"})
    public boolean getLDAPEnabledForIndividualReports() {
        return this.settings.getLDAPEnabledForIndividualReports() && this.settings.getLDAPEnabled();
    }

    @GetMapping(value={"/ldapindividualreportsignorefailures"})
    public boolean getLDAPIgnoreFailuresForIndividualReports() {
        return this.settings.getIgnoreLDAPFailureForIndividualReports() && this.settings.getLDAPEnabled();
    }

    @GetMapping(value={"/ldapconfig"})
    public ResponseEntity<WebLDAPConfig> getLdapConfig() {
        return ResponseEntity.status((HttpStatusCode)HttpStatus.OK).body((Object)new LDAPConfig().toWebLdapConfig());
    }

    @PostMapping(value={"/ldapconfig"})
    public boolean putLdapConfig(@RequestParam(value="config") WebLDAPConfig config) {
        LDAPConfig.update((WebLDAPConfig)config);
        return true;
    }

    @GetMapping(value={"/availableexport"})
    public ImportExportFormat getAvailableToExport() {
        return this.importExport.getAllToExport();
    }

    @PostMapping(value={"/selectedexport"})
    public ResponseEntity<ByteArrayResource> selectedExportToString(Principal principal, @RequestParam(value="selected") ImportExportFormat format) {
        String name = "unknown";
        if (principal != null) {
            name = principal.getName();
        }
        Instant instant = Instant.now().truncatedTo(ChronoUnit.SECONDS);
        String version = this.buildVersion.getBuildVersion();
        String str = instant.toString().replace("-", "").replace(":", "");
        String filename = "DataDiscoveryTaskExport_" + name + "_" + str + "_" + version + ".json";
        String content = this.importExport.exportToString(name, format);
        ByteArrayResource body = new ByteArrayResource(content.getBytes());
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().header("Content-Disposition", new String[]{filename})).body((Object)body);
    }

    @PostMapping(value={"/convertImport"})
    public ResponseEntity<ImportExportFormat> convertImportFile(@RequestParam(value="file") MultipartFile file) {
        try {
            byte[] bytes = file.getBytes();
            String s = new String(bytes, "UTF-8");
            Optional ret = this.importExport.fullImportFromString(s);
            if (ret.isEmpty()) {
                return ResponseEntity.status((HttpStatusCode)HttpStatus.UNPROCESSABLE_ENTITY).body(null);
            }
            return ResponseEntity.status((HttpStatusCode)HttpStatus.OK).body((Object)((ImportExportFormat)ret.get()));
        }
        catch (IOException ex) {
            Logger.getLogger(SettingsRestService.class.getName()).log(Level.SEVERE, null, ex);
            return ResponseEntity.status((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR).body(null);
        }
    }

    @PostMapping(value={"/selectedimport"})
    public ImportExportFormat importSelected(Principal principal, @RequestParam(value="selected") ImportExportFormat format) {
        String name = "unknown";
        if (principal != null) {
            name = principal.getName();
        }
        return this.importExport.importSelected(name, format);
    }

    @GetMapping(value={"/allowedcontentreason"})
    public boolean getAllowedContentReason() {
        return this.settings.getAllowedContentReason();
    }

    @PostMapping(value={"/allowedcontentreason"})
    public boolean setAllowedContentReason(@RequestParam(value="set") boolean set) {
        this.settings.setAllowedContentReason(Boolean.valueOf(set));
        return true;
    }

    @GetMapping(value={"/canbackupdb"})
    public boolean getCanBackupDb() {
        return this.derbyBackup.usingDerbyDb();
    }

    @PostMapping(value={"/backupdb"})
    public boolean backupdb() {
        return this.derbyBackup.backup();
    }

    @GetMapping(value={"/isbackingupdb"})
    public boolean isBackingUp() {
        return this.derbyBackup.isBackingUp();
    }

    @GetMapping(value={"/listdbbackups"})
    public List<String> listDbBackups() {
        return this.derbyBackup.listBackups();
    }

    @PostMapping(value={"/deletedbbackup"})
    public boolean deletebackup(@RequestParam(value="name") String name) {
        return this.derbyBackup.deleteBackup(name);
    }

    @GetMapping(value={"/servertimezone"})
    public String getServerTimeZone() {
        ZoneId z = ZoneId.systemDefault();
        return z.getId();
    }

    @GetMapping(value={"/allowedknowledgeBase"})
    public boolean getAllowedKnowledgeBase() {
        return this.settings.getKBaseEnabled();
    }

    @PostMapping(value={"/allowedknowledgeBase"})
    public boolean setAllowedKnowledgeBase(@RequestParam(value="set") boolean set) {
        this.settings.setKBaseEnabled(set);
        return true;
    }

    @InitBinder
    public void initBinder(WebDataBinder dataBinder) {
        dataBinder.registerCustomEditor(PortsInfo.class, (PropertyEditor)new /* Unavailable Anonymous Inner Class!! */);
        dataBinder.registerCustomEditor(SMTPSettings.class, (PropertyEditor)new /* Unavailable Anonymous Inner Class!! */);
        dataBinder.registerCustomEditor(ConfiguredAlertMethods.class, (PropertyEditor)new /* Unavailable Anonymous Inner Class!! */);
        dataBinder.registerCustomEditor(UISSLSettings.class, (PropertyEditor)new /* Unavailable Anonymous Inner Class!! */);
        dataBinder.registerCustomEditor(WebLDAPConfig.class, (PropertyEditor)new /* Unavailable Anonymous Inner Class!! */);
        dataBinder.registerCustomEditor(ImportExportFormat.class, (PropertyEditor)new /* Unavailable Anonymous Inner Class!! */);
    }
}

