/*
 * Decompiled with CFR 0.152.
 */
package com.geolang.ascema.managerservice.rest;

import com.geolang.ascema.domainmodelpublic.Confidence;
import com.geolang.ascema.domainmodelpublic.ResultStatus;
import com.geolang.ascema.endpointcommon.domain.BaseCommand;
import com.geolang.ascema.endpointcommon.domain.RetrievalSearchCommand;
import com.geolang.ascema.endpointcommon.domain.searchconfig.UnifiedSearchConfiguration;
import com.geolang.ascema.managercore.MessageBus;
import com.geolang.ascema.managerdomain.datapoint.DataSliceRequest;
import com.geolang.ascema.managerdomain.domain.JobDeviceState;
import com.geolang.ascema.managerdomain.domain.TaskInstance;
import com.geolang.ascema.managerdomain.domain.TaskTemplate;
import com.geolang.ascema.managerdomain.dto.GroupBy;
import com.geolang.ascema.managerdomain.web.CreateCompoundPattern;
import com.geolang.ascema.managerdomain.web.RunCommand;
import com.geolang.ascema.managerdomain.web.SearchStateSummaryCollection;
import com.geolang.ascema.managerdomain.web.SmallDetails;
import com.geolang.ascema.managerdomain.web.WebFolder;
import com.geolang.ascema.managerdomain.web.WebSchedule;
import com.geolang.ascema.managerdomain.web.results.DataRequestFilter;
import com.geolang.ascema.managerpersistence.ClassificationLabelStore;
import com.geolang.ascema.managerpersistence.ContextWordStore;
import com.geolang.ascema.managerpersistence.FileExtensionStore;
import com.geolang.ascema.managerpersistence.results.DataPoint;
import com.geolang.ascema.managerpersistence.results.DataPointSlice;
import com.geolang.ascema.managerservice.controllers.FolderBrowser;
import com.geolang.ascema.managerservice.controllers.SchedulingService;
import com.geolang.ascema.managerservice.controllers.devices.DeviceService;
import com.geolang.ascema.managerservice.controllers.patterns.PatternService;
import com.geolang.ascema.managerservice.controllers.retrieval.FileRetrievalManager;
import com.geolang.ascema.managerservice.controllers.retrieval.RetrievalResultsManager;
import com.geolang.ascema.managerservice.controllers.tasks.JobRunner;
import com.geolang.ascema.managerservice.controllers.tasks.TaskManager;
import com.geolang.ascema.managerservice.license.LicenseManager;
import com.geolang.ascema.managerservice.rest.requests.retrieval.DownloadZipCommand;
import com.geolang.ascema.managerservice.rest.requests.retrieval.FileExtensionCount;
import com.geolang.ascema.managerservice.rest.requests.retrieval.RetrievalSearchJobInstance;
import com.geolang.ascema.managerservice.rest.requests.retrieval.RetrievalSearchJobTemplate;
import com.google.common.net.UrlEscapers;
import jakarta.annotation.PostConstruct;
import jakarta.annotation.PreDestroy;
import jakarta.servlet.http.HttpServletResponse;
import java.beans.PropertyEditor;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.CacheControl;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.WebDataBinder;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.InitBinder;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/retrieval"})
public class RetrievalRestService {
    private static final Logger LOG = Logger.getLogger(RetrievalRestService.class.getName());
    @Autowired
    private DeviceService endpointController;
    @Autowired
    private TaskManager taskManager;
    @Autowired
    private JobRunner jobRunner;
    @Autowired
    private SchedulingService scheduler;
    @Autowired
    private PatternService patternService;
    @Autowired
    private FileExtensionStore fileExtManager;
    @Autowired
    private RetrievalResultsManager resultsManager;
    @Autowired
    private FileRetrievalManager fileRetrievalManager;
    private final FolderBrowser fsbrowser = new FolderBrowser();
    @Autowired
    private LicenseManager licenseManager;
    @Autowired
    private ContextWordStore contextWords;
    @Autowired
    private ClassificationLabelStore classificationLabelsStore;

    @PostConstruct
    public void afterPropertiesSet() throws Exception {
        MessageBus.getBus().register((Object)this);
    }

    @PreDestroy
    public void destroy() throws Exception {
        MessageBus.getBus().unregister((Object)this);
    }

    @RequestMapping(value={"/instances/{searchJobTemplateId}"})
    List<RetrievalSearchJobInstance> getAllInstancesForTemplate(@PathVariable(value="searchJobTemplateId") String searchJobTemplateId) {
        ArrayList<RetrievalSearchJobInstance> ret = new ArrayList<RetrievalSearchJobInstance>();
        List jps = this.taskManager.getAllInstancesForTemplate(searchJobTemplateId);
        for (TaskInstance jp : jps) {
            RetrievalSearchJobInstance sjt = new RetrievalSearchJobInstance(jp, this.endpointController, this.patternService);
            ret.add(sjt);
        }
        return ret;
    }

    @RequestMapping(value={"/templates"})
    List<RetrievalSearchJobTemplate> getAllTemplates() {
        ArrayList<RetrievalSearchJobTemplate> ret = new ArrayList<RetrievalSearchJobTemplate>();
        ArrayList jps = this.taskManager.getAllTemplatesOfType(BaseCommand.CommandType.RETRIEVAL);
        for (TaskTemplate jp : jps) {
            Date lastRan = this.taskManager.getLastRanOrNull(jp.getUid());
            RetrievalSearchJobTemplate sjt = new RetrievalSearchJobTemplate(jp, this.scheduler, this.patternService, lastRan);
            ret.add(sjt);
        }
        return ret;
    }

    @RequestMapping(value={"/template/{id}"})
    RetrievalSearchJobTemplate getTemplate(@PathVariable(value="id") String templateId) {
        TaskTemplate tt = this.taskManager.getTemplateFromId(templateId);
        if (tt != null) {
            Date lastRan = this.taskManager.getLastRanOrNull(tt.getUid());
            return new RetrievalSearchJobTemplate(tt, this.scheduler, this.patternService, lastRan);
        }
        return null;
    }

    @RequestMapping(value={"/templates/ids"})
    List<SmallDetails> getAllTemplatesIds() {
        ArrayList<SmallDetails> ret = new ArrayList<SmallDetails>();
        for (TaskTemplate t : this.taskManager.getAllTemplatesOfType(BaseCommand.CommandType.RETRIEVAL)) {
            ret.add(new SmallDetails(t.getUid(), t.getDisplayName(), t.getCreated(), "", false));
        }
        return ret;
    }

    @DeleteMapping(value={"/template/{searchJobTemplateId}/{deleteInstances}/{deleteRepos}"})
    public boolean deleteTemplate(Principal principal, @PathVariable(value="searchJobTemplateId") String searchJobTemplateId, @PathVariable(value="deleteInstances") boolean deleteInstances, @PathVariable(value="deleteRepos") boolean deleteRepos) {
        String name = "unknown";
        if (principal != null) {
            name = principal.getName();
        }
        return this.fileRetrievalManager.deleteTemplate(name, searchJobTemplateId, deleteInstances, deleteRepos);
    }

    @DeleteMapping(value={"/delete/{searchJobInstanceId}/{deleteRepos}"})
    public boolean delete(Principal principal, @PathVariable(value="searchJobInstanceId") String searchJobInstanceId, @PathVariable(value="deleteRepos") boolean deleteRepos) {
        String name = "unknown";
        if (principal != null) {
            name = principal.getName();
        }
        return this.fileRetrievalManager.deleteTaskInstance(name, searchJobInstanceId, deleteRepos);
    }

    @RequestMapping(value={"/template/statesummaries"})
    public List<SearchStateSummaryCollection> getAllStateSummaries() {
        return this.taskManager.getAllSummaries(BaseCommand.CommandType.RETRIEVAL);
    }

    @PostMapping(value={"/subslice"})
    ResponseEntity<List<DataPoint>> getSubSlice(@RequestParam(value="req") DataSliceRequest res) {
        GroupBy gb = GroupBy.values()[res.getGroupby()];
        ArrayList<String> resultStatuses = new ArrayList<String>();
        for (int i : res.getStatuses()) {
            resultStatuses.add(ResultStatus.values()[i].name());
        }
        Confidence conf = Confidence.values()[res.getMinConfidence()];
        DataRequestFilter filter = new DataRequestFilter(res.getFilterString(), resultStatuses, res.isShowIgnore(), conf, res.isForceRefresh());
        List ret = this.resultsManager.getSubSlice(Arrays.asList(res.getTaskIds()), res.getKey(), filter, gb, res.getStart(), res.getRows());
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().cacheControl(CacheControl.maxAge((long)10L, (TimeUnit)TimeUnit.SECONDS))).body((Object)ret);
    }

    @PostMapping(value={"/get"})
    ResponseEntity<DataPointSlice> getLatestResults(@RequestParam(value="req") DataSliceRequest res) {
        GroupBy gb = GroupBy.values()[res.getGroupby()];
        ArrayList<String> resultStatuses = new ArrayList<String>();
        for (int i : res.getStatuses()) {
            resultStatuses.add(ResultStatus.values()[i].name());
        }
        Confidence conf = Confidence.values()[res.getMinConfidence()];
        DataRequestFilter filter = new DataRequestFilter(res.getFilterString(), resultStatuses, res.isShowIgnore(), conf, res.isForceRefresh());
        Optional ret = this.resultsManager.getResultsSlice(res.isForceRefresh(), Arrays.asList(res.getTaskIds()), filter, gb, res.getStart(), res.getRows());
        if (!ret.isPresent()) {
            return ResponseEntity.status((HttpStatusCode)HttpStatus.UNPROCESSABLE_ENTITY).body(null);
        }
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().cacheControl(CacheControl.maxAge((long)10L, (TimeUnit)TimeUnit.SECONDS))).body((Object)((DataPointSlice)ret.get()));
    }

    @PostMapping(value={"/template/add"})
    public ResponseEntity<RetrievalSearchJobTemplate> add(Principal principal, @RequestBody RetrievalSearchJobTemplate s) {
        if (this.licenseManager.isExpired()) {
            LOG.warning("License expired - not creating search");
            return ResponseEntity.status((HttpStatusCode)HttpStatus.NOT_ACCEPTABLE).body(null);
        }
        String name = "unknown";
        if (principal != null) {
            name = principal.getName();
        }
        if (this.taskManager.templateExists(s.getName())) {
            return ResponseEntity.status((HttpStatusCode)HttpStatus.CONFLICT).body(null);
        }
        if (!TaskManager.isValidTemplateName((String)s.getName())) {
            return ResponseEntity.status((HttpStatusCode)HttpStatus.NOT_ACCEPTABLE).body(null);
        }
        UnifiedSearchConfiguration config = s.toConfig(this.fileExtManager, this.contextWords, this.classificationLabelsStore);
        RetrievalSearchCommand command = new RetrievalSearchCommand(s.getBaseDataFolder(), config);
        RetrievalSearchJobTemplate t = new RetrievalSearchJobTemplate(this.taskManager.addTemplate(name, (BaseCommand)command, s.getName(), s.getPriority(), false, ""), this.scheduler, this.patternService, null);
        return new ResponseEntity((Object)t, (HttpStatusCode)HttpStatus.OK);
    }

    @RequestMapping(value={"/instancenames/{searchJobTemplateId}"})
    List<SmallDetails> getAllInstancesNamesForTemplate(@PathVariable(value="searchJobTemplateId") String searchJobTemplateId) {
        ArrayList<SmallDetails> ret = new ArrayList<SmallDetails>();
        List jps = this.taskManager.getAllInstancesForTemplate(searchJobTemplateId);
        for (TaskInstance jp : jps) {
            if (!jp.getCommandType().equals((Object)BaseCommand.CommandType.RETRIEVAL)) continue;
            String actionDisplay = "";
            boolean allCancelled = true;
            for (JobDeviceState state : jp.getDeviceStates()) {
                if (state.getState().isCancelled()) continue;
                allCancelled = false;
                break;
            }
            ret.add(new SmallDetails(jp.getUid(), jp.getDisplayName(), jp.getCreated(), actionDisplay, allCancelled));
        }
        return ret;
    }

    @RequestMapping(value={"/instance/{searchJobInstanceId}"})
    RetrievalSearchJobInstance getInstanceFromId(@PathVariable(value="searchJobInstanceId") String searchJobInstanceId) {
        Optional jp = this.taskManager.getTaskInstanceFromId(searchJobInstanceId);
        if (jp.isPresent()) {
            return new RetrievalSearchJobInstance((TaskInstance)jp.get(), this.endpointController, this.patternService);
        }
        return null;
    }

    @PostMapping(value={"/run"})
    public ResponseEntity<RetrievalSearchJobInstance> run(Principal principal, @RequestBody RunCommand com) {
        if (this.licenseManager.isExpired()) {
            LOG.warning("License expired - not running search");
            return ResponseEntity.status((HttpStatusCode)HttpStatus.NOT_ACCEPTABLE).body(null);
        }
        String name = principal.getName();
        TaskTemplate template = this.taskManager.getTemplateFromId(com.getTemplateId());
        if (template == null) {
            return new ResponseEntity(null, (HttpStatusCode)HttpStatus.NOT_FOUND);
        }
        if (com.isRunOnAllDevices()) {
            TaskInstance plan = this.jobRunner.runCommandOnAllDevices(name, template, com.getName(), com.getPriority(), false, false, com.isOverrideQuietTime());
            return new ResponseEntity((Object)new RetrievalSearchJobInstance(plan, this.endpointController, this.patternService), (HttpStatusCode)HttpStatus.OK);
        }
        TaskInstance plan = this.jobRunner.runCommandOnDevices(name, template, com.getName(), com.getPriority(), com.getDeviceIds(), false, false, com.isOverrideQuietTime());
        return new ResponseEntity((Object)new RetrievalSearchJobInstance(plan, this.endpointController, this.patternService), (HttpStatusCode)HttpStatus.OK);
    }

    @PostMapping(value={"/getsubdir"})
    public List<WebFolder> getSubDir(@RequestParam(value="path") String path) {
        return this.fsbrowser.browse(path);
    }

    @RequestMapping(value={"/fileextcounts/{taskId}"})
    public ResponseEntity<FileExtensionCount[]> getDeviceById(@PathVariable(value="taskId") String taskId) {
        List counts = this.resultsManager.getExtensionCountsForRepo(taskId);
        return new ResponseEntity((Object)counts.toArray(new FileExtensionCount[0]), (HttpStatusCode)HttpStatus.OK);
    }

    @PostMapping(value={"/downloadzip"})
    @ResponseBody
    public byte[] downloadZip(HttpServletResponse response, @RequestParam(value="command") DownloadZipCommand command) {
        byte[] byArray;
        ByteArrayOutputStream str = new ByteArrayOutputStream();
        try {
            this.fileRetrievalManager.getZipFile(str, command);
            byArray = str.toByteArray();
        }
        catch (Throwable throwable) {
            try {
                try {
                    str.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException ex) {
                Logger.getLogger(RetrievalRestService.class.getName()).log(Level.SEVERE, null, ex);
                return new byte[0];
            }
        }
        str.close();
        return byArray;
    }

    @PostMapping(value={"/openfile"})
    @ResponseBody
    public HttpEntity<byte[]> openfile(HttpServletResponse response, @RequestParam(value="path") String path) {
        HttpEntity httpEntity;
        Path p = Paths.get(path, new String[0]);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_OCTET_STREAM);
        String filename = p.getFileName().toString().replace("\"", "_");
        String encFilename = UrlEscapers.urlPathSegmentEscaper().escape(p.getFileName().toString());
        response.setHeader("Content-Disposition", "attachment; filename=\"" + filename + "\"; filename*=\"" + encFilename + "\"");
        ByteArrayOutputStream str = new ByteArrayOutputStream();
        try {
            this.fileRetrievalManager.openFile(str, path);
            httpEntity = new HttpEntity((Object)str.toByteArray(), (MultiValueMap)headers);
        }
        catch (Throwable throwable) {
            try {
                try {
                    str.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException ex) {
                Logger.getLogger(RetrievalRestService.class.getName()).log(Level.SEVERE, null, ex);
                return new HttpEntity((Object)new byte[0], (MultiValueMap)headers);
            }
        }
        str.close();
        return httpEntity;
    }

    @GetMapping(value={"/unredact/{id}"})
    public String unredact(@PathVariable(value="id") Long id) {
        Optional retOpt = this.resultsManager.unRedactMatch(id);
        if (retOpt.isEmpty()) {
            return null;
        }
        return (String)retOpt.get();
    }

    @InitBinder
    public void initBinder(WebDataBinder dataBinder) {
        dataBinder.registerCustomEditor(CreateCompoundPattern.class, (PropertyEditor)new /* Unavailable Anonymous Inner Class!! */);
        dataBinder.registerCustomEditor(RunCommand.class, (PropertyEditor)new /* Unavailable Anonymous Inner Class!! */);
        dataBinder.registerCustomEditor(DownloadZipCommand.class, (PropertyEditor)new /* Unavailable Anonymous Inner Class!! */);
        dataBinder.registerCustomEditor(WebSchedule.class, (PropertyEditor)new /* Unavailable Anonymous Inner Class!! */);
        dataBinder.registerCustomEditor(DataSliceRequest.class, (PropertyEditor)new /* Unavailable Anonymous Inner Class!! */);
        dataBinder.registerCustomEditor(RetrievalSearchJobTemplate.class, (PropertyEditor)new /* Unavailable Anonymous Inner Class!! */);
    }
}

