/*
 * Decompiled with CFR 0.152.
 */
package com.geolang.ascema.managerservice.rest;

import com.geolang.ascema.domainmodelpublic.Confidence;
import com.geolang.ascema.domainmodelpublic.ResultStatus;
import com.geolang.ascema.domainmodelpublic.ResultStatusReason;
import com.geolang.ascema.endpointcommon.domain.AlertMsg;
import com.geolang.ascema.managerdomain.datapoint.DataSliceRequest;
import com.geolang.ascema.managerdomain.datapoint.Match;
import com.geolang.ascema.managerdomain.domain.MatchStored;
import com.geolang.ascema.managerdomain.dto.GroupBy;
import com.geolang.ascema.managerdomain.web.ConfirmCommand;
import com.geolang.ascema.managerdomain.web.ExportFormat;
import com.geolang.ascema.managerdomain.web.SetStatusForFileCommand;
import com.geolang.ascema.managerdomain.web.UnprocessableDataSliceRequest;
import com.geolang.ascema.managerdomain.web.UnprocessableResultsPage;
import com.geolang.ascema.managerdomain.web.UpdateIndividualResultsStatusCommand;
import com.geolang.ascema.managerdomain.web.results.DataRequest;
import com.geolang.ascema.managerdomain.web.results.DataRequestFilter;
import com.geolang.ascema.managerpersistence.results.DataPoint;
import com.geolang.ascema.managerpersistence.results.DataPointSlice;
import com.geolang.ascema.managerservice.controllers.EventHistoryManager;
import com.geolang.ascema.managerservice.controllers.results.ResultsManager;
import com.geolang.ascema.managerservice.controllers.results.UnprocessableResultsManager;
import com.geolang.ascema.managerservice.controllers.results.export.ExportController;
import com.geolang.ascema.managerservice.controllers.tasks.JobRunner;
import java.beans.PropertyEditor;
import java.io.File;
import java.io.IOException;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.FileSystemResource;
import org.springframework.http.CacheControl;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.web.bind.WebDataBinder;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.InitBinder;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/results"})
public class ResultsRestService {
    @Autowired
    private ExportController exportController;
    @Autowired
    private ResultsManager resultsManager;
    @Autowired
    private JobRunner jobRunner;
    @Autowired
    private EventHistoryManager eventHistory;
    @Autowired
    private UnprocessableResultsManager unprocessableManager;
    private static final Logger LOG = Logger.getLogger(ResultsRestService.class.getName());

    @PostMapping(value={"/getdevicelatest"})
    ResponseEntity<DataPointSlice> getLatestResultsForDevice(@RequestParam(value="req") DataSliceRequest res) {
        ArrayList<String> resultStatuses = new ArrayList<String>();
        for (int i : res.getStatuses()) {
            resultStatuses.add(ResultStatus.values()[i].name());
        }
        DataRequestFilter filter = new DataRequestFilter(res.getFilterString(), resultStatuses, res.isShowIgnore(), res.isForceRefresh());
        DataRequest dataRequest = DataRequest.buildForDeviceRequest((String)res.getKey(), (int)res.getStart(), (int)res.getRows(), (DataRequestFilter)filter);
        Optional ret = this.resultsManager.getLatestResultsForDevice(dataRequest);
        if (!ret.isPresent()) {
            return ResponseEntity.status((HttpStatusCode)HttpStatus.UNPROCESSABLE_ENTITY).body(null);
        }
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().cacheControl(CacheControl.maxAge((long)10L, (TimeUnit)TimeUnit.SECONDS))).body((Object)((DataPointSlice)ret.get()));
    }

    @PostMapping(value={"/getdevicelatestadmin"})
    ResponseEntity<DataPointSlice> getLatestResultsForDeviceAdmin(@RequestParam(value="req") DataSliceRequest res) {
        return this.getLatestResultsForDevice(res);
    }

    @PostMapping(value={"/geto365userlatest"})
    ResponseEntity<DataPointSlice> getLatestResultsForUser(@RequestParam(value="req") DataSliceRequest res) {
        ArrayList<String> resultStatuses = new ArrayList<String>();
        for (int i : res.getStatuses()) {
            resultStatuses.add(ResultStatus.values()[i].name());
        }
        DataRequestFilter filter = new DataRequestFilter(res.getFilterString(), resultStatuses, res.isShowIgnore(), res.isForceRefresh());
        DataRequest dr = DataRequest.buildForCloudUser((String)res.getKey(), (int)res.getStart(), (int)res.getRows(), (DataRequestFilter)filter);
        Optional ret = this.resultsManager.getLatestResultsForCloudUser(dr);
        if (!ret.isPresent()) {
            return ResponseEntity.status((HttpStatusCode)HttpStatus.UNPROCESSABLE_ENTITY).body(null);
        }
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().cacheControl(CacheControl.maxAge((long)10L, (TimeUnit)TimeUnit.SECONDS))).body((Object)((DataPointSlice)ret.get()));
    }

    @PostMapping(value={"/getfilelatestfordevice"})
    ResponseEntity<List<DataPoint>> getLatestResultsForDeviceForFile(@RequestParam(value="file") String file, @RequestParam(value="req") DataSliceRequest res) {
        ArrayList<String> resultStatuses = new ArrayList<String>();
        for (int i : res.getStatuses()) {
            resultStatuses.add(ResultStatus.values()[i].name());
        }
        DataRequestFilter filter = new DataRequestFilter(res.getFilterString(), resultStatuses, res.isShowIgnore(), res.isForceRefresh());
        DataRequest dataRequest = DataRequest.buildForDeviceRequest((String)res.getKey(), (int)res.getStart(), (int)res.getRows(), (DataRequestFilter)filter);
        List ret = this.resultsManager.getLatestResultsForDeviceForFilePath(file, dataRequest);
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().cacheControl(CacheControl.maxAge((long)10L, (TimeUnit)TimeUnit.SECONDS))).body((Object)ret);
    }

    @PostMapping(value={"/getfilelatestforuser"})
    ResponseEntity<List<DataPoint>> getLatestResultsForUserForFile(@RequestParam(value="file") String file, @RequestParam(value="req") DataSliceRequest res) {
        ArrayList<String> resultStatuses = new ArrayList<String>();
        for (int i : res.getStatuses()) {
            resultStatuses.add(ResultStatus.values()[i].name());
        }
        DataRequestFilter filter = new DataRequestFilter(res.getFilterString(), resultStatuses, res.isShowIgnore(), res.isForceRefresh());
        DataRequest dr = DataRequest.buildForCloudUser((String)res.getKey(), (int)res.getStart(), (int)res.getRows(), (DataRequestFilter)filter);
        List ret = this.resultsManager.getLatestResultsForCloudUserForFilePath(file, dr);
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().cacheControl(CacheControl.maxAge((long)10L, (TimeUnit)TimeUnit.SECONDS))).body((Object)ret);
    }

    @PostMapping(value={"/subslice"})
    ResponseEntity<List<DataPoint>> getSubSlice(@RequestParam(value="req") DataSliceRequest res) {
        GroupBy gb = GroupBy.values()[res.getGroupby()];
        ArrayList<String> resultStatuses = new ArrayList<String>();
        for (int i : res.getStatuses()) {
            resultStatuses.add(ResultStatus.values()[i].name());
        }
        Confidence conf = Confidence.values()[res.getMinConfidence()];
        DataRequestFilter filter = new DataRequestFilter(res.getFilterString(), resultStatuses, res.isShowIgnore(), conf, res.isForceRefresh());
        DataRequest dr = DataRequest.buildForSubSlice(Arrays.asList(res.getTaskIds()), (String)res.getKey(), (DataRequestFilter)filter, (GroupBy)gb, (int)res.getStart(), (int)res.getRows());
        List ret = this.resultsManager.getSubSlice(dr);
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().cacheControl(CacheControl.maxAge((long)10L, (TimeUnit)TimeUnit.SECONDS))).body((Object)ret);
    }

    @PostMapping(value={"/get"})
    ResponseEntity<DataPointSlice> getLatestResults(@RequestParam(value="req") DataSliceRequest res) {
        GroupBy gb = GroupBy.values()[res.getGroupby()];
        ArrayList<String> resultStatuses = new ArrayList<String>();
        for (int i : res.getStatuses()) {
            resultStatuses.add(ResultStatus.values()[i].name());
        }
        Confidence conf = Confidence.values()[res.getMinConfidence()];
        DataRequestFilter filter = new DataRequestFilter(res.getFilterString(), resultStatuses, res.isShowIgnore(), conf, res.isForceRefresh());
        DataRequest dr = DataRequest.buildForInstances(Arrays.asList(res.getTaskIds()), (DataRequestFilter)filter, (GroupBy)gb, (int)res.getStart(), (int)res.getRows());
        Optional ret = this.resultsManager.getResultsSlice(dr);
        if (!ret.isPresent()) {
            return ResponseEntity.status((HttpStatusCode)HttpStatus.UNPROCESSABLE_ENTITY).body(null);
        }
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().cacheControl(CacheControl.maxAge((long)10L, (TimeUnit)TimeUnit.SECONDS))).body((Object)((DataPointSlice)ret.get()));
    }

    @PostMapping(value={"/export"})
    public ResponseEntity<FileSystemResource> downloadExportFile(Principal principal, @RequestParam(value="req") DataSliceRequest res, @RequestParam(value="format") int format, @RequestParam(value="pwd") String pwd, @RequestParam(value="dec") boolean decrypt) {
        Authentication auth;
        if (principal == null) {
            LOG.warning("No user in export");
            return ResponseEntity.status((HttpStatusCode)HttpStatus.FORBIDDEN).body(null);
        }
        GroupBy gb = GroupBy.values()[res.getGroupby()];
        ExportFormat formatType = ExportFormat.values()[format];
        ArrayList<String> resultStatuses = new ArrayList<String>();
        for (int i : res.getStatuses()) {
            resultStatuses.add(ResultStatus.values()[i].name());
        }
        Confidence conf = Confidence.values()[res.getMinConfidence()];
        DataRequestFilter filter = new DataRequestFilter(res.getFilterString(), resultStatuses, res.isShowIgnore(), conf, res.isForceRefresh());
        DataRequest req = DataRequest.buildForExport(Arrays.asList(res.getTaskIds()), (DataRequestFilter)filter, (GroupBy)gb);
        if (decrypt && (auth = SecurityContextHolder.getContext().getAuthentication()) != null && auth.getAuthorities().stream().anyMatch(a -> a.getAuthority().equals("ROLE_AUDITOR"))) {
            req.setShowEncrypted(true);
        }
        try {
            File f = this.exportController.getExport(principal.getName(), req, formatType, pwd);
            if (f != null) {
                FileSystemResource body = new FileSystemResource(f);
                return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().header("Content-Disposition", new String[]{f.getName()})).body((Object)body);
            }
        }
        catch (IOException ex) {
            Logger.getLogger(ResultsRestService.class.getName()).log(Level.SEVERE, null, ex);
        }
        return ResponseEntity.status((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR).body(null);
    }

    @PostMapping(value={"/alertbyid"})
    boolean alertById(Principal principal, @RequestParam(value="ids") Long[] ids, @RequestParam(value="msg") AlertMsg msg, @RequestParam(value="matchid") boolean idIsForMatch) {
        String name = "unknown";
        if (principal != null) {
            name = principal.getName();
        }
        return this.resultsManager.alertManually(name, ids, msg, idIsForMatch);
    }

    @PostMapping(value={"/updatemultiplestatus"})
    boolean updateMultipleResultStatus(Principal principal, @RequestParam(value="username") String username, @RequestParam(value="sentto") String email, @RequestParam(value="commands") UpdateIndividualResultsStatusCommand[] commands) {
        boolean ret = false;
        String name = username;
        if (principal != null) {
            name = principal.getName();
        }
        for (UpdateIndividualResultsStatusCommand com : commands) {
            ArrayList<MatchStored> res = new ArrayList<MatchStored>();
            for (Match wr : com.getResults()) {
                res.add(wr.toPatternMatchResult());
            }
            if (!this.resultsManager.updateSelecteResultStatus(name, email, com.getSearchJobInstanceId(), com.getOtherSearchIds(), com.getDeviceId(), res, com.getFilePath(), com.getSubPath())) continue;
            ret = true;
        }
        return ret;
    }

    @PostMapping(value={"/setstatusforfile"})
    boolean setStatusForFile(Principal principal, @RequestParam(value="username") String username, @RequestParam(value="sentto") String email, @RequestParam(value="commands") SetStatusForFileCommand[] commands) {
        boolean ret = false;
        String name = username;
        if (principal != null) {
            name = principal.getName();
        }
        HashSet<SetStatusForFileCommand> set = new HashSet<SetStatusForFileCommand>();
        set.addAll(Arrays.asList(commands));
        for (SetStatusForFileCommand ss : set) {
            ResultStatus status = ResultStatus.values()[ss.getStatus()];
            ResultStatusReason reason = ResultStatusReason.values()[ss.getReason()];
            ret = this.resultsManager.setStatusForAllResults(name, email, status, reason, ss.getCustomReason(), ss.getSearchJobInstanceId(), ss.getOtherSearchIds(), ss.getDeviceId(), ss.getFilePath(), ss.getSubPath());
        }
        return ret;
    }

    @PostMapping(value={"/confirm"})
    public ResponseEntity<Boolean> confirm(Principal principal, @RequestBody ConfirmCommand com) {
        String[] otherIds;
        ArrayList<MatchStored> res = new ArrayList<MatchStored>();
        for (Match wr : com.getResults()) {
            res.add(wr.toPatternMatchResult());
        }
        String name = "Device User";
        if (principal != null) {
            name = principal.getName();
        }
        if ((otherIds = com.getOtherSearchIds()) == null) {
            otherIds = new String[]{};
        }
        Optional ret = this.jobRunner.runConfirmCommand(name, com.getSearchInstanceId(), otherIds, com.getPriority(), com.getDeviceId(), res, com.getFilePath(), com.getSubPath());
        return new ResponseEntity((Object)ret.isPresent(), (HttpStatusCode)HttpStatus.OK);
    }

    @PostMapping(value={"/openfile"})
    boolean openFile(@RequestParam(value="path") String path, @RequestParam(value="link") String link, @RequestParam(value="devId") String devId) {
        return this.resultsManager.openFile(path, link, devId, false);
    }

    @GetMapping(value={"/unredact/{id}"})
    public String unredact(@PathVariable(value="id") Long id) {
        Optional retOpt = this.resultsManager.unRedactMatch(id);
        if (retOpt.isEmpty()) {
            return null;
        }
        return (String)retOpt.get();
    }

    @PostMapping(value={"/geteventbyid"})
    ResponseEntity<DataPoint> getEventById(@RequestParam(value="eventId") long matchId, @RequestParam(value="groupby") int groupby, @RequestParam(value="isRetrieval") boolean isRetrieval) {
        GroupBy gb = GroupBy.values()[groupby];
        Optional retOpt = this.resultsManager.getMatch(Long.valueOf(matchId), gb, isRetrieval);
        if (retOpt.isEmpty()) {
            return ResponseEntity.status((HttpStatusCode)HttpStatus.NO_CONTENT).body(null);
        }
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().cacheControl(CacheControl.maxAge((long)10L, (TimeUnit)TimeUnit.SECONDS))).body((Object)((DataPoint)retOpt.get()));
    }

    @PostMapping(value={"/historybyfile"})
    ResponseEntity<List<String>> getHistory(@RequestParam(value="deviceId") String deviceId, @RequestParam(value="filePath") String filePath, @RequestParam(value="subPath") String subPath) {
        List ret = this.eventHistory.getHistoryForFile(deviceId, filePath, subPath);
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().cacheControl(CacheControl.maxAge((long)10L, (TimeUnit)TimeUnit.SECONDS))).body((Object)ret);
    }

    @GetMapping(value={"/unprocessablecounttask/{taskInstanceId}"})
    public long unprocessableCountTask(@PathVariable(value="taskInstanceId") String taskId) {
        return this.unprocessableManager.getCount(taskId, "");
    }

    @GetMapping(value={"/unprocessablecount/{taskInstanceId}/{deviceId}"})
    public long unprocessableCount(@PathVariable(value="taskInstanceId") String taskId, @PathVariable(value="deviceId") String deviceId) {
        if (deviceId == null) {
            deviceId = "";
        }
        return this.unprocessableManager.getCount(taskId, deviceId);
    }

    @PostMapping(value={"/unprocessable"})
    public ResponseEntity<UnprocessableResultsPage> getPaginatedResults(@RequestParam(value="filter") UnprocessableDataSliceRequest filter) {
        UnprocessableResultsPage res = this.unprocessableManager.getPageOfResults(filter);
        return ResponseEntity.ok((Object)res);
    }

    @PostMapping(value={"/exportunprocessable"})
    public ResponseEntity<FileSystemResource> downloadUnprocessableExportFile(Principal principal, @RequestParam(value="req") UnprocessableDataSliceRequest req, @RequestParam(value="format") int format, @RequestParam(value="pwd") String pwd) {
        if (principal == null) {
            LOG.warning("No user in export");
            return ResponseEntity.status((HttpStatusCode)HttpStatus.FORBIDDEN).body(null);
        }
        ExportFormat formatType = ExportFormat.values()[format];
        try {
            File f = this.exportController.getUnprocessableExport(principal.getName(), req, formatType, pwd);
            if (f != null) {
                FileSystemResource body = new FileSystemResource(f);
                return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().header("Content-Disposition", new String[]{f.getName()})).body((Object)body);
            }
        }
        catch (IOException ex) {
            Logger.getLogger(ResultsRestService.class.getName()).log(Level.SEVERE, null, ex);
        }
        return ResponseEntity.status((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR).body(null);
    }

    @InitBinder
    public void initBinder(WebDataBinder dataBinder) {
        dataBinder.registerCustomEditor(UnprocessableDataSliceRequest.class, (PropertyEditor)new /* Unavailable Anonymous Inner Class!! */);
        dataBinder.registerCustomEditor(Match.class, (PropertyEditor)new /* Unavailable Anonymous Inner Class!! */);
        dataBinder.registerCustomEditor(ConfirmCommand.class, (PropertyEditor)new /* Unavailable Anonymous Inner Class!! */);
        dataBinder.registerCustomEditor(DataSliceRequest.class, (PropertyEditor)new /* Unavailable Anonymous Inner Class!! */);
        dataBinder.registerCustomEditor(UpdateIndividualResultsStatusCommand[].class, (PropertyEditor)new /* Unavailable Anonymous Inner Class!! */);
        dataBinder.registerCustomEditor(AlertMsg.class, (PropertyEditor)new /* Unavailable Anonymous Inner Class!! */);
        dataBinder.registerCustomEditor(SetStatusForFileCommand[].class, (PropertyEditor)new /* Unavailable Anonymous Inner Class!! */);
    }
}

