/*
 * Decompiled with CFR 0.152.
 */
package com.geolang.ascema.managerservice.rest;

import com.geolang.ascema.endpointcommon.domain.BaseCommand;
import com.geolang.ascema.endpointcommon.domain.SpecialFolderType;
import com.geolang.ascema.endpointcommon.domain.SyncFolder;
import com.geolang.ascema.endpointcommon.domain.searchconfig.rt.RTSearchConfiguration;
import com.geolang.ascema.managercore.MessageBus;
import com.geolang.ascema.managerdomain.domain.TaskInstance;
import com.geolang.ascema.managerdomain.web.SearchStateSummaryCollection;
import com.geolang.ascema.managerdomain.web.SmallDetails;
import com.geolang.ascema.managerpersistence.ClassificationLabelStore;
import com.geolang.ascema.managerpersistence.ContextWordStore;
import com.geolang.ascema.managerpersistence.FileExtensionStore;
import com.geolang.ascema.managerservice.controllers.PathCollectionController;
import com.geolang.ascema.managerservice.controllers.RealTimeProtectionManager;
import com.geolang.ascema.managerservice.controllers.devices.DeviceService;
import com.geolang.ascema.managerservice.controllers.patterns.PatternService;
import com.geolang.ascema.managerservice.controllers.tasks.TaskManager;
import com.geolang.ascema.managerservice.license.LicenseManager;
import com.geolang.ascema.managerservice.rest.CompletableManager;
import com.geolang.ascema.managerservice.rest.NamedCompletableCollection;
import com.geolang.ascema.managerservice.rest.requests.alfresco.WebConnectionStatus;
import com.geolang.ascema.managerservice.rest.requests.tasks.RTTaskInstance;
import jakarta.annotation.PostConstruct;
import jakarta.annotation.PreDestroy;
import java.beans.PropertyEditor;
import java.security.Principal;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.scheduling.annotation.Async;
import org.springframework.web.bind.WebDataBinder;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.InitBinder;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/rtprotect"})
public class RTProtectionRestService {
    private static final Logger LOG = Logger.getLogger(RTProtectionRestService.class.getName());
    private NamedCompletableCollection<String, WebConnectionStatus> deviceToFuture;
    @Autowired
    private DeviceService controller;
    @Autowired
    private TaskManager taskManager;
    @Autowired
    private PatternService patternService;
    @Autowired
    private RealTimeProtectionManager rtmanager;
    @Autowired
    private FileExtensionStore fileExtManager;
    @Autowired
    private LicenseManager licenseManager;
    @Autowired
    private CompletableManager completeMgr;
    @Autowired
    private PathCollectionController pathCollectionController;
    @Autowired
    private ContextWordStore contextWords;
    @Autowired
    private ClassificationLabelStore classificationLabelsStore;

    @PostConstruct
    public void afterPropertiesSet() throws Exception {
        this.deviceToFuture = this.completeMgr.newNamedCollection();
        MessageBus.getBus().register((Object)this);
    }

    @PreDestroy
    public void destroy() throws Exception {
        MessageBus.getBus().unregister((Object)this);
    }

    @RequestMapping(value={"/syncfolders"})
    public List<String> getSyncFolderTypes() {
        ArrayList<String> ret = new ArrayList<String>();
        for (SyncFolder sf : SyncFolder.values()) {
            if (sf.equals((Object)SyncFolder.NONE)) continue;
            ret.add(sf.getDisplayName());
        }
        return ret;
    }

    @RequestMapping(value={"/specialfolders"})
    public List<String> getSpecialFolderTypes() {
        ArrayList<String> ret = new ArrayList<String>();
        for (SpecialFolderType sf : SpecialFolderType.values()) {
            ret.add(sf.getDisplayName());
        }
        return ret;
    }

    @PostMapping(value={"/check"})
    public boolean exists(@RequestParam(value="templatename") String templatename) {
        return this.taskManager.searchOrRTNameExists(templatename);
    }

    @PostMapping(value={"/updateDevices"})
    RTTaskInstance addDeviceToInstance(@RequestBody RTTaskInstance com) {
        TaskInstance ret = this.rtmanager.updateDevices(com);
        return new RTTaskInstance(ret, this.controller, this.patternService, this.taskManager);
    }

    @RequestMapping(value={"/startdevice/{instanceId}/{deviceId}"})
    ResponseEntity<RTTaskInstance> startDeviceOnInstance(@PathVariable(value="instanceId") String instanceId, @PathVariable(value="deviceId") String deviceId) {
        Optional ret = this.rtmanager.startDevice(instanceId, deviceId);
        if (ret.isPresent()) {
            return new ResponseEntity((Object)new RTTaskInstance((TaskInstance)ret.get(), this.controller, this.patternService, this.taskManager), (HttpStatusCode)HttpStatus.OK);
        }
        return ResponseEntity.status((HttpStatusCode)HttpStatus.NOT_FOUND).body(null);
    }

    @RequestMapping(value={"/stopdevice/{instanceId}/{deviceId}"})
    RTTaskInstance stopDeviceOnInstance(@PathVariable(value="instanceId") String instanceId, @PathVariable(value="deviceId") String deviceId) {
        TaskInstance ret = this.rtmanager.stopDevice(instanceId, deviceId);
        return new RTTaskInstance(ret, this.controller, this.patternService, this.taskManager);
    }

    @RequestMapping(value={"/removedevice/{instanceId}/{deviceId}"})
    RTTaskInstance removeDeviceFromInstance(@PathVariable(value="instanceId") String instanceId, @PathVariable(value="deviceId") String deviceId) {
        TaskInstance ret = this.rtmanager.removeDeviceFromTask(instanceId, deviceId);
        return new RTTaskInstance(ret, this.controller, this.patternService, this.taskManager);
    }

    @RequestMapping(value={"/instances"})
    List<RTTaskInstance> getAllInstances() {
        ArrayList<RTTaskInstance> ret = new ArrayList<RTTaskInstance>();
        List tis = this.taskManager.getAllRTInstances();
        for (TaskInstance ti : tis) {
            if (ti.getCommand() == null) {
                this.taskManager.deleteTaskInstance("bob", ti.getUid());
                continue;
            }
            ret.add(new RTTaskInstance(ti, this.controller, this.patternService, this.taskManager));
        }
        return ret;
    }

    @PostMapping(value={"setactionignorename"})
    public ResponseEntity<RTTaskInstance> associateTaskWithIgnorePathCollection(Principal principal, @RequestParam(value="id") String instanceId, @RequestParam(value="name") String pathCollectionName) {
        String name = "unknown";
        if (principal != null) {
            name = principal.getName();
        }
        if (!pathCollectionName.isBlank()) {
            boolean exists = this.pathCollectionController.existsByName(pathCollectionName);
            if (!exists) {
                LOG.log(Level.WARNING, "No Path Collection found with name {0}", pathCollectionName);
                return ResponseEntity.status((HttpStatusCode)HttpStatus.NOT_FOUND).body(null);
            }
        } else {
            LOG.info("Empty path collection name - unsetting");
        }
        LOG.log(Level.INFO, "associate rt instance {0} with path collection {1}, done by {2}", new Object[]{instanceId, pathCollectionName, name});
        Optional opt = this.pathCollectionController.setInstanceActionIgnorePathsName(instanceId, pathCollectionName);
        if (opt.isEmpty()) {
            return ResponseEntity.status((HttpStatusCode)HttpStatus.NOT_ACCEPTABLE).body(null);
        }
        return new ResponseEntity((Object)new RTTaskInstance((TaskInstance)opt.get(), this.controller, this.patternService, this.taskManager), (HttpStatusCode)HttpStatus.OK);
    }

    @RequestMapping(value={"/statesummaries"})
    public List<SearchStateSummaryCollection> getAllStateSummaries() {
        return this.taskManager.getAllSummaries(BaseCommand.CommandType.PROTECT);
    }

    @RequestMapping(value={"/instance/{id}"})
    RTTaskInstance getInstance(@PathVariable(value="id") String id) {
        Optional inst = this.taskManager.getTaskInstanceFromId(id);
        if (inst.isPresent()) {
            return new RTTaskInstance((TaskInstance)inst.get(), this.controller, this.patternService, this.taskManager);
        }
        return null;
    }

    @RequestMapping(value={"/instancenames"})
    List<SmallDetails> getAllInstancesNames() {
        ArrayList<SmallDetails> ret = new ArrayList<SmallDetails>();
        List jps = this.taskManager.getAllRTInstances();
        for (TaskInstance jp : jps) {
            ret.add(new SmallDetails(jp.getUid(), jp.getDisplayName(), jp.getCreated(), "", false));
        }
        return ret;
    }

    @DeleteMapping(value={"/delete/{instanceId}"})
    public boolean delete(Principal principal, @PathVariable(value="instanceId") String instanceId) {
        String name = "unknown";
        if (principal != null) {
            name = principal.getName();
        }
        return this.rtmanager.deleteTask(name, instanceId);
    }

    @PostMapping(value={"/rename"})
    public ResponseEntity<RTTaskInstance> renameTemplate(Principal principal, @RequestParam(value="id") String templateId, @RequestParam(value="name") String newName) {
        String name = "unknown";
        if (principal != null) {
            name = principal.getName();
        }
        LOG.log(Level.INFO, "rename RT template {0} to {1} by {2}", new Object[]{templateId, newName, name});
        Optional opt = this.rtmanager.renameTask(templateId, newName);
        if (opt.isEmpty()) {
            return ResponseEntity.status((HttpStatusCode)HttpStatus.CONFLICT).body(null);
        }
        return new ResponseEntity((Object)new RTTaskInstance((TaskInstance)opt.get(), this.controller, this.patternService, this.taskManager), (HttpStatusCode)HttpStatus.OK);
    }

    @PostMapping(value={"/run"})
    public ResponseEntity<RTTaskInstance> run(Principal principal, @RequestBody RTTaskInstance com) {
        if (this.licenseManager.isExpired()) {
            LOG.warning("License expired - not running rt");
            return ResponseEntity.status((HttpStatusCode)HttpStatus.NOT_ACCEPTABLE).body(null);
        }
        boolean autoAlert = com.isAlertAutomatically();
        RTSearchConfiguration config = com.getConfig().toRTProtectConfiguration(this.fileExtManager, this.contextWords, this.classificationLabelsStore);
        if (com.isRunOnAllDevices()) {
            TaskInstance plan = this.rtmanager.runProtectCommandOnAllDevices(principal.getName(), com.getName(), config, autoAlert, com.getActionIgnorePathsName());
            return new ResponseEntity((Object)new RTTaskInstance(plan, this.controller, this.patternService, this.taskManager), (HttpStatusCode)HttpStatus.OK);
        }
        TaskInstance plan = this.rtmanager.runProtectCommand(principal.getName(), com.getName(), config, com.getDeviceIds(), autoAlert, com.getActionIgnorePathsName());
        return new ResponseEntity((Object)new RTTaskInstance(plan, this.controller, this.patternService, this.taskManager), (HttpStatusCode)HttpStatus.OK);
    }

    @Async
    @PostMapping(value={"/status"})
    public CompletableFuture<WebConnectionStatus> getStatus(@RequestParam(value="deviceId") String deviceId) throws InterruptedException {
        CompletableFuture f = new CompletableFuture();
        return this.deviceToFuture.putOrUpdate((Object)deviceId, 20);
    }

    @InitBinder
    public void initBinder(WebDataBinder dataBinder) {
        dataBinder.registerCustomEditor(RTTaskInstance.class, (PropertyEditor)new /* Unavailable Anonymous Inner Class!! */);
    }
}

