/*
 * Decompiled with CFR 0.152.
 */
package com.geolang.ascema.managerservice.rest;

import com.geolang.ascema.endpointcommon.domain.QuarantineResult;
import com.geolang.ascema.managercore.MessageBus;
import com.geolang.ascema.managerdomain.actions.InFlightAndDeferredActionsCollection;
import com.geolang.ascema.managerdomain.actions.InFlightName;
import com.geolang.ascema.managerdomain.web.QuarantineBulkCommand;
import com.geolang.ascema.managerdomain.web.QuarantineCommand;
import com.geolang.ascema.managerdomain.web.QuarantineJobUpdate;
import com.geolang.ascema.managerdomain.web.QuarantinedDataSliceRequest;
import com.geolang.ascema.managerdomain.web.QuarantinedResultsPage;
import com.geolang.ascema.managerdomain.web.actions.DeviceWithActionableTasks;
import com.geolang.ascema.managerdomain.web.actions.WebInFlight;
import com.geolang.ascema.managerdomain.web.actions.WebInFlightName;
import com.geolang.ascema.managerevents.QuarantineJobDoneEvent;
import com.geolang.ascema.managerservice.controllers.tasks.actions.QuarantineController;
import com.geolang.ascema.managerservice.rest.CompletableManager;
import com.geolang.ascema.managerservice.rest.NamedCompletableCollection;
import com.google.common.eventbus.Subscribe;
import jakarta.annotation.PostConstruct;
import jakarta.annotation.PreDestroy;
import java.beans.PropertyEditor;
import java.security.Principal;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.scheduling.annotation.Async;
import org.springframework.web.bind.WebDataBinder;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.InitBinder;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/quarantine"})
public class QuarantineRestService {
    @Autowired
    private CompletableManager completeMgr;
    @Autowired
    QuarantineController quarantineManager;
    @Autowired
    private InFlightAndDeferredActionsCollection inFlightCollection;
    private QuarantineResult lastResult = null;
    private NamedCompletableCollection<String, QuarantineJobUpdate> futures;

    @PostConstruct
    public void afterPropertiesSet() throws Exception {
        this.futures = this.completeMgr.newNamedCollection();
        MessageBus.getBus().register((Object)this);
    }

    @PreDestroy
    public void destroy() throws Exception {
        MessageBus.getBus().unregister((Object)this);
    }

    @Subscribe
    public void handleJobChange(QuarantineJobDoneEvent ev) {
        QuarantineResult res;
        this.lastResult = res = ev.getResult();
        QuarantineJobUpdate ret = new QuarantineJobUpdate(res.getJobId(), res.getDeviceId(), res.getFilePath(), res.isSuccess(), res.getFailureReason());
        this.futures.completeIfContains((Object)res.getJobId(), (Object)ret);
    }

    @PostMapping(value={"/revertrequest"})
    public boolean revertrequest(@RequestBody QuarantineCommand com) {
        return this.quarantineManager.requestRevert(com.getDeviceId(), com.getFilePath(), com.getQuarantinePath(), com.isAlertWhenDone());
    }

    @PostMapping(value={"/quarantine"})
    public ResponseEntity<String> quarantine(Principal principal, @RequestBody QuarantineCommand com) {
        String ret;
        String user = "User on Device";
        if (principal != null) {
            user = principal.getName();
        }
        if ((ret = this.quarantineManager.runQuarantine(user, com.getDeviceId(), com.getFilePath(), com.getQuarantinePath(), com.isAlertWhenDone())) == null) {
            return new ResponseEntity((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR);
        }
        return new ResponseEntity((Object)ret, (HttpStatusCode)HttpStatus.OK);
    }

    @PostMapping(value={"/revert"})
    public ResponseEntity<String> revert(Principal principal, @RequestBody QuarantineCommand com) {
        String ret = this.quarantineManager.runRevert(principal.getName(), com.getDeviceId(), com.getFilePath(), com.getQuarantinePath(), com.isAlertWhenDone());
        if (ret == null) {
            return new ResponseEntity((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR);
        }
        return new ResponseEntity((Object)ret, (HttpStatusCode)HttpStatus.OK);
    }

    @PostMapping(value={"/delete"})
    public ResponseEntity<String> delete(Principal principal, @RequestBody QuarantineCommand com) {
        String ret;
        String user = "User on Device";
        if (principal != null) {
            user = principal.getName();
        }
        if ((ret = this.quarantineManager.runDelete(user, com.getDeviceId(), com.getFilePath(), com.getQuarantinePath(), com.isAlertWhenDone())) == null) {
            return new ResponseEntity((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR);
        }
        return new ResponseEntity((Object)ret, (HttpStatusCode)HttpStatus.OK);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Async
    @RequestMapping(value={"/wait/{taskId}"})
    public CompletableFuture<QuarantineJobUpdate> waitNotify(@PathVariable(value="taskId") String taskId) throws InterruptedException {
        CompletableFuture<QuarantineJobUpdate> cf = new CompletableFuture<QuarantineJobUpdate>();
        NamedCompletableCollection namedCompletableCollection = this.futures;
        synchronized (namedCompletableCollection) {
            if (this.lastResult != null && this.lastResult.getJobId().equals(taskId)) {
                QuarantineJobUpdate ret = new QuarantineJobUpdate(this.lastResult.getJobId(), this.lastResult.getDeviceId(), this.lastResult.getFilePath(), this.lastResult.isSuccess(), this.lastResult.getFailureReason());
                cf.complete(ret);
            }
            this.futures.put((Object)taskId, cf, 20);
        }
        return cf;
    }

    @PostMapping(value={"/results"})
    public ResponseEntity<QuarantinedResultsPage> getPaginatedResults(@RequestParam(value="filter") QuarantinedDataSliceRequest filter) {
        QuarantinedResultsPage res = this.quarantineManager.getPageOfQuarantineResults(filter);
        return ResponseEntity.ok((Object)res);
    }

    @PostMapping(value={"/performbulk"})
    public ResponseEntity<WebInFlightName> performBulkActions(Principal principal, @RequestBody QuarantineBulkCommand com) {
        InFlightName ret = this.quarantineManager.runBulkActions(principal.getName(), com);
        if (ret == null) {
            return new ResponseEntity(null, (HttpStatusCode)HttpStatus.NOT_FOUND);
        }
        return new ResponseEntity((Object)new WebInFlightName(ret), (HttpStatusCode)HttpStatus.OK);
    }

    @GetMapping(value={"/listinflight"})
    public ResponseEntity<List<WebInFlightName>> getInFlightGroupNames() {
        List inf = this.inFlightCollection.getGroupNamesQuarantine();
        ArrayList<WebInFlightName> ret = new ArrayList<WebInFlightName>();
        for (InFlightName n : inf) {
            ret.add(new WebInFlightName(n));
        }
        return new ResponseEntity(ret, (HttpStatusCode)HttpStatus.OK);
    }

    @PostMapping(value={"/getinflightgroup"})
    public ResponseEntity<List<WebInFlight>> inFlightFromName(@RequestParam(value="inflight") WebInFlightName inf) {
        List ret = this.inFlightCollection.getInFlightForGroupNameQuarantine(inf.toInFlightName()).stream().map(e -> new WebInFlight(e)).collect(Collectors.toList());
        return new ResponseEntity(ret, (HttpStatusCode)HttpStatus.OK);
    }

    @GetMapping(value={"/actionabledevices"})
    public ResponseEntity<List<DeviceWithActionableTasks>> getActionableDevices() {
        List ret = this.quarantineManager.getActionableDevices();
        return new ResponseEntity((Object)ret, (HttpStatusCode)HttpStatus.OK);
    }

    @InitBinder
    public void initBinder(WebDataBinder dataBinder) {
        dataBinder.registerCustomEditor(QuarantineCommand.class, (PropertyEditor)new /* Unavailable Anonymous Inner Class!! */);
        dataBinder.registerCustomEditor(QuarantinedDataSliceRequest.class, (PropertyEditor)new /* Unavailable Anonymous Inner Class!! */);
        dataBinder.registerCustomEditor(QuarantineBulkCommand.class, (PropertyEditor)new /* Unavailable Anonymous Inner Class!! */);
        dataBinder.registerCustomEditor(WebInFlightName.class, (PropertyEditor)new /* Unavailable Anonymous Inner Class!! */);
    }
}

