/*
 * Decompiled with CFR 0.152.
 */
package com.geolang.ascema.managerservice.rest;

import com.geolang.ascema.domainmodelpublic.Confidence;
import com.geolang.ascema.endpointcommon.domain.clouditems.MIPLabel;
import com.geolang.ascema.managerdomain.datapoint.Match;
import com.geolang.ascema.managerdomain.datapoint.WebConfidenceLevel;
import com.geolang.ascema.managerdomain.web.CreateCompoundPattern;
import com.geolang.ascema.managerdomain.web.CreateMipsPatternCommand;
import com.geolang.ascema.managerdomain.web.PatternIgnoreList;
import com.geolang.ascema.managerdomain.web.SetContextWordsRequest;
import com.geolang.ascema.managerdomain.web.TestRegexResponse;
import com.geolang.ascema.managerdomain.web.WebClassificationLabels;
import com.geolang.ascema.managerdomain.web.WebContextWords;
import com.geolang.ascema.managerpersistence.ClassificationLabelStore;
import com.geolang.ascema.managerservice.controllers.BuildVersion;
import com.geolang.ascema.managerservice.controllers.patterns.Pattern;
import com.geolang.ascema.managerservice.controllers.patterns.PatternGroups;
import com.geolang.ascema.managerservice.controllers.patterns.PatternService;
import com.geolang.ascema.managerservice.controllers.results.ignore.PatternIgnoreController;
import com.geolang.ascema.managerservice.controllers.tasks.TaskManager;
import com.geolang.ascema.managerservice.rest.requests.pattern.PatternGroup;
import com.geolang.ascema.managerservice.rest.requests.pattern.WebPattern;
import com.geolang.ascema.patternmatching.patterns.KeywordList;
import com.geolang.ascema.patternmatching.patterns.RegexPatternInvalidException;
import java.beans.PropertyEditor;
import java.io.IOException;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.CacheControl;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.WebDataBinder;
import org.springframework.web.bind.annotation.InitBinder;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/api/patterns"})
public class PatternsRestService {
    private static final Logger LOG = Logger.getLogger(PatternsRestService.class.getName());
    @Autowired
    private PatternService patternService;
    @Autowired
    private PatternIgnoreController ignores;
    @Autowired
    private TaskManager taskManager;
    @Autowired
    private BuildVersion buildVersion;
    @Autowired
    private ClassificationLabelStore classificationLabelStore;

    @RequestMapping(value={"/confidencelevels"})
    public ResponseEntity<List<WebConfidenceLevel>> getConfidenceLevels() {
        ArrayList<WebConfidenceLevel> ret = new ArrayList<WebConfidenceLevel>();
        for (Confidence c : Confidence.getDisplayOrder()) {
            ret.add(WebConfidenceLevel.fromConfidence((Confidence)c));
        }
        return ((ResponseEntity.BodyBuilder)((ResponseEntity.BodyBuilder)ResponseEntity.ok().cacheControl(CacheControl.maxAge((long)30L, (TimeUnit)TimeUnit.DAYS))).eTag(this.buildVersion.getIsoTime())).body(ret);
    }

    @RequestMapping(value={"/all"})
    public List<WebPattern> getPatterns() {
        List saved = this.patternService.getAllSavedPatterns();
        List all = this.patternService.getAllAvailablePatterns();
        List ret = this.sortForDisplayOrder(all, saved);
        return ret;
    }

    @RequestMapping(value={"/allcompound"})
    public List<WebPattern> getPatternsForCompound() {
        List saved = this.patternService.getAllSavedPatterns();
        List all = this.patternService.getAllAvailablePatternsForCompound();
        List ret = this.sortForDisplayOrder(all, saved);
        return ret;
    }

    @PostMapping(value={"/create/keyword"})
    public WebPattern createKeywordPattern(Principal principal, @RequestParam(value="keyword") String value, @RequestParam(value="saveName") String name) {
        String user = "unknown";
        if (principal != null) {
            user = principal.getName();
        }
        if (name == null || name.isEmpty()) {
            return this.patternService.createKeywordPattern(value);
        }
        return this.patternService.createKeywordPattern(value, name, user);
    }

    @PostMapping(value={"/create/metadata"})
    public ResponseEntity<WebPattern> createMetadataPattern(Principal principal, @RequestParam(value="key") String key, @RequestParam(value="value") String value, @RequestParam(value="saveName") String name) {
        Optional opt;
        String user = "unknown";
        if (principal != null) {
            user = principal.getName();
        }
        if ((opt = name == null || name.isEmpty() ? this.patternService.createMetadataPattern(key, value) : this.patternService.createMetadataePatternWithName(key, value, name, user)).isPresent()) {
            return new ResponseEntity((Object)((WebPattern)opt.get()), (HttpStatusCode)HttpStatus.OK);
        }
        return ResponseEntity.status((HttpStatusCode)HttpStatus.UNPROCESSABLE_ENTITY).body(null);
    }

    @PostMapping(value={"/create/mipslabel"})
    public ResponseEntity<WebPattern> createMipsLabelPattern(Principal principal, @RequestParam(value="com") CreateMipsPatternCommand com) {
        Optional opt;
        String user = "unknown";
        if (principal != null) {
            user = principal.getName();
        }
        if ((opt = com.isSave() ? this.patternService.createMipsLabelPatternWithName(com.getLabels(), com.getDisplayName(), user, com.isSave()) : this.patternService.createMipsPattern(com.getDisplayName(), com.getLabels())).isPresent()) {
            return new ResponseEntity((Object)((WebPattern)opt.get()), (HttpStatusCode)HttpStatus.OK);
        }
        return ResponseEntity.status((HttpStatusCode)HttpStatus.UNPROCESSABLE_ENTITY).body(null);
    }

    @PostMapping(value={"/create/filenamepattern"})
    public ResponseEntity<WebPattern> createFilenamePattern(Principal principal, @RequestParam(value="glob") String glob, @RequestParam(value="saveName") String name) {
        String user = "unknown";
        if (principal != null) {
            user = principal.getName();
        }
        if (name == null || name.isEmpty()) {
            Optional opt = this.patternService.createFilenamePattern(glob);
            if (opt.isPresent()) {
                return new ResponseEntity((Object)((WebPattern)opt.get()), (HttpStatusCode)HttpStatus.OK);
            }
        } else {
            Optional opt = this.patternService.createFilenamePattern(glob, name, user);
            if (opt.isPresent()) {
                return new ResponseEntity((Object)((WebPattern)opt.get()), (HttpStatusCode)HttpStatus.OK);
            }
        }
        return ResponseEntity.status((HttpStatusCode)HttpStatus.UNPROCESSABLE_ENTITY).body(null);
    }

    @PostMapping(value={"/create/keywordlist"})
    public ResponseEntity<WebPattern> createKeywordListPattern(Principal principal, @RequestParam(value="displayname") String displayname, @RequestParam(value="save") boolean save, @RequestParam(value="file") MultipartFile uploadfile) {
        try {
            Optional ret;
            String user = "unknown";
            if (principal != null) {
                user = principal.getName();
            }
            if (displayname == null || displayname.isEmpty()) {
                displayname = uploadfile.getOriginalFilename();
            }
            if (!(ret = this.patternService.createKeywordListPattern(displayname, uploadfile.getInputStream(), true, user)).isEmpty()) {
                return new ResponseEntity((Object)((WebPattern)ret.get()), (HttpStatusCode)HttpStatus.OK);
            }
            return ResponseEntity.status((HttpStatusCode)HttpStatus.UNPROCESSABLE_ENTITY).body(null);
        }
        catch (IOException ex) {
            Logger.getLogger(PatternsRestService.class.getName()).log(Level.SEVERE, null, ex);
            return ResponseEntity.status((HttpStatusCode)HttpStatus.NOT_FOUND).body(null);
        }
    }

    @PostMapping(value={"/keywordlisttwords"})
    public List<String> getKeywordListWords(@RequestParam(value="pattern") WebPattern pattern) {
        return KeywordList.getStringsFromName((String)pattern.getName());
    }

    @PostMapping(value={"/create/regex"})
    public ResponseEntity<WebPattern> createRegexPattern(Principal principal, @RequestParam(value="name") String name, @RequestParam(value="regex") String value, @RequestParam(value="save") boolean save) {
        String user = "unknown";
        if (principal != null) {
            user = principal.getName();
        }
        try {
            WebPattern ret = this.patternService.createRegexPattern(name, value, save, user);
            return new ResponseEntity((Object)ret, (HttpStatusCode)HttpStatus.OK);
        }
        catch (RegexPatternInvalidException ex) {
            LOG.log(Level.INFO, "invalid regex {0}", ex.getMessage());
            return ResponseEntity.status((HttpStatusCode)HttpStatus.UNPROCESSABLE_ENTITY).body(null);
        }
    }

    @ResponseStatus
    @PostMapping(value={"/create/testregex"})
    public ResponseEntity<TestRegexResponse> testRegexPattern(@RequestParam(value="regex") String regex, @RequestParam(value="testdata") String testdata) {
        TestRegexResponse ret = this.patternService.testRegexPattern(regex, testdata);
        return ResponseEntity.status((HttpStatusCode)HttpStatus.OK).body((Object)ret);
    }

    @PostMapping(value={"/create/similar"})
    public ResponseEntity<WebPattern> createSimilarFilePattern(Principal principal, @RequestParam(value="file") MultipartFile uploadfile, @RequestParam(value="save") boolean save, @RequestParam(value="name") String name) {
        String displayName;
        String user = "unknown";
        if (principal != null) {
            user = principal.getName();
        }
        if ((displayName = name) == null || displayName.isEmpty()) {
            LOG.warning("Save is true but displayname is empty, set save to false");
            save = false;
        }
        try {
            Optional opt = this.patternService.createSimilarFilePattern(uploadfile.getInputStream(), uploadfile.getOriginalFilename(), name, save, user);
            if (opt.isPresent()) {
                return new ResponseEntity((Object)((WebPattern)opt.get()), (HttpStatusCode)HttpStatus.OK);
            }
            return ResponseEntity.status((HttpStatusCode)HttpStatus.UNPROCESSABLE_ENTITY).body(null);
        }
        catch (IOException ex) {
            Logger.getLogger(PatternsRestService.class.getName()).log(Level.SEVERE, null, ex);
            return ResponseEntity.status((HttpStatusCode)HttpStatus.NOT_FOUND).body(null);
        }
    }

    @PostMapping(value={"/create/compound"})
    public ResponseEntity<WebPattern> createCompoundPattern(Principal principal, @RequestParam(value="com") CreateCompoundPattern com) {
        WebPattern ret = null;
        String user = "unknown";
        if (principal != null) {
            user = principal.getName();
        }
        try {
            if (com.isAnd()) {
                ret = this.patternService.createAndCompoundPattern(com.getLhs(), com.getRhs(), com.getDisplayName(), com.isSavePattern(), user);
            }
            if (com.isNand()) {
                ret = this.patternService.createNandCompoundPattern(com.getLhs(), com.getRhs(), com.getDisplayName(), com.isSavePattern(), user);
            }
            if (com.isNear()) {
                ret = this.patternService.createNearCompoundPattern(com.getLhs(), com.getRhs(), com.getDistance(), com.getDisplayName(), com.isSavePattern(), user);
            }
            if (com.isOr()) {
                ret = this.patternService.createOrCompoundPattern(com.getLhs(), com.getRhs(), com.getDisplayName(), com.isSavePattern(), user);
            }
            if (com.isNot()) {
                ret = this.patternService.createNotCompoundPattern(com.getRhs(), com.getDisplayName(), com.isSavePattern(), user);
            }
        }
        catch (PatternService.CompoundPatternExistsException ex) {
            Logger.getLogger(PatternsRestService.class.getName()).log(Level.WARNING, null, ex);
            return ResponseEntity.status((HttpStatusCode)HttpStatus.CONFLICT).body(null);
        }
        catch (PatternService.CompoundPatternInvalidException ex) {
            Logger.getLogger(PatternsRestService.class.getName()).log(Level.WARNING, null, ex);
            return ResponseEntity.status((HttpStatusCode)HttpStatus.NOT_ACCEPTABLE).body(null);
        }
        if (ret == null) {
            return ResponseEntity.status((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR).body(null);
        }
        return new ResponseEntity((Object)ret, (HttpStatusCode)HttpStatus.OK);
    }

    @PostMapping(value={"/exists/saved"})
    public Boolean checkSavedExists(@RequestParam(value="com") String value) {
        return this.patternService.savedPatternNameExists(value);
    }

    @PostMapping(value={"/delete/saved"})
    public boolean deleteSaved(Principal principal, @RequestParam(value="com") String name) {
        String user = "unknown";
        if (principal != null) {
            user = principal.getName();
        }
        this.ignores.removeAllIgnoresForPattern(user, name);
        return this.patternService.deletePattern(name, user);
    }

    @RequestMapping(value={"/tags"})
    public List<String> getTags() {
        return this.patternService.getTags();
    }

    @RequestMapping(value={"/groups"})
    public List<PatternGroup> getGroups() {
        return PatternGroups.getAvailable((PatternService)this.patternService);
    }

    @RequestMapping(value={"/ignores"})
    public List<PatternIgnoreList> getAllIgnores() {
        ArrayList<PatternIgnoreList> ret = new ArrayList<PatternIgnoreList>();
        Map all = this.ignores.getAll();
        for (Map.Entry entry : all.entrySet()) {
            ret.add(new PatternIgnoreList((String)entry.getKey(), (List)entry.getValue()));
        }
        return ret;
    }

    @RequestMapping(value={"/ignores/{name}"})
    public PatternIgnoreList getIgnoresForPattern(@PathVariable(value="name") String name) {
        List igs = this.ignores.listIgnoresForPattern(name);
        return new PatternIgnoreList(name, igs);
    }

    @PostMapping(value={"/addignore"})
    public boolean addIgnoreToPattern(Principal principal, @RequestParam(value="pattern") String pattern, @RequestParam(value="ignore") String ignore) {
        String user = "unknown";
        if (principal != null) {
            user = principal.getName();
        }
        return this.ignores.addIgnoreToPattern(user, pattern, ignore);
    }

    @PostMapping(value={"/addmultipleignores"})
    public boolean addIgnoresToPattern(Principal principal, @RequestParam(value="patList") PatternIgnoreList pat) {
        String user = "unknown";
        if (principal != null) {
            user = principal.getName();
        }
        return this.ignores.addIgnoresToPattern(user, pat.getPatternDisplayName(), pat.getIgnores());
    }

    @PostMapping(value={"/addmultipleignoresfile"})
    public boolean addIgnoresToPatternFromFile(Principal principal, @RequestParam(value="pattern") String pattern, @RequestParam(value="file") MultipartFile uploadfile) {
        String user = "unknown";
        if (principal != null) {
            user = principal.getName();
        }
        try {
            return this.ignores.addIgnoresToPatternFromFile(user, pattern, uploadfile.getInputStream());
        }
        catch (IOException ex) {
            Logger.getLogger(PatternsRestService.class.getName()).log(Level.SEVERE, null, ex);
            return false;
        }
    }

    @PostMapping(value={"/removeignore"})
    public boolean removeIgnoreFromPattern(Principal principal, @RequestParam(value="pattern") String pattern, @RequestParam(value="ignore") String ignore) {
        String user = "unknown";
        if (principal != null) {
            user = principal.getName();
        }
        return this.ignores.removeIgnoreFromPattern(user, pattern, ignore);
    }

    @PostMapping(value={"/removemultipleignore"})
    public boolean removeMultipleIgnoreFromPattern(Principal principal, @RequestParam(value="patList") PatternIgnoreList pat) {
        String user = "unknown";
        if (principal != null) {
            user = principal.getName();
        }
        return this.ignores.removeIgnoresFromPattern(user, pat.getPatternDisplayName(), pat.getIgnores());
    }

    @PostMapping(value={"/removeallignores"})
    public boolean removeIgnoreFromPattern(Principal principal, @RequestParam(value="pattern") String pattern) {
        String user = "unknown";
        if (principal != null) {
            user = principal.getName();
        }
        return this.ignores.removeAllIgnoresForPattern(user, pattern);
    }

    @PostMapping(value={"/ignoredatapoint"})
    boolean ignore(Principal principal, @RequestParam(value="patternDisplayName") String patternDisplayName, @RequestParam(value="matchingText") String matchingText, @RequestParam(value="deviceId") String deviceId) {
        String name = "unknown";
        if (principal != null) {
            name = principal.getName();
        }
        this.ignores.ignoreDataPoint(name, patternDisplayName, matchingText, deviceId);
        return true;
    }

    @PostMapping(value={"/unignoredatapoint"})
    boolean unignore(Principal principal, @RequestParam(value="patternDisplayName") String patternDisplayName, @RequestParam(value="matchingText") String matchingText, @RequestParam(value="deviceId") String deviceId) {
        String name = "unknown";
        if (principal != null) {
            name = principal.getName();
        }
        this.ignores.unIgnoreDataPoint(name, patternDisplayName, matchingText, deviceId);
        return true;
    }

    @PostMapping(value={"/listcontextwords"})
    public WebContextWords getContextWords(@RequestParam(value="pattern") WebPattern pattern) {
        Set words = this.patternService.getContextWords(pattern.getDisplayName());
        if (words.isEmpty()) {
            return new WebContextWords(pattern.getDisplayName(), pattern.getDefaultContextWords(), true);
        }
        return new WebContextWords(pattern.getDisplayName(), words, false);
    }

    @PostMapping(value={"/revertcontextwords"})
    public WebContextWords revertContextWords(@RequestParam(value="pattern") WebPattern pattern) {
        this.patternService.revertContextWords(pattern.getDisplayName());
        return new WebContextWords(pattern.getDisplayName(), pattern.getDefaultContextWords(), true);
    }

    @PostMapping(value={"/setcontextwords"})
    public WebContextWords setContextWords(@RequestParam(value="req") SetContextWordsRequest req) {
        this.patternService.setContextWords(req.getPatternDisplayName(), req.getWords());
        this.taskManager.updateContextWordsOnTasks(req.getPatternDisplayName(), req.getWords());
        return new WebContextWords(req.getPatternDisplayName(), req.getWords(), false);
    }

    @PostMapping(value={"/listclassificationlabels"})
    public WebClassificationLabels getClassificationLabels(@RequestParam(value="pattern") WebPattern pattern) {
        Set words = this.classificationLabelStore.getForPattern(pattern.getDisplayName());
        if (words.isEmpty()) {
            return new WebClassificationLabels(pattern.getDisplayName(), pattern.getClassificationLabels(), true);
        }
        return new WebClassificationLabels(pattern.getDisplayName(), words, false);
    }

    @PostMapping(value={"/revertclassificationlabels"})
    public WebClassificationLabels revertClassificationLabels(@RequestParam(value="pattern") WebPattern pattern) {
        Set words = this.classificationLabelStore.revertToDefault(pattern.getDisplayName(), pattern.getName());
        return new WebClassificationLabels(pattern.getDisplayName(), words, true);
    }

    @PostMapping(value={"/setclassificationlabels"})
    public WebClassificationLabels setClassificationLabels(@RequestParam(value="req") SetContextWordsRequest req) {
        this.classificationLabelStore.setForPattern(req.getPatternDisplayName(), req.getWords());
        this.taskManager.updateClassificationLabelsOnTasks(req.getPatternDisplayName(), req.getWords());
        return new WebClassificationLabels(req.getPatternDisplayName(), req.getWords(), false);
    }

    private List<WebPattern> sortForDisplayOrder(List<WebPattern> in, List<WebPattern> saved) {
        LinkedList<WebPattern> ret = new LinkedList<WebPattern>();
        ArrayList<WebPattern> global = new ArrayList<WebPattern>();
        ArrayList<WebPattern> uk = new ArrayList<WebPattern>();
        ArrayList<WebPattern> us = new ArrayList<WebPattern>();
        ArrayList<WebPattern> crypto = new ArrayList<WebPattern>();
        ArrayList<WebPattern> tradeNumbers = new ArrayList<WebPattern>();
        ArrayList<WebPattern> icdCodes = new ArrayList<WebPattern>();
        ArrayList<WebPattern> credentials = new ArrayList<WebPattern>();
        TreeMap otherCountries = new TreeMap();
        for (WebPattern wp : in) {
            String group = wp.getGroup();
            if (group.equals(Pattern.GLOBAL_PATTERN_GROUP_NAME)) {
                global.add(wp);
                continue;
            }
            if (group.equals("United Kingdom")) {
                uk.add(wp);
                continue;
            }
            if (group.equals("United States")) {
                us.add(wp);
                continue;
            }
            if (group.equals(Pattern.CRYPTO_PATTERN_GROUP_NAME)) {
                crypto.add(wp);
                continue;
            }
            if (group.equals(Pattern.ICD_PATTERN_GROUP_NAME)) {
                icdCodes.add(wp);
                continue;
            }
            if (group.equals(Pattern.GTIN_PATTERN_GROUP_NAME)) {
                tradeNumbers.add(wp);
                continue;
            }
            if (group.equals(Pattern.CREDENTIALS_PATTERN_GROUP_NAME)) {
                credentials.add(wp);
                continue;
            }
            if (!otherCountries.containsKey(group)) {
                otherCountries.put(group, new ArrayList());
            }
            ((List)otherCountries.get(group)).add(wp);
        }
        Collections.sort(global, (a, b) -> a.getDisplayName().compareTo(b.getDisplayName()));
        ret.addAll(global);
        Collections.sort(uk, (a, b) -> a.getDisplayName().compareTo(b.getDisplayName()));
        ret.addAll(uk);
        Collections.sort(us, (a, b) -> a.getDisplayName().compareTo(b.getDisplayName()));
        ret.addAll(us);
        Collections.sort(credentials, (a, b) -> a.getDisplayName().compareTo(b.getDisplayName()));
        ret.addAll(credentials);
        for (List other : otherCountries.values()) {
            Collections.sort(other, (a, b) -> a.getDisplayName().compareTo(b.getDisplayName()));
            ret.addAll(other);
        }
        Collections.sort(tradeNumbers, (a, b) -> a.getDisplayName().compareTo(b.getDisplayName()));
        ret.addAll(tradeNumbers);
        Collections.sort(crypto, (a, b) -> a.getDisplayName().compareTo(b.getDisplayName()));
        ret.addAll(crypto);
        Collections.sort(icdCodes, (a, b) -> a.getDisplayName().compareTo(b.getDisplayName()));
        ret.addAll(icdCodes);
        Collections.sort(saved, (a, b) -> a.getDisplayName().compareTo(b.getDisplayName()));
        ret.addAll(saved);
        return ret;
    }

    @InitBinder
    public void initBinder(WebDataBinder dataBinder) {
        dataBinder.registerCustomEditor(CreateCompoundPattern.class, (PropertyEditor)new /* Unavailable Anonymous Inner Class!! */);
        dataBinder.registerCustomEditor(MIPLabel.class, (PropertyEditor)new /* Unavailable Anonymous Inner Class!! */);
        dataBinder.registerCustomEditor(PatternIgnoreList.class, (PropertyEditor)new /* Unavailable Anonymous Inner Class!! */);
        dataBinder.registerCustomEditor(Match.class, (PropertyEditor)new /* Unavailable Anonymous Inner Class!! */);
        dataBinder.registerCustomEditor(WebContextWords.class, (PropertyEditor)new /* Unavailable Anonymous Inner Class!! */);
        dataBinder.registerCustomEditor(WebClassificationLabels.class, (PropertyEditor)new /* Unavailable Anonymous Inner Class!! */);
        dataBinder.registerCustomEditor(WebPattern.class, (PropertyEditor)new /* Unavailable Anonymous Inner Class!! */);
        dataBinder.registerCustomEditor(SetContextWordsRequest.class, (PropertyEditor)new /* Unavailable Anonymous Inner Class!! */);
        dataBinder.registerCustomEditor(CreateMipsPatternCommand.class, (PropertyEditor)new /* Unavailable Anonymous Inner Class!! */);
    }
}

