/*
 * Decompiled with CFR 0.152.
 */
package com.geolang.ascema.managerservice.rest;

import com.geolang.ascema.endpointcommon.domain.actions.ActionIgnorePaths;
import com.geolang.ascema.endpointcommon.domain.actions.HostAndPath;
import com.geolang.ascema.managerdomain.domain.PathCollection;
import com.geolang.ascema.managerdomain.domain.SearchResultStored;
import com.geolang.ascema.managerdomain.domain.TaskTemplate;
import com.geolang.ascema.managerdomain.web.WebHostAndPath;
import com.geolang.ascema.managerdomain.web.WebPathCollection;
import com.geolang.ascema.managerpersistence.TaskStore;
import com.geolang.ascema.managerservice.controllers.PathCollectionController;
import com.geolang.ascema.managerservice.controllers.results.ResultsManager;
import com.google.gson.Gson;
import java.beans.PropertyEditor;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.WebDataBinder;
import org.springframework.web.bind.annotation.InitBinder;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/pathcollection"})
public class PathCollectionRestService {
    private static final Logger LOG = Logger.getLogger(PathCollectionRestService.class.getName());
    @Autowired
    private PathCollectionController controller;
    @Autowired
    private TaskStore taskStore;
    @Autowired
    private ResultsManager resultsManager;
    private Gson gson = new Gson();

    @PostMapping(value={"/iscontained"})
    public final boolean alreadyContained(@RequestParam(value="path") String whpAsString, @RequestParam(value="paths") WebHostAndPath[] paths) {
        WebHostAndPath whp = (WebHostAndPath)this.gson.fromJson(whpAsString, WebHostAndPath.class);
        HostAndPath hp = new HostAndPath(whp.getHost(), whp.getPath());
        ActionIgnorePaths aip = new ActionIgnorePaths();
        for (WebHostAndPath s : paths) {
            aip.add(new HostAndPath(s.getHost(), s.getPath()));
        }
        return aip.alreadyContained(hp);
    }

    @PostMapping(value={"/havecontained"})
    public final boolean haveContained(@RequestParam(value="path") String whpAsString, @RequestParam(value="paths") WebHostAndPath[] paths) {
        WebHostAndPath whp = (WebHostAndPath)this.gson.fromJson(whpAsString, WebHostAndPath.class);
        ActionIgnorePaths aip = new ActionIgnorePaths();
        HostAndPath hp = new HostAndPath(whp.getHost(), whp.getPath());
        for (WebHostAndPath s : paths) {
            aip.add(new HostAndPath(s.getHost(), s.getPath()));
        }
        return aip.haveContainedBy(hp);
    }

    @PostMapping(value={"/lookup"})
    public final Set<HostAndPath> lookup(@RequestParam(value="id") String id) {
        HashSet<HostAndPath> ret = new HashSet<HostAndPath>();
        for (SearchResultStored srs : this.resultsManager.getResultsForActionableId(id)) {
            ret.add(new HostAndPath(srs.getDeviceName(), srs.getFilePath()));
        }
        return ret;
    }

    @PostMapping(value={"/insertpath"})
    public final Set<HostAndPath> insertPath(@RequestParam(value="path") String whpAsString, @RequestParam(value="paths") WebHostAndPath[] paths) {
        TreeSet ordered = new TreeSet();
        ordered.addAll(Arrays.asList(paths).stream().map(a -> new HostAndPath(a.getHost(), a.getPath())).collect(Collectors.toList()));
        ActionIgnorePaths aip = new ActionIgnorePaths(ordered);
        WebHostAndPath whp = (WebHostAndPath)this.gson.fromJson(whpAsString, WebHostAndPath.class);
        HostAndPath hp = new HostAndPath(whp.getHost(), whp.getPath());
        aip.addRemovingContainedBy(hp);
        return aip.getPaths();
    }

    @PostMapping(value={"/delete"})
    public boolean delete(@RequestParam(value="name") String name) {
        this.controller.deleteByName(name);
        return true;
    }

    @PostMapping(value={"/exists"})
    public boolean exists(@RequestParam(value="name") String name) {
        return this.controller.existsByName(name);
    }

    @RequestMapping(value={"/getall"})
    public List<WebPathCollection> getAll() {
        ArrayList<WebPathCollection> ret = new ArrayList<WebPathCollection>();
        for (PathCollection stored : this.controller.getAllLists()) {
            ret.add(new WebPathCollection(stored, this.isInUse(stored.getDisplayName())));
        }
        Collections.sort(ret);
        return ret;
    }

    @PostMapping(value={"/getbyname"})
    public ResponseEntity<WebPathCollection> getByName(@RequestParam(value="name") String name) {
        Optional opt = this.controller.getByName(name);
        if (opt.isEmpty()) {
            return ResponseEntity.status((HttpStatusCode)HttpStatus.NOT_FOUND).body(null);
        }
        return new ResponseEntity((Object)new WebPathCollection((PathCollection)opt.get(), this.isInUse(name)), (HttpStatusCode)HttpStatus.OK);
    }

    private boolean isInUse(String name) {
        for (TaskTemplate tt : this.taskStore.getAllNonEphemeralTemplates()) {
            if (tt.getActionIgnorePathsName() == null || !tt.getActionIgnorePathsName().equals(name)) continue;
            return true;
        }
        return false;
    }

    @PostMapping(value={"/save"})
    public WebPathCollection saveOrUpdate(Principal principal, @RequestParam(value="name") String displayname, @RequestParam(value="paths") WebHostAndPath[] paths) {
        String name = "unknown";
        if (principal != null) {
            name = principal.getName();
        }
        if (displayname == null || displayname.isEmpty()) {
            LOG.warning("Empty display name in create path collection");
            return null;
        }
        ActionIgnorePaths aip = new ActionIgnorePaths();
        for (WebHostAndPath whp : paths) {
            HostAndPath s = new HostAndPath(whp.getHost(), whp.getPath());
            if (aip.alreadyContained(s)) continue;
            aip.addRemovingContainedBy(s);
        }
        LOG.log(Level.INFO, "path collection {0} created by {1}", new Object[]{displayname, name});
        return new WebPathCollection(this.controller.createOrUpdate(displayname, name, aip.getPaths()), this.isInUse(displayname));
    }

    @InitBinder
    public void initBinder(WebDataBinder dataBinder) {
        dataBinder.registerCustomEditor(WebPathCollection.class, (PropertyEditor)new /* Unavailable Anonymous Inner Class!! */);
        dataBinder.registerCustomEditor(WebHostAndPath[].class, (PropertyEditor)new /* Unavailable Anonymous Inner Class!! */);
    }
}

