/*
 * Decompiled with CFR 0.152.
 */
package com.geolang.ascema.managerservice.rest;

import com.geolang.ascema.endpointcommon.domain.DeviceType;
import com.geolang.ascema.indexingcommon.endpoint.cloudcommon.CloudGroup;
import com.geolang.ascema.indexingcommon.endpoint.cloudcommon.CloudUser;
import com.geolang.ascema.managercore.MessageBus;
import com.geolang.ascema.managerevents.CloudUsersAndGroupsEvent;
import com.geolang.ascema.managerpersistence.CloudUserMappingStore;
import com.geolang.ascema.managerservice.controllers.devices.DeviceService;
import com.geolang.ascema.managerservice.license.LicenseManager;
import com.geolang.ascema.managerservice.rest.CompletableManager;
import com.geolang.ascema.managerservice.rest.requests.o365.CloudUsersAndGroups;
import com.geolang.ascema.managerservice.rest.security.O365LicenseFilter;
import com.google.common.eventbus.Subscribe;
import jakarta.annotation.PostConstruct;
import jakarta.annotation.PreDestroy;
import jakarta.servlet.Filter;
import java.beans.PropertyEditor;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.scheduling.annotation.Async;
import org.springframework.web.bind.WebDataBinder;
import org.springframework.web.bind.annotation.InitBinder;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/o365"})
public class O365RestService {
    private static final List<CompletableFuture<CloudUsersAndGroups>> waitingForUsers = new ArrayList();
    CloudUsersAndGroups usersAndGroups = null;
    @Autowired
    private DeviceService endpointController;
    @Autowired
    private CloudUserMappingStore mappingStore;
    @Autowired
    private LicenseManager licenseMgr;
    @Autowired
    private CompletableManager completeMgr;

    @Bean
    public FilterRegistrationBean<O365LicenseFilter> licenseFilterO365() {
        FilterRegistrationBean registrationBean = new FilterRegistrationBean();
        registrationBean.setFilter((Filter)new O365LicenseFilter(this.licenseMgr));
        registrationBean.addUrlPatterns(new String[]{"/api/o365/*"});
        return registrationBean;
    }

    @PostConstruct
    public void afterPropertiesSet() throws Exception {
        MessageBus.getBus().register((Object)this);
    }

    @PreDestroy
    public void destroy() throws Exception {
        MessageBus.getBus().unregister((Object)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Subscribe
    public void handleAvailableUsers(CloudUsersAndGroupsEvent ev) {
        if (ev.getDeviceType().equals((Object)DeviceType.O365)) {
            List list = waitingForUsers;
            synchronized (list) {
                this.usersAndGroups = new CloudUsersAndGroups(new HashSet(ev.getUsers()), new HashSet(ev.getGroups()), ev.getDeviceType());
                for (CompletableFuture cf : waitingForUsers) {
                    cf.complete(this.usersAndGroups);
                }
                waitingForUsers.clear();
            }
        }
    }

    @RequestMapping(value={"/getusers"})
    public boolean getUsers() {
        this.endpointController.getCloudUsers(DeviceType.O365);
        return true;
    }

    @RequestMapping(value={"/getuserfromid/{userid}"})
    public String getUserNameFromId(@PathVariable(value="userid") String userId) {
        Optional opt = this.mappingStore.getEmailForUUID(userId);
        if (opt.isPresent()) {
            String email = ((CloudUserMappingStore.PossibleEmail)opt.get()).email();
            return email;
        }
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Async
    @RequestMapping(value={"/userswait"})
    public CompletableFuture<CloudUsersAndGroups> getUsersAsync() throws InterruptedException {
        CompletableFuture<CloudUsersAndGroups> f = new CompletableFuture<CloudUsersAndGroups>();
        List list = waitingForUsers;
        synchronized (list) {
            if (this.usersAndGroups != null) {
                f.complete(this.usersAndGroups);
                this.usersAndGroups = null;
            } else {
                waitingForUsers.add(f);
            }
        }
        return f;
    }

    @InitBinder
    public void initBinder(WebDataBinder dataBinder) {
        dataBinder.registerCustomEditor(CloudUser.class, (PropertyEditor)new /* Unavailable Anonymous Inner Class!! */);
        dataBinder.registerCustomEditor(CloudGroup.class, (PropertyEditor)new /* Unavailable Anonymous Inner Class!! */);
    }
}

