/*
 * Decompiled with CFR 0.152.
 */
package com.geolang.ascema.managerservice.rest;

import com.geolang.ascema.managerservice.rest.TimedCompletableFuture;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.CompletableFuture;

public class NamedCompletableCollection<K, V> {
    private final Map<K, TimedCompletableFuture<V>> futures = Collections.synchronizedMap(new HashMap());

    public synchronized boolean completeIfContains(K key, V value) {
        boolean ret = false;
        if (this.futures.containsKey(key)) {
            ((TimedCompletableFuture)this.futures.get(key)).getFuture().complete(value);
            this.futures.remove(key);
            ret = true;
        }
        return ret;
    }

    synchronized void checkExpired() {
        Iterator entries = this.futures.entrySet().iterator();
        while (entries.hasNext()) {
            Map.Entry entry = entries.next();
            if (!((TimedCompletableFuture)entry.getValue()).expired()) continue;
            ((TimedCompletableFuture)entry.getValue()).getFuture().complete(null);
            entries.remove();
        }
    }

    synchronized void put(K key, CompletableFuture<V> cf, int i) {
        this.futures.put(key, new TimedCompletableFuture(cf, i));
    }

    synchronized CompletableFuture<V> putOrUpdate(K key, int i) {
        if (this.futures.containsKey(key)) {
            TimedCompletableFuture ret = (TimedCompletableFuture)this.futures.get(key);
            ret.resetTimeout(i);
            return ret.getFuture();
        }
        TimedCompletableFuture ret = new TimedCompletableFuture(new CompletableFuture(), i);
        this.futures.put(key, ret);
        return ret.getFuture();
    }
}

