/*
 * Decompiled with CFR 0.152.
 */
package com.geolang.ascema.managerservice.rest;

import com.geolang.ascema.license.ReadonlyAscemaLicense;
import com.geolang.ascema.managercore.settings.SettingsFile;
import com.geolang.ascema.managerdomain.domain.LicenseAllocation;
import com.geolang.ascema.managerdomain.web.LicenseDetails;
import com.geolang.ascema.managerdomain.web.WebSecondaryConfig;
import com.geolang.ascema.managerservice.license.LicenseManager;
import com.geolang.ascema.managerservice.license.LicenseProblemException;
import com.geolang.ascema.managerservice.messaging.serverserver.MasterEnd;
import jakarta.servlet.http.HttpServletResponse;
import java.beans.PropertyEditor;
import java.io.IOException;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.WebDataBinder;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.InitBinder;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/api/admin/license"})
public class LicenseRestService {
    private static final Logger LOG = Logger.getLogger(LicenseRestService.class.getName());
    @Autowired
    private LicenseManager manager;
    @Autowired
    private MasterEnd master;

    @PostMapping(value={"/asstring"})
    public boolean uploadLicenseAsString(@RequestParam(value="license") String text) {
        try {
            return this.manager.setLicense(text);
        }
        catch (LicenseProblemException ex) {
            Logger.getLogger(LicenseRestService.class.getName()).log(Level.SEVERE, null, ex);
            return false;
        }
    }

    @PostMapping(value={"/asfile"})
    public boolean uploadLicenseAsFile(@RequestParam(value="file") MultipartFile file) {
        try {
            byte[] bytes = file.getBytes();
            String s = new String(bytes, "UTF-8");
            return this.manager.setLicense(s);
        }
        catch (LicenseProblemException | IOException ex) {
            Logger.getLogger(LicenseRestService.class.getName()).log(Level.SEVERE, null, ex);
            return false;
        }
    }

    @GetMapping(value={"/license"})
    public ResponseEntity<LicenseDetails> getLicense() {
        ReadonlyAscemaLicense lic = this.manager.getLicense();
        if (lic == null) {
            return ResponseEntity.status((HttpStatusCode)HttpStatus.NO_CONTENT).body(null);
        }
        return ResponseEntity.status((HttpStatusCode)HttpStatus.OK).body((Object)new LicenseDetails(lic));
    }

    @GetMapping(value={"/getmaxendpointagents"})
    public int getMaxEndpointAgents(HttpServletResponse response) {
        return this.manager.getMaxEndpointAgents();
    }

    @GetMapping(value={"/getmaxfileservers"})
    public int getMaxFileServers(HttpServletResponse response) {
        return this.manager.getMaxFileservers();
    }

    @GetMapping(value={"/getmaxalfresco"})
    public int getMaxAlfresco(HttpServletResponse response) {
        return this.manager.getMaxAlfrescoAgents();
    }

    @GetMapping(value={"/getmaxo365"})
    public int getMaxO365(HttpServletResponse response) {
        return this.manager.getMaxO365Agents();
    }

    @GetMapping(value={"/getmaxgoogle"})
    public int getMaxGoogle(HttpServletResponse response) {
        return this.manager.getMaxGoogleAgents();
    }

    @GetMapping(value={"/getmaxatlassian"})
    public int getMaxAtlassian(HttpServletResponse response) {
        return this.manager.getMaxAtlassianAgents();
    }

    @GetMapping(value={"/getmaxsecondarymanagers"})
    public int getMaxSecondaryManagers(HttpServletResponse response) {
        return this.manager.getMaxSecondaryManagers();
    }

    @GetMapping(value={"/alfrescoenabled"})
    public boolean getAlfrescoEnabled(HttpServletResponse response) {
        return this.manager.getMaxAlfrescoAgents() > 0;
    }

    @GetMapping(value={"/o365enabled"})
    public boolean getO365Enabled(HttpServletResponse response) {
        return this.manager.getMaxO365Agents() > 0;
    }

    @GetMapping(value={"/googleenabled"})
    public boolean getGoogleEnabled(HttpServletResponse response) {
        return this.manager.getMaxGoogleAgents() > 0;
    }

    @GetMapping(value={"/fileserverenabled"})
    public boolean getFileserverEnabled(HttpServletResponse response) {
        return this.manager.getMaxFileservers() > 0;
    }

    @GetMapping(value={"/atlassianenabled"})
    public boolean getAtlassianEnabled(HttpServletResponse response) {
        return this.manager.getMaxAtlassianAgents() > 0;
    }

    @GetMapping(value={"/expired"})
    public boolean getExpired(HttpServletResponse response) {
        response.setHeader("Cache-Control", "max-age=5");
        return this.manager.isExpired();
    }

    @GetMapping(value={"/exists"})
    public boolean getExists(HttpServletResponse response) {
        return this.manager.isLicenseExists();
    }

    @PostMapping(value={"/setallocations"})
    public boolean setAllocations(@RequestParam(value="allocation") WebSecondaryConfig msg) {
        LOG.log(Level.INFO, "Set allocation for {0}", msg);
        if (this.master.isRunning()) {
            LicenseAllocation alloc = new LicenseAllocation(msg.getNumEndpoints(), msg.getNumFileservers(), msg.getNumAlfresco(), msg.getNumO365(), msg.getNumAtlassian(), msg.getNumGoogle(), this.manager.getExpireDate());
            this.master.allocateLicense(msg.getUuid(), alloc);
            return true;
        }
        return false;
    }

    @GetMapping(value={"/getallocations/{slavename}"})
    public WebSecondaryConfig getAllocation(@PathVariable(value="slavename") String slavename) {
        if (this.master.isRunning()) {
            return this.master.getAttachedSlave(slavename);
        }
        String name = SettingsFile.getInstance().getManagerName();
        String uuid = SettingsFile.getInstance().getUUID();
        if (slavename.isEmpty() || slavename.equals(name)) {
            LicenseAllocation lic = this.manager.getAllocatedLicense();
            if (lic != null) {
                return new WebSecondaryConfig(uuid, slavename, lic.getNumEndpoints(), lic.getNumFileservers(), lic.getNumAlfresco(), lic.getNumO365(), lic.getNumAtlassian(), lic.getNumGoogle(), lic.getMasterLicenseExpires());
            }
            return new WebSecondaryConfig(uuid, slavename, 0, 0, 0, 0, 0, 0, new Date());
        }
        return null;
    }

    @InitBinder
    public void initBinder(WebDataBinder dataBinder) {
        dataBinder.registerCustomEditor(WebSecondaryConfig.class, (PropertyEditor)new /* Unavailable Anonymous Inner Class!! */);
    }
}

