/*
 * Decompiled with CFR 0.152.
 */
package com.geolang.ascema.managerservice.rest;

import com.geolang.ascema.endpointcommon.domain.BaseCommand;
import com.geolang.ascema.endpointcommon.domain.KnowledgeBaseSearchCommand;
import com.geolang.ascema.endpointcommon.domain.searchconfig.UnifiedSearchConfiguration;
import com.geolang.ascema.knowledgebase.controllers.KnowledgeBaseResponse;
import com.geolang.ascema.knowledgebase.filters.DateFilter;
import com.geolang.ascema.managerdomain.domain.JobDeviceState;
import com.geolang.ascema.managerdomain.domain.TaskInstance;
import com.geolang.ascema.managerdomain.domain.TaskTemplate;
import com.geolang.ascema.managerdomain.web.RunCommand;
import com.geolang.ascema.managerdomain.web.SearchStateSummaryCollection;
import com.geolang.ascema.managerdomain.web.SmallDetails;
import com.geolang.ascema.managerdomain.web.WebSchedule;
import com.geolang.ascema.managerpersistence.ClassificationLabelStore;
import com.geolang.ascema.managerpersistence.ContextWordStore;
import com.geolang.ascema.managerpersistence.FileExtensionStore;
import com.geolang.ascema.managerservice.controllers.KnowledgeBaseController;
import com.geolang.ascema.managerservice.controllers.SchedulingService;
import com.geolang.ascema.managerservice.controllers.devices.DeviceService;
import com.geolang.ascema.managerservice.controllers.patterns.PatternService;
import com.geolang.ascema.managerservice.controllers.tasks.JobRunner;
import com.geolang.ascema.managerservice.controllers.tasks.TaskManager;
import com.geolang.ascema.managerservice.license.LicenseManager;
import com.geolang.ascema.managerservice.rest.requests.tasks.KnowledgeBaseLookup;
import com.geolang.ascema.managerservice.rest.requests.tasks.KnowledgeBaseSearchJobInstance;
import com.geolang.ascema.managerservice.rest.requests.tasks.KnowledgeBaseSearchJobTemplate;
import java.beans.PropertyEditor;
import java.security.Principal;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.web.bind.WebDataBinder;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.InitBinder;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/knowledgebase"})
public class KnowledgeBaseRestService {
    private static final System.Logger LOG = System.getLogger(KnowledgeBaseRestService.class.getName());
    @Autowired
    private JobRunner jobRunner;
    @Autowired
    private ContextWordStore contextWords;
    @Autowired
    private ClassificationLabelStore classificationLabelsStore;
    @Autowired
    private FileExtensionStore fileExtManager;
    @Autowired
    private LicenseManager licenseManager;
    @Autowired
    private DeviceService endpointController;
    @Autowired
    private SchedulingService scheduler;
    @Autowired
    private PatternService patternService;
    @Autowired
    private TaskManager taskManager;
    @Autowired
    private KnowledgeBaseController controller;

    @PostMapping(value={"/lookup"})
    public List<KnowledgeBaseResponse> lookup(@RequestBody KnowledgeBaseLookup s) {
        Authentication auth = SecurityContextHolder.getContext().getAuthentication();
        DateFilter filter = new DateFilter();
        if (s.getDateFilters() != null) {
            filter.setEndCreateDate(s.getDateFilters().getEndCreateDate());
            filter.setEndModifyDate(s.getDateFilters().getEndModifyDate());
            filter.setStartCreateDate(s.getDateFilters().getStartCreateDate());
            filter.setStartModifyDate(s.getDateFilters().getStartModifyDate());
        }
        return this.controller.getMatchingDocuments(auth, s.getTaskName(), s.getQuery(), s.getNumResults(), filter);
    }

    @RequestMapping(value={"/templates"})
    List<KnowledgeBaseSearchJobTemplate> getAllTemplates() {
        Authentication auth = SecurityContextHolder.getContext().getAuthentication();
        return this.controller.getAllTemplates(auth);
    }

    @RequestMapping(value={"/instances/{searchJobTemplateId}"})
    List<KnowledgeBaseSearchJobInstance> getAllInstancesForTemplate(@PathVariable(value="searchJobTemplateId") String searchJobTemplateId) {
        ArrayList<KnowledgeBaseSearchJobInstance> ret = new ArrayList<KnowledgeBaseSearchJobInstance>();
        List jps = this.taskManager.getAllInstancesForTemplate(searchJobTemplateId);
        for (TaskInstance jp : jps) {
            KnowledgeBaseSearchJobInstance sjt = new KnowledgeBaseSearchJobInstance(jp, this.endpointController, this.patternService);
            ret.add(sjt);
        }
        return ret;
    }

    @PostMapping(value={"/template/add"})
    public ResponseEntity<KnowledgeBaseSearchJobTemplate> add(Principal principal, @RequestBody KnowledgeBaseSearchJobTemplate s) {
        if (this.licenseManager.isExpired()) {
            LOG.log(System.Logger.Level.WARNING, "License expired - not creating search");
            return ResponseEntity.status((HttpStatusCode)HttpStatus.NOT_ACCEPTABLE).body(null);
        }
        String name = "unknown";
        if (principal != null) {
            name = principal.getName();
        }
        if (this.taskManager.templateExists(s.getName())) {
            return ResponseEntity.status((HttpStatusCode)HttpStatus.CONFLICT).body(null);
        }
        if (!TaskManager.isValidTemplateName((String)s.getName())) {
            return ResponseEntity.status((HttpStatusCode)HttpStatus.NOT_ACCEPTABLE).body(null);
        }
        UnifiedSearchConfiguration config = s.toConfig(this.fileExtManager, this.contextWords, this.classificationLabelsStore);
        KnowledgeBaseSearchCommand command = new KnowledgeBaseSearchCommand(config, s.isIsPublic());
        KnowledgeBaseSearchJobTemplate t = new KnowledgeBaseSearchJobTemplate(s.isIsPublic(), this.taskManager.addTemplate(name, (BaseCommand)command, s.getName(), s.getPriority(), false, ""), this.scheduler, this.patternService, null);
        return new ResponseEntity((Object)t, (HttpStatusCode)HttpStatus.OK);
    }

    @RequestMapping(value={"/template/{id}"})
    KnowledgeBaseSearchJobTemplate getTemplate(@PathVariable(value="id") String templateId) {
        Authentication auth = SecurityContextHolder.getContext().getAuthentication();
        return this.controller.getTemplate(auth, templateId);
    }

    @RequestMapping(value={"/templatepublic/{id}/{set}"})
    boolean setTemplatePublic(@PathVariable(value="id") String templateId, @PathVariable(value="set") boolean toset) {
        Authentication auth = SecurityContextHolder.getContext().getAuthentication();
        return this.controller.setTemplatePublic(templateId, toset);
    }

    @DeleteMapping(value={"/template/{searchJobTemplateId}"})
    public boolean deleteTemplate(Principal principal, @PathVariable(value="searchJobTemplateId") String searchJobTemplateId) {
        String name = "unknown";
        if (principal != null) {
            name = principal.getName();
        }
        return this.controller.deleteModel(name, searchJobTemplateId);
    }

    @DeleteMapping(value={"/instance/{id}"})
    public boolean deleteInstance(Principal principal, @PathVariable(value="id") String instanceId) {
        String name = "unknown";
        if (principal != null) {
            name = principal.getName();
        }
        return this.controller.deleteInstance(name, instanceId);
    }

    @RequestMapping(value={"/template/statesummaries"})
    public List<SearchStateSummaryCollection> getAllStateSummaries() {
        return this.taskManager.getAllSummaries(BaseCommand.CommandType.KNOWLEDGEBASE_SEARCH);
    }

    @RequestMapping(value={"/instancenames/{searchJobTemplateId}"})
    List<SmallDetails> getAllInstancesNamesForTemplate(@PathVariable(value="searchJobTemplateId") String searchJobTemplateId) {
        ArrayList<SmallDetails> ret = new ArrayList<SmallDetails>();
        List jps = this.taskManager.getAllInstancesForTemplate(searchJobTemplateId);
        for (TaskInstance jp : jps) {
            if (!jp.getCommandType().equals((Object)BaseCommand.CommandType.KNOWLEDGEBASE_SEARCH)) continue;
            String actionDisplay = "";
            boolean allCancelled = true;
            for (JobDeviceState state : jp.getDeviceStates()) {
                if (state.getState().isCancelled()) continue;
                allCancelled = false;
                break;
            }
            ret.add(new SmallDetails(jp.getUid(), jp.getDisplayName(), jp.getCreated(), actionDisplay, allCancelled));
        }
        return ret;
    }

    @RequestMapping(value={"/instance/{searchJobInstanceId}"})
    KnowledgeBaseSearchJobInstance getInstanceFromId(@PathVariable(value="searchJobInstanceId") String searchJobInstanceId) {
        Optional jp = this.taskManager.getTaskInstanceFromId(searchJobInstanceId);
        if (jp.isPresent()) {
            return new KnowledgeBaseSearchJobInstance((TaskInstance)jp.get(), this.endpointController, this.patternService);
        }
        return null;
    }

    @PostMapping(value={"/run"})
    public ResponseEntity<KnowledgeBaseSearchJobInstance> run(Principal principal, @RequestBody RunCommand com) {
        if (this.licenseManager.isExpired()) {
            LOG.log(System.Logger.Level.WARNING, "License expired - not running search");
            return ResponseEntity.status((HttpStatusCode)HttpStatus.NOT_ACCEPTABLE).body(null);
        }
        String name = principal.getName();
        TaskTemplate template = this.taskManager.getTemplateFromId(com.getTemplateId());
        if (template == null) {
            return new ResponseEntity(null, (HttpStatusCode)HttpStatus.NOT_FOUND);
        }
        if (com.isRunOnAllDevices()) {
            TaskInstance plan = this.jobRunner.runCommandOnAllDevices(name, template, com.getName(), com.getPriority(), false, false, com.isOverrideQuietTime());
            return new ResponseEntity((Object)new KnowledgeBaseSearchJobInstance(plan, this.endpointController, this.patternService), (HttpStatusCode)HttpStatus.OK);
        }
        TaskInstance plan = this.jobRunner.runCommandOnDevices(name, template, com.getName(), com.getPriority(), com.getDeviceIds(), false, false, com.isOverrideQuietTime());
        return new ResponseEntity((Object)new KnowledgeBaseSearchJobInstance(plan, this.endpointController, this.patternService), (HttpStatusCode)HttpStatus.OK);
    }

    @InitBinder
    public void initBinder(WebDataBinder dataBinder) {
        dataBinder.registerCustomEditor(RunCommand.class, (PropertyEditor)new /* Unavailable Anonymous Inner Class!! */);
        dataBinder.registerCustomEditor(WebSchedule.class, (PropertyEditor)new /* Unavailable Anonymous Inner Class!! */);
        dataBinder.registerCustomEditor(KnowledgeBaseSearchJobTemplate.class, (PropertyEditor)new /* Unavailable Anonymous Inner Class!! */);
        dataBinder.registerCustomEditor(KnowledgeBaseLookup.class, (PropertyEditor)new /* Unavailable Anonymous Inner Class!! */);
    }
}

