/*
 * Decompiled with CFR 0.152.
 */
package com.geolang.ascema.managerservice.rest;

import com.geolang.ascema.managerdomain.domain.TimePeriod;
import com.geolang.ascema.managerdomain.web.HeroDataRecord;
import com.geolang.ascema.managerdomain.web.HeroHeadlineNumbers;
import com.geolang.ascema.managerdomain.web.HeroRange;
import com.geolang.ascema.managerservice.controllers.DailyRecordGaps;
import com.geolang.ascema.managerservice.controllers.DailyRecordManager;
import com.geolang.ascema.managerservice.domain.DailyRecord;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.format.annotation.DateTimeFormat;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/hero"})
public class HeroRestService {
    @Autowired
    @Lazy
    private DailyRecordManager dailyRecordManager;

    @RequestMapping(value={"/first/{tp}"})
    public Date first(@PathVariable(value="tp") int tp) {
        return this.dailyRecordManager.getFirstDate(TimePeriod.values()[tp]);
    }

    @RequestMapping(value={"/last/{tp}"})
    public Date last(@PathVariable(value="tp") int tp) {
        return this.dailyRecordManager.getLastDate(TimePeriod.values()[tp]);
    }

    @RequestMapping(value={"/avaliableperiods"})
    public int[] getAvailableRanges() {
        List valid = this.dailyRecordManager.getAvailableRanges();
        int[] ret = new int[valid.size()];
        for (int i = 0; i < valid.size(); ++i) {
            ret[i] = ((TimePeriod)valid.get(i)).ordinal();
        }
        return ret;
    }

    @PostMapping(value={"/fullrange"})
    public ResponseEntity<HeroRange> getFullRanges(@RequestParam(value="tp") int tp) {
        HeroRange ret = this.dailyRecordManager.getFullRange(TimePeriod.values()[tp]);
        return new ResponseEntity((Object)ret, (HttpStatusCode)HttpStatus.OK);
    }

    @PostMapping(value={"/range"})
    public ResponseEntity<HeroRange> getRanges(@RequestParam(value="from") @DateTimeFormat(pattern="yyyy-MM-dd") Date from, @RequestParam(value="to") @DateTimeFormat(pattern="yyyy-MM-dd") Date to, @RequestParam(value="tp") int tp) {
        HeroRange ret = this.dailyRecordManager.getRange(TimePeriod.values()[tp], from, to);
        return new ResponseEntity((Object)ret, (HttpStatusCode)HttpStatus.OK);
    }

    @PostMapping(value={"/headlinenumbers"})
    public ResponseEntity<HeroHeadlineNumbers> getHeadlineNumbers(@RequestParam(value="from") @DateTimeFormat(pattern="yyyy-MM-dd") Date from, @RequestParam(value="to") @DateTimeFormat(pattern="yyyy-MM-dd") Date to, @RequestParam(value="tp") int timePeriod) {
        TimePeriod tp = TimePeriod.values()[timePeriod];
        HeroHeadlineNumbers ret = this.dailyRecordManager.getHeadlineNumbers(from, to, tp);
        return new ResponseEntity((Object)ret, (HttpStatusCode)HttpStatus.OK);
    }

    @GetMapping(value={"/updatedailyrecords"})
    public void updatedailyrecords() {
        DailyRecordGaps gaps = this.dailyRecordManager.loadFinishedDailyRecords();
        this.dailyRecordManager.processResults(Optional.of(gaps));
    }

    @PostMapping(value={"/dailyrecords"})
    public ResponseEntity<List<HeroDataRecord>> getDailyRecords(@RequestParam(value="from") @DateTimeFormat(pattern="yyyy-MM-dd") Date from, @RequestParam(value="to") @DateTimeFormat(pattern="yyyy-MM-dd") Date to, @RequestParam(value="tp") int timePeriod) {
        TimePeriod tp = TimePeriod.values()[timePeriod];
        List daily = this.dailyRecordManager.getRecordsBetween(from, to, tp);
        Collections.sort(daily);
        ArrayList<HeroDataRecord> ret = new ArrayList<HeroDataRecord>();
        for (DailyRecord d : daily) {
            ret.add(new HeroDataRecord(d, tp));
        }
        return new ResponseEntity(ret, (HttpStatusCode)HttpStatus.OK);
    }
}

