/*
 * Decompiled with CFR 0.152.
 */
package com.geolang.ascema.managerservice.rest;

import com.geolang.ascema.managerdomain.domain.FileExtension;
import com.geolang.ascema.managerdomain.web.WebFileExtension;
import com.geolang.ascema.managerpersistence.FileExtensionExistsException;
import com.geolang.ascema.managerpersistence.FileExtensionStore;
import java.beans.PropertyEditor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.WebDataBinder;
import org.springframework.web.bind.annotation.InitBinder;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/fileexts"})
public class FileExtensionRestService {
    @Autowired
    private FileExtensionStore controller;

    @RequestMapping(value={"all"})
    public List<WebFileExtension> getAll() {
        ArrayList<WebFileExtension> ret = new ArrayList<WebFileExtension>();
        for (FileExtension ex : this.controller.getExtensions()) {
            String[] arr = ex.getExtensions().toArray(new String[0]);
            ret.add(new WebFileExtension(ex.getDisplayname(), arr));
        }
        return ret;
    }

    @PostMapping(value={"/create"})
    public ResponseEntity<Boolean> create(@RequestParam(value="extension") WebFileExtension ext) {
        try {
            this.controller.createFileExtension(ext.getName(), new TreeSet<String>(Arrays.asList(ext.getExtensions())));
            return new ResponseEntity((Object)true, (HttpStatusCode)HttpStatus.OK);
        }
        catch (FileExtensionExistsException ex) {
            Logger.getLogger(FileExtensionRestService.class.getName()).log(Level.SEVERE, null, ex);
            return new ResponseEntity((Object)false, (HttpStatusCode)HttpStatus.CONFLICT);
        }
    }

    @PostMapping(value={"/update"})
    public ResponseEntity<Boolean> update(@RequestParam(value="extension") WebFileExtension ext) {
        TreeSet<String> extensions = new TreeSet<String>();
        extensions.addAll(Arrays.asList(ext.getExtensions()));
        this.controller.updateFileExtension(new FileExtension(ext.getName(), extensions));
        return new ResponseEntity((Object)true, (HttpStatusCode)HttpStatus.OK);
    }

    @PostMapping(value={"/delete"})
    public ResponseEntity<Boolean> delete(@RequestParam(value="extension") WebFileExtension ext) {
        TreeSet<String> extensions = new TreeSet<String>();
        extensions.addAll(Arrays.asList(ext.getExtensions()));
        this.controller.deleteExtension(new FileExtension(ext.getName(), extensions));
        return new ResponseEntity((Object)true, (HttpStatusCode)HttpStatus.OK);
    }

    @RequestMapping(value={"/get/{name}"})
    public ResponseEntity<WebFileExtension> getByName(@PathVariable(value="name") String name) {
        Optional extOpt = this.controller.getByName(name);
        if (extOpt.isPresent()) {
            FileExtension ext = (FileExtension)extOpt.get();
            return new ResponseEntity((Object)new WebFileExtension(ext.getDisplayname(), ext.getExtensions().toArray(new String[0])), (HttpStatusCode)HttpStatus.OK);
        }
        return new ResponseEntity(null, (HttpStatusCode)HttpStatus.NOT_FOUND);
    }

    @RequestMapping(value={"/exists/{name}"})
    public boolean exists(@PathVariable(value="name") String name) {
        return this.controller.fileExtensionNameExists(name);
    }

    @InitBinder
    public void initBinder(WebDataBinder dataBinder) {
        dataBinder.registerCustomEditor(WebFileExtension.class, (PropertyEditor)new /* Unavailable Anonymous Inner Class!! */);
    }
}

