/*
 * Decompiled with CFR 0.152.
 */
package com.geolang.ascema.managerservice.rest;

import com.geolang.ascema.endpointcommon.domain.AlertMsg;
import com.geolang.ascema.endpointcommon.domain.DeviceType;
import com.geolang.ascema.endpointcommon.messages.servernotification.ServerUIDetails;
import com.geolang.ascema.managercore.MessageBus;
import com.geolang.ascema.managercore.settings.SettingsFile;
import com.geolang.ascema.managerdomain.domain.DeviceRegistration;
import com.geolang.ascema.managerdomain.domain.QuietTimeConfiguration;
import com.geolang.ascema.managerdomain.web.Device;
import com.geolang.ascema.managerdomain.web.DevicePickerPreset;
import com.geolang.ascema.managerdomain.web.WebAgentDiagnosticData;
import com.geolang.ascema.managerdomain.web.WebQuietTime;
import com.geolang.ascema.managerdomain.web.WebQuietTimeConfiguration;
import com.geolang.ascema.managerevents.DeviceLogAvailableEvent;
import com.geolang.ascema.managerservice.controllers.AlertingController;
import com.geolang.ascema.managerservice.controllers.ProxySettings;
import com.geolang.ascema.managerservice.controllers.devices.DeviceCounts;
import com.geolang.ascema.managerservice.controllers.devices.DeviceService;
import com.geolang.ascema.managerservice.license.LicenseManager;
import com.geolang.ascema.managerservice.messaging.serverserver.MasterEnd;
import com.geolang.ascema.managerservice.rest.CompletableManager;
import com.geolang.ascema.managerservice.rest.NamedCompletableCollection;
import com.google.common.eventbus.Subscribe;
import jakarta.annotation.PostConstruct;
import jakarta.annotation.PreDestroy;
import java.beans.PropertyEditor;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.scheduling.annotation.Async;
import org.springframework.web.bind.WebDataBinder;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.InitBinder;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/devices"})
public class DevicesRestService {
    @Autowired
    private DeviceService controller;
    @Autowired
    private LicenseManager licMgr;
    @Autowired
    private MasterEnd master;
    @Autowired
    AlertingController alertingController;
    @Autowired
    private CompletableManager completeMgr;
    private NamedCompletableCollection<String, String> deviceToFuture;

    @PostConstruct
    public void afterPropertiesSet() throws Exception {
        this.deviceToFuture = this.completeMgr.newNamedCollection();
        MessageBus.getBus().register((Object)this);
    }

    @PreDestroy
    public void destroy() throws Exception {
        MessageBus.getBus().unregister((Object)this);
    }

    @Subscribe
    public void handleDeviceLogReceived(DeviceLogAvailableEvent ev) {
        this.deviceToFuture.completeIfContains((Object)ev.getDeviceId(), (Object)ev.getLog());
    }

    @RequestMapping(value={"all"})
    public List<Device> getAllDevices() {
        ArrayList<Device> ret = new ArrayList<Device>();
        for (DeviceRegistration reg : this.controller.getAllDevices(false)) {
            ret.add(Device.buildFromDeviceReg((DeviceRegistration)reg));
        }
        Collections.sort(ret);
        return ret;
    }

    @RequestMapping(value={"/types/{types}/{connectedonly}"})
    public List<Device> getAllDevicesOfTypes(@PathVariable(value="types") int types, @PathVariable(value="connectedonly") boolean connectedonly) {
        List<DeviceType> deviceTypes = new ArrayList();
        if (DevicePickerPreset.contains((DevicePickerPreset)DevicePickerPreset.All_DEVICES_PICKER, (int)types) || DevicePickerPreset.contains((DevicePickerPreset)DevicePickerPreset.LIST_ALL_DEVICES, (int)types)) {
            deviceTypes = DeviceType.getAllTypes();
        } else {
            if (DevicePickerPreset.contains((DevicePickerPreset)DevicePickerPreset.ALFRESCO_PICKER, (int)types)) {
                deviceTypes.add(DeviceType.ALFRESCO);
            }
            if (DevicePickerPreset.contains((DevicePickerPreset)DevicePickerPreset.EP_AND_FS_PICKER, (int)types)) {
                deviceTypes.add(DeviceType.ENDPOINT);
                deviceTypes.add(DeviceType.FILESERVER);
            }
            if (DevicePickerPreset.contains((DevicePickerPreset)DevicePickerPreset.O365_PICKER, (int)types)) {
                deviceTypes.add(DeviceType.O365);
            }
            if (DevicePickerPreset.contains((DevicePickerPreset)DevicePickerPreset.ATLASSIAN_PICKER, (int)types)) {
                deviceTypes.add(DeviceType.ATLASSIAN);
            }
            if (DevicePickerPreset.contains((DevicePickerPreset)DevicePickerPreset.GOOGLE_PICKER, (int)types)) {
                deviceTypes.add(DeviceType.GOOGLE);
            }
        }
        ArrayList<Device> ret = new ArrayList<Device>();
        for (DeviceRegistration reg : this.controller.getDevicesOfTypes(deviceTypes)) {
            if (connectedonly) {
                if (!reg.isConnected()) continue;
                ret.add(Device.buildFromDeviceReg((DeviceRegistration)reg));
                continue;
            }
            ret.add(Device.buildFromDeviceReg((DeviceRegistration)reg));
        }
        Collections.sort(ret);
        return ret;
    }

    @RequestMapping(value={"/alfresco/{connectedonly}"})
    public List<Device> getAlfrescoDevices(@PathVariable(value="connectedonly") boolean connectedonly) {
        return this.getDevicesByType(DeviceType.ALFRESCO, connectedonly);
    }

    @RequestMapping(value={"/atlassian/{connectedonly}"})
    public List<Device> getAtlassianDevices(@PathVariable(value="connectedonly") boolean connectedonly) {
        return this.getDevicesByType(DeviceType.ATLASSIAN, connectedonly);
    }

    @RequestMapping(value={"/o365/{connectedonly}"})
    public List<Device> getO365Devices(@PathVariable(value="connectedonly") boolean connectedonly) {
        return this.getDevicesByType(DeviceType.O365, connectedonly);
    }

    @RequestMapping(value={"/google/{connectedonly}"})
    public List<Device> getGoogleDevices(@PathVariable(value="connectedonly") boolean connectedonly) {
        return this.getDevicesByType(DeviceType.GOOGLE, connectedonly);
    }

    private List<Device> getDevicesByType(DeviceType type, boolean connectedonly) {
        ArrayList<Device> ret = new ArrayList<Device>();
        for (DeviceRegistration reg : this.controller.getDevicesOfType(type)) {
            if (connectedonly) {
                if (!reg.isConnected()) continue;
                ret.add(Device.buildFromDeviceReg((DeviceRegistration)reg));
                continue;
            }
            ret.add(Device.buildFromDeviceReg((DeviceRegistration)reg));
        }
        Collections.sort(ret);
        return ret;
    }

    @RequestMapping(value={"/endpointandfileserver/{connectedonly}"})
    public List<Device> getEndpointAndFileserverDevices(@PathVariable(value="connectedonly") boolean connectedonly) {
        ArrayList<Device> ret = new ArrayList<Device>();
        List devices = this.controller.getDevicesOfType(DeviceType.ENDPOINT);
        devices.addAll(this.controller.getDevicesOfType(DeviceType.FILESERVER));
        for (DeviceRegistration reg : devices) {
            if (connectedonly) {
                if (!reg.isConnected()) continue;
                ret.add(Device.buildFromDeviceReg((DeviceRegistration)reg));
                continue;
            }
            ret.add(Device.buildFromDeviceReg((DeviceRegistration)reg));
        }
        Collections.sort(ret);
        return ret;
    }

    @RequestMapping(value={"/counts"})
    public DeviceCounts getCounts() {
        return new DeviceCounts(this.controller, this.licMgr, this.master);
    }

    @RequestMapping(value={"/diagnostics/{deviceId}"})
    public WebAgentDiagnosticData getDiagnosticsData(@PathVariable(value="deviceId") String deviceId) {
        return this.controller.getAgentDiagnosticData(deviceId);
    }

    @RequestMapping(value={"/allow/{deviceId}"})
    public boolean allowDevice(Principal principal, @PathVariable(value="deviceId") String deviceId) {
        String name = "unknown";
        if (principal != null) {
            name = principal.getName();
        }
        return this.controller.allowAccess(name, deviceId);
    }

    @RequestMapping(value={"/block/{deviceId}"})
    public boolean blockDevice(Principal principal, @PathVariable(value="deviceId") String deviceId) {
        String name = "unknown";
        if (principal != null) {
            name = principal.getName();
        }
        return this.controller.denyAccess(name, deviceId);
    }

    @RequestMapping(value={"/delete/{deviceId}"})
    public boolean deleteDevice(Principal principal, @PathVariable(value="deviceId") String deviceId) {
        String name = "unknown";
        if (principal != null) {
            name = principal.getName();
        }
        return this.controller.deleteDevice(name, deviceId);
    }

    @RequestMapping(value={"/device/{deviceId}"})
    public ResponseEntity<Device> getDeviceById(@PathVariable(value="deviceId") String deviceId) {
        Optional reg = this.controller.getDeviceFromId(deviceId, true);
        if (reg.isPresent()) {
            return new ResponseEntity((Object)Device.buildFromDeviceReg((DeviceRegistration)((DeviceRegistration)reg.get())), (HttpStatusCode)HttpStatus.OK);
        }
        return ResponseEntity.status((HttpStatusCode)HttpStatus.NOT_FOUND).body(null);
    }

    @PostMapping(value={"/devices"})
    public ResponseEntity<List<Device>> getDevicesFromIds(@RequestParam(value="deviceIds") List<String> deviceIds) {
        ArrayList<Device> ret = new ArrayList<Device>();
        for (String devId : deviceIds) {
            Optional reg = this.controller.getDeviceFromId(devId, true);
            if (!reg.isPresent()) continue;
            ret.add(Device.buildFromDeviceReg((DeviceRegistration)((DeviceRegistration)reg.get())));
        }
        return new ResponseEntity(ret, (HttpStatusCode)HttpStatus.OK);
    }

    @PostMapping(value={"/devicesdb"})
    public List<Device> getDevicesFromDbUrl(@RequestParam(value="url") String url) {
        ArrayList<Device> ret = new ArrayList<Device>();
        for (DeviceRegistration reg : this.controller.getAllDevices(false)) {
            if (!reg.getDBDriverCollection().mightAcceptURL(url)) continue;
            ret.add(Device.buildFromDeviceReg((DeviceRegistration)reg));
        }
        Collections.sort(ret);
        return ret;
    }

    @PatchMapping(value={"/email/{deviceId}"})
    public boolean setEmail(@PathVariable(value="deviceId") String deviceId, @RequestParam(value="email") String email) {
        try {
            this.controller.setEmailOnDevice(deviceId, URLDecoder.decode(email, "UTF-8"));
            return true;
        }
        catch (UnsupportedEncodingException ex) {
            Logger.getLogger(DevicesRestService.class.getName()).log(Level.SEVERE, null, ex);
            return false;
        }
    }

    @PatchMapping(value={"/devicefollownetwork/{deviceId}"})
    public boolean setDeviceFollowNetworkShares(Principal principal, @PathVariable(value="deviceId") String deviceId, @RequestParam(value="follow") Boolean follow) {
        String name = "unknown";
        if (principal != null) {
            name = principal.getName();
        }
        this.controller.setFollowNetworkShares(name, deviceId, follow.booleanValue());
        return true;
    }

    @PostMapping(value={"/alertmultiple"})
    public boolean alertMultiple(@RequestParam(value="deviceIds") List<String> deviceIds, @RequestParam(value="alert") AlertMsg alert) {
        this.alertingController.alertMultipleEndpoint(deviceIds, alert);
        return true;
    }

    @PostMapping(value={"/alert/{deviceId}"})
    public boolean alert(@PathVariable(value="deviceId") String deviceId, @RequestParam(value="alert") AlertMsg alert, @RequestParam(value="link") String link) {
        ServerUIDetails uidetails = ProxySettings.getUIDetails((String)deviceId);
        this.alertingController.alertEndpoint(deviceId, alert, uidetails);
        return true;
    }

    @PostMapping(value={"/setgroups"})
    public boolean setGroups(@RequestParam(value="deviceId") String deviceId, @RequestParam(value="groups") String[] groups) {
        return this.controller.setTags(deviceId, groups);
    }

    @PostMapping(value={"/setdisplayname"})
    public boolean setDisplayName(@RequestParam(value="deviceId") String deviceId, @RequestParam(value="displayname") String displayname) {
        return this.controller.setDisplayName(deviceId, displayname);
    }

    @GetMapping(value={"/getallgroups"})
    public Set<String> getAllGroups() {
        HashSet<String> ret = new HashSet<String>();
        for (DeviceRegistration dr : this.controller.getAllDevices(false)) {
            ret.addAll(Arrays.asList(dr.getTags()));
        }
        return ret;
    }

    @PostMapping(value={"/setquiet"})
    public boolean setQuietTimes(@RequestParam(value="deviceId") String deviceId, @RequestParam(value="quiettime") WebQuietTimeConfiguration config) {
        QuietTimeConfiguration qt = config.toConfig();
        return this.controller.setQuietTimes(deviceId, qt);
    }

    @PostMapping(value={"/unsetquiet"})
    public boolean unSetQuietTimes(@RequestParam(value="deviceId") String deviceId) {
        return this.controller.unSetQuietTimes(deviceId);
    }

    @PostMapping(value={"/checkquiet"})
    public boolean checkQuietNow(@RequestParam(value="all") boolean all, @RequestParam(value="deviceIds") List<String> deviceIds) {
        return this.controller.checkDeviceQuietNow(all, deviceIds);
    }

    @PostMapping(value={"/defaultalert"})
    public void setDefaultAlert(@RequestParam(value="alertstring") AlertMsg alert) {
        SettingsFile.getInstance().setDefaultAlertTitle(alert.getTitle());
        SettingsFile.getInstance().setDefaultAlertBody(alert.getBody());
    }

    @GetMapping(value={"/defaultalert"})
    public ResponseEntity<AlertMsg> getDefaultAlertString() {
        String title = SettingsFile.getInstance().getDefaultAlertTitle();
        String body = SettingsFile.getInstance().getDefaultAlertBody();
        return ResponseEntity.status((HttpStatusCode)HttpStatus.OK).body((Object)new AlertMsg(title, body));
    }

    @Async
    @RequestMapping(value={"/log/{deviceId}"})
    public CompletableFuture<String> getLog(@PathVariable(value="deviceId") String deviceId) throws InterruptedException {
        this.controller.getLog(deviceId);
        return this.deviceToFuture.putOrUpdate((Object)deviceId, 30);
    }

    @InitBinder
    public void initBinder(WebDataBinder dataBinder) {
        dataBinder.registerCustomEditor(AlertMsg.class, (PropertyEditor)new /* Unavailable Anonymous Inner Class!! */);
        dataBinder.registerCustomEditor(WebQuietTime.class, (PropertyEditor)new /* Unavailable Anonymous Inner Class!! */);
        dataBinder.registerCustomEditor(WebQuietTimeConfiguration.class, (PropertyEditor)new /* Unavailable Anonymous Inner Class!! */);
    }
}

