/*
 * Decompiled with CFR 0.152.
 */
package com.geolang.ascema.managerservice.rest;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.geolang.ascema.endpointcommon.database.DatabaseCredentials;
import com.geolang.ascema.endpointcommon.domain.BaseCommand;
import com.geolang.ascema.endpointcommon.domain.searchconfig.DBQuery;
import com.geolang.ascema.indexingcommon.endpoint.cloudcommon.ConnectionStatus;
import com.geolang.ascema.managercore.MessageBus;
import com.geolang.ascema.managerdomain.datapoint.DBDataPointColumns;
import com.geolang.ascema.managerdomain.datapoint.DBDataSliceRequest;
import com.geolang.ascema.managerdomain.datapoint.DBTopLevelResults;
import com.geolang.ascema.managerdomain.domain.DatabaseCredentialStored;
import com.geolang.ascema.managerdomain.domain.DatabaseResultColumns;
import com.geolang.ascema.managerdomain.domain.JobDeviceState;
import com.geolang.ascema.managerdomain.domain.TaskInstance;
import com.geolang.ascema.managerdomain.domain.TaskTemplate;
import com.geolang.ascema.managerdomain.dto.DTOPatternCount;
import com.geolang.ascema.managerdomain.web.DatabaseSearchFilter;
import com.geolang.ascema.managerdomain.web.ExportFormat;
import com.geolang.ascema.managerdomain.web.RunCommand;
import com.geolang.ascema.managerdomain.web.SearchStateSummaryCollection;
import com.geolang.ascema.managerdomain.web.SmallDetails;
import com.geolang.ascema.managerdomain.web.WebDatabaseQueryTestResults;
import com.geolang.ascema.managerdomain.web.WebRDSCredentials;
import com.geolang.ascema.managerdomain.web.WebSavedDatabaseCredentials;
import com.geolang.ascema.managerdomain.web.WebSchedule;
import com.geolang.ascema.managerevents.ConnectionStatusEvent;
import com.geolang.ascema.managerevents.DBTestResultsEvent;
import com.geolang.ascema.managerpersistence.results.DBResultsPage;
import com.geolang.ascema.managerservice.controllers.DatabaseSearchController;
import com.geolang.ascema.managerservice.controllers.results.export.ExportController;
import com.geolang.ascema.managerservice.controllers.tasks.TaskManager;
import com.geolang.ascema.managerservice.license.LicenseManager;
import com.geolang.ascema.managerservice.rest.CloudCredentailsRestService;
import com.geolang.ascema.managerservice.rest.CompletableManager;
import com.geolang.ascema.managerservice.rest.NamedCompletableCollection;
import com.geolang.ascema.managerservice.rest.ResultsRestService;
import com.geolang.ascema.managerservice.rest.requests.alfresco.WebConnectionStatus;
import com.geolang.ascema.managerservice.rest.requests.tasks.DatabaseSearchJobInstance;
import com.geolang.ascema.managerservice.rest.requests.tasks.DatabaseSearchJobTemplate;
import com.google.common.eventbus.Subscribe;
import jakarta.annotation.PostConstruct;
import jakarta.annotation.PreDestroy;
import java.beans.PropertyEditor;
import java.io.File;
import java.io.IOException;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.lang3.tuple.ImmutableTriple;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.FileSystemResource;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.scheduling.annotation.Async;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.web.bind.WebDataBinder;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.InitBinder;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/dbsearch"})
public class DatabaseSearchService {
    private static final Logger LOG = Logger.getLogger(DatabaseSearchService.class.getName());
    @Autowired
    private TaskManager taskManager;
    @Autowired
    private LicenseManager licenseManager;
    @Autowired
    private DatabaseSearchController dbController;
    @Autowired
    private CompletableManager completeMgr;
    @Autowired
    private ExportController exportController;
    private NamedCompletableCollection<String, WebConnectionStatus> deviceToFuture;
    private NamedCompletableCollection<String, WebDatabaseQueryTestResults> queryResultsFutures;

    @PostConstruct
    public void afterPropertiesSet() throws Exception {
        this.deviceToFuture = this.completeMgr.newNamedCollection();
        this.queryResultsFutures = this.completeMgr.newNamedCollection();
        MessageBus.getBus().register((Object)this);
    }

    @PreDestroy
    public void destroy() throws Exception {
        MessageBus.getBus().unregister((Object)this);
    }

    @PostMapping(value={"/export"})
    public ResponseEntity<FileSystemResource> downloadExportFile(Principal principal, @RequestParam(value="taskInstanceId") String taskInstanceId, @RequestParam(value="format") int format, @RequestParam(value="pwd") String pwd, @RequestParam(value="dec") boolean decryptResults, @RequestParam(value="ignore") boolean showIgnore, @RequestParam(value="confidence") int minConfidence) {
        if (principal == null) {
            LOG.warning("No user in export");
            return ResponseEntity.status((HttpStatusCode)HttpStatus.FORBIDDEN).body(null);
        }
        ExportFormat formatType = ExportFormat.values()[format];
        try {
            File f;
            Authentication auth;
            boolean canDecrypt = false;
            if (decryptResults && (auth = SecurityContextHolder.getContext().getAuthentication()) != null && auth.getAuthorities().stream().anyMatch(a -> a.getAuthority().equals("ROLE_AUDITOR"))) {
                canDecrypt = true;
            }
            if ((f = this.exportController.getDbExport(principal.getName(), taskInstanceId, formatType, pwd, canDecrypt, showIgnore, minConfidence)) != null) {
                FileSystemResource body = new FileSystemResource(f);
                return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().header("Content-Disposition", new String[]{f.getName()})).body((Object)body);
            }
        }
        catch (IOException ex) {
            Logger.getLogger(ResultsRestService.class.getName()).log(Level.SEVERE, null, ex);
        }
        return ResponseEntity.status((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR).body(null);
    }

    @RequestMapping(value={"/resultstop/{taskInstanceId}/{confidence}/{showignored}"})
    public ResponseEntity<DBTopLevelResults> getTopLevelResults(@PathVariable(value="taskInstanceId") String taskInstanceId, @PathVariable(value="confidence") int minConfidence, @PathVariable(value="showignored") boolean showIgnored) {
        List res = this.dbController.getTopLevels(taskInstanceId, minConfidence, showIgnored);
        return ResponseEntity.ok((Object)new DBTopLevelResults(taskInstanceId, res));
    }

    @PostMapping(value={"/results"})
    public ResponseEntity<DBResultsPage> getPaginatedResults(@RequestParam(value="filter") DBDataSliceRequest filter) {
        PageRequest pageable = PageRequest.of((int)filter.getPage(), (int)filter.getSize());
        DBResultsPage res = this.dbController.getPageOfResults((Pageable)pageable, filter);
        return ResponseEntity.ok((Object)res);
    }

    @GetMapping(value={"/unredact/{id}"})
    public String unredact(@PathVariable(value="id") Long id) {
        Optional retOpt = this.dbController.unRedactMatch(id);
        if (retOpt.isEmpty()) {
            return null;
        }
        return (String)retOpt.get();
    }

    @RequestMapping(value={"/columns/{taskInstanceId}"})
    public ResponseEntity<DBDataPointColumns> getColumns(@PathVariable(value="taskInstanceId") String taskInstanceId) {
        Optional opt = this.dbController.getColumnsForSearch(taskInstanceId);
        if (opt.isEmpty()) {
            return ResponseEntity.status((HttpStatusCode)HttpStatus.NOT_FOUND).body(null);
        }
        return new ResponseEntity((Object)new DBDataPointColumns((DatabaseResultColumns)opt.get()), (HttpStatusCode)HttpStatus.OK);
    }

    @RequestMapping(value={"/templates"})
    public List<DatabaseSearchJobTemplate> getAllTemplates() {
        return this.dbController.getAllTemplates();
    }

    @RequestMapping(value={"/template/{id}"})
    public DatabaseSearchJobTemplate getTemplate(@PathVariable(value="id") String templateId) {
        return this.dbController.getTemplate(templateId);
    }

    @RequestMapping(value={"/templates/ids"})
    public List<SmallDetails> getAllTemplatesIds() {
        ArrayList<SmallDetails> ret = new ArrayList<SmallDetails>();
        for (ImmutableTriple t : this.taskManager.getAllSearchTemplatesIdsOfType(BaseCommand.CommandType.DATABASE_SEARCH)) {
            ret.add(new SmallDetails((String)t.left, (String)t.middle, (Date)t.right, "", false));
        }
        return ret;
    }

    @RequestMapping(value={"/template/statesummaries"})
    public List<SearchStateSummaryCollection> getAllStateSummaries() {
        return this.taskManager.getAllSummaries(BaseCommand.CommandType.DATABASE_SEARCH);
    }

    @PostMapping(value={"/template/add"})
    public ResponseEntity<DatabaseSearchJobTemplate> add(Principal principal, @RequestBody DatabaseSearchJobTemplate s) {
        if (this.licenseManager.isExpired()) {
            LOG.warning("License expired - not creating search");
            return ResponseEntity.status((HttpStatusCode)HttpStatus.NOT_ACCEPTABLE).body(null);
        }
        String name = "unknown";
        if (principal != null) {
            name = principal.getName();
        }
        if (this.taskManager.templateExists(s.getName())) {
            return ResponseEntity.status((HttpStatusCode)HttpStatus.CONFLICT).body(null);
        }
        if (!TaskManager.isValidTemplateName((String)s.getName())) {
            LOG.log(Level.WARNING, "not valid name {0}", s.getName());
            return ResponseEntity.status((HttpStatusCode)HttpStatus.NOT_ACCEPTABLE).body(null);
        }
        DatabaseSearchJobTemplate t = this.dbController.addTemplate(name, s);
        return new ResponseEntity((Object)t, (HttpStatusCode)HttpStatus.OK);
    }

    @RequestMapping(value={"/instances/{searchJobTemplateId}"})
    public List<DatabaseSearchJobInstance> getAllInstancesForTemplate(@PathVariable(value="searchJobTemplateId") String searchJobTemplateId) {
        return this.dbController.getAllInstancesForTemplate(searchJobTemplateId);
    }

    @RequestMapping(value={"/instancenames/{searchJobTemplateId}"})
    public List<SmallDetails> getAllInstancesNamesForTemplate(@PathVariable(value="searchJobTemplateId") String searchJobTemplateId) {
        ArrayList<SmallDetails> ret = new ArrayList<SmallDetails>();
        List jps = this.taskManager.getAllInstancesForTemplate(searchJobTemplateId);
        for (TaskInstance jp : jps) {
            if (!jp.getCommandType().equals((Object)BaseCommand.CommandType.DATABASE_SEARCH)) continue;
            String actionDisplay = "";
            boolean allCancelled = true;
            for (JobDeviceState state : jp.getDeviceStates()) {
                if (state.getState().isCancelled()) continue;
                allCancelled = false;
                break;
            }
            ret.add(new SmallDetails(jp.getUid(), jp.getDisplayName(), jp.getCreated(), actionDisplay, allCancelled));
        }
        return ret;
    }

    @RequestMapping(value={"/instance/{searchJobInstanceId}"})
    public ResponseEntity<DatabaseSearchJobInstance> getInstanceFromId(@PathVariable(value="searchJobInstanceId") String searchJobInstanceId) {
        DatabaseSearchJobInstance ret = this.dbController.getInstanceFromId(searchJobInstanceId);
        if (ret == null) {
            return new ResponseEntity((HttpStatusCode)HttpStatus.NOT_FOUND);
        }
        return new ResponseEntity((Object)ret, (HttpStatusCode)HttpStatus.OK);
    }

    @PostMapping(value={"/run"})
    public ResponseEntity<DatabaseSearchJobInstance> run(Principal principal, @RequestBody RunCommand com) {
        TaskTemplate template;
        if (this.licenseManager.isExpired()) {
            LOG.warning("License expired - not running search");
            return ResponseEntity.status((HttpStatusCode)HttpStatus.NOT_ACCEPTABLE).body(null);
        }
        String name = "unknown";
        if (principal != null) {
            name = principal.getName();
        }
        if ((template = this.taskManager.getTemplateFromId(com.getTemplateId())) == null) {
            return new ResponseEntity(null, (HttpStatusCode)HttpStatus.NOT_FOUND);
        }
        DatabaseSearchJobInstance plan = this.dbController.createTaskInstance(name, template, com);
        return new ResponseEntity((Object)plan, (HttpStatusCode)HttpStatus.OK);
    }

    @RequestMapping(value={"/instance/{searchJobInstanceId}/patterntotals"})
    ResponseEntity<List<DTOPatternCount>> getPatternTotals(@PathVariable(value="searchJobInstanceId") String searchJobInstanceId) {
        List counts = this.dbController.getPatternCountsForTaskId(searchJobInstanceId);
        return new ResponseEntity((Object)counts, (HttpStatusCode)HttpStatus.OK);
    }

    @PostMapping(value={"/testcredentialsfromjson/{deviceId}"})
    public boolean testCredentialsFromJson(@PathVariable(value="deviceId") String deviceId, @RequestParam(value="encjson") String json) {
        try {
            DatabaseCredentials cc = DatabaseCredentials.fromJSON((String)json);
            return this.dbController.testCredentials(deviceId, cc);
        }
        catch (JsonProcessingException ex) {
            Logger.getLogger(CloudCredentailsRestService.class.getName()).log(Level.SEVERE, null, ex);
            return false;
        }
    }

    @PostMapping(value={"/testcredentials/{deviceId}"})
    public String testCredentials(@PathVariable(value="deviceId") String deviceId, @RequestParam(value="url") String url, @RequestParam(value="user") String user, @RequestParam(value="pwd") String pwd) {
        DatabaseCredentials dc = new DatabaseCredentials(url, user, pwd);
        this.dbController.testCredentials(deviceId, dc);
        return dc.toJSON();
    }

    @PostMapping(value={"/testrdscredentials/{deviceId}"})
    public String testRDSCredentials(@PathVariable(value="deviceId") String deviceId, @RequestParam(value="url") String url, @RequestParam(value="creds") WebRDSCredentials creds) {
        DatabaseCredentials dc = new DatabaseCredentials(url, creds.toRDSCredentials());
        this.dbController.testCredentials(deviceId, dc);
        return dc.toJSON();
    }

    @PostMapping(value={"/testupdatedcredentials/{deviceId}"})
    public String testUpdatedCredentials(@PathVariable(value="deviceId") String deviceId, @RequestParam(value="url") String url, @RequestParam(value="user") String user, @RequestParam(value="pwd") String pwd, @RequestParam(value="encjson") String json) {
        try {
            DatabaseCredentials dc = DatabaseCredentials.fromJSON((String)json);
            dc = dc.update(url, user, pwd);
            this.dbController.testCredentials(deviceId, dc);
            return dc.toJSON();
        }
        catch (JsonProcessingException ex) {
            Logger.getLogger(DatabaseSearchService.class.getName()).log(Level.SEVERE, null, ex);
            return "";
        }
    }

    @PostMapping(value={"/testupdatedrdscredentials/{deviceId}"})
    public String testUpdatedRDSCredentials(@PathVariable(value="deviceId") String deviceId, @RequestParam(value="url") String url, @RequestParam(value="creds") WebRDSCredentials creds, @RequestParam(value="encjson") String json) {
        try {
            DatabaseCredentials dc = DatabaseCredentials.fromJSON((String)json);
            dc = dc.update(url, creds.toRDSCredentials());
            this.dbController.testCredentials(deviceId, dc);
            return dc.toJSON();
        }
        catch (JsonProcessingException ex) {
            Logger.getLogger(DatabaseSearchService.class.getName()).log(Level.SEVERE, null, ex);
            return "";
        }
    }

    @PostMapping(value={"/save"})
    public boolean save(Principal principal, @RequestParam(value="name") String displayname, @RequestParam(value="encjson") String json) {
        try {
            DatabaseCredentials cc;
            DatabaseCredentialStored stored;
            String name = "unknown";
            if (principal != null) {
                name = principal.getName();
            }
            return (stored = this.dbController.saveCredentials(name, displayname, cc = DatabaseCredentials.fromJSON((String)json))) != null;
        }
        catch (JsonProcessingException ex) {
            Logger.getLogger(DatabaseSearchService.class.getName()).log(Level.SEVERE, null, ex);
            return false;
        }
    }

    @PostMapping(value={"/replace"})
    public boolean replace(Principal principal, @RequestParam(value="oldname") String oldisplayname, @RequestParam(value="name") String displayname, @RequestParam(value="encjson") String json) {
        try {
            DatabaseCredentials cc;
            DatabaseCredentialStored stored;
            String name = "unknown";
            if (principal != null) {
                name = principal.getName();
            }
            return (stored = this.dbController.editCredentials(name, oldisplayname, displayname, cc = DatabaseCredentials.fromJSON((String)json))) != null;
        }
        catch (JsonProcessingException ex) {
            Logger.getLogger(DatabaseSearchService.class.getName()).log(Level.SEVERE, null, ex);
            return false;
        }
    }

    @PostMapping(value={"/setqueries"})
    public ResponseEntity<WebSavedDatabaseCredentials> setqueries(Principal principal, @RequestParam(value="name") String displayname, @RequestParam(value="queries") DBQuery[] queries) {
        WebSavedDatabaseCredentials stored;
        String name = "unknown";
        if (principal != null) {
            name = principal.getName();
        }
        if ((stored = this.dbController.setQueriesOnCredentials(name, displayname, queries)) != null) {
            return new ResponseEntity((Object)stored, (HttpStatusCode)HttpStatus.OK);
        }
        return new ResponseEntity((HttpStatusCode)HttpStatus.NOT_FOUND);
    }

    @PostMapping(value={"/delete"})
    public boolean delete(@RequestParam(value="name") String name) {
        return this.dbController.deleteCredentials(name);
    }

    @PostMapping(value={"/exists"})
    public boolean exists(@RequestParam(value="name") String name) {
        return this.dbController.credentialsExistsByName(name);
    }

    @RequestMapping(value={"/allsaved"})
    public List<WebSavedDatabaseCredentials> getAllSaved() {
        return this.dbController.getAllSaved();
    }

    @Async
    @PostMapping(value={"/status"})
    public CompletableFuture<WebConnectionStatus> getStatus(@RequestParam(value="deviceId") String deviceId) throws InterruptedException {
        return this.deviceToFuture.putOrUpdate((Object)deviceId, 30);
    }

    @Subscribe
    public void handleStatusChange(ConnectionStatusEvent ev) {
        if (ev.getStatus().isIsDatabase()) {
            LOG.log(Level.INFO, "status for db {0} is {1}", new Object[]{ev.getDeviceId(), ev.getStatus()});
            String deviceId = ev.getDeviceId();
            this.deviceToFuture.completeIfContains((Object)deviceId, (Object)WebConnectionStatus.fromConnectionStatus((ConnectionStatus)ev.getStatus()));
        }
    }

    @PostMapping(value={"/testquery/{deviceId}"})
    public boolean testQuery(@PathVariable(value="deviceId") String deviceId, @RequestParam(value="encjson") String creds, @RequestParam(value="queryName") String queryName, @RequestParam(value="queryValue") String queryvalue) {
        try {
            DatabaseCredentials dc = DatabaseCredentials.fromJSON((String)creds);
            return this.dbController.testQuery(deviceId, dc, new DBQuery(queryvalue, queryName));
        }
        catch (JsonProcessingException ex) {
            Logger.getLogger(DatabaseSearchService.class.getName()).log(Level.SEVERE, null, ex);
            return false;
        }
    }

    @Async
    @PostMapping(value={"/statusquery"})
    public CompletableFuture<WebDatabaseQueryTestResults> getStatusForQuery(@RequestParam(value="deviceId") String deviceId) throws InterruptedException {
        return this.queryResultsFutures.putOrUpdate((Object)deviceId, 30);
    }

    @Subscribe
    public void handleQueryStatusChange(DBTestResultsEvent ev) {
        LOG.log(Level.INFO, "db status for db {0} is {1}", new Object[]{ev.getDeviceId(), ev.getStatus().isIsSuccess()});
        String deviceId = ev.getDeviceId();
        this.queryResultsFutures.completeIfContains((Object)deviceId, (Object)new WebDatabaseQueryTestResults(ev.getStatus(), deviceId));
    }

    @InitBinder
    public void initBinder(WebDataBinder dataBinder) {
        dataBinder.registerCustomEditor(RunCommand.class, (PropertyEditor)new /* Unavailable Anonymous Inner Class!! */);
        dataBinder.registerCustomEditor(DBQuery[].class, (PropertyEditor)new /* Unavailable Anonymous Inner Class!! */);
        dataBinder.registerCustomEditor(DatabaseSearchFilter.class, (PropertyEditor)new /* Unavailable Anonymous Inner Class!! */);
        dataBinder.registerCustomEditor(WebSchedule.class, (PropertyEditor)new /* Unavailable Anonymous Inner Class!! */);
        dataBinder.registerCustomEditor(DatabaseSearchJobTemplate.class, (PropertyEditor)new /* Unavailable Anonymous Inner Class!! */);
        dataBinder.registerCustomEditor(DatabaseSearchJobInstance.class, (PropertyEditor)new /* Unavailable Anonymous Inner Class!! */);
        dataBinder.registerCustomEditor(DBDataSliceRequest.class, (PropertyEditor)new /* Unavailable Anonymous Inner Class!! */);
        dataBinder.registerCustomEditor(WebRDSCredentials.class, (PropertyEditor)new /* Unavailable Anonymous Inner Class!! */);
    }
}

