/*
 * Decompiled with CFR 0.152.
 */
package com.geolang.ascema.managerservice.rest;

import java.util.Arrays;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public class DataValidation {
    private static final String[] reservedWords = new String[]{"CON", "PRN", "AUX", "NUL", "COM1", "COM2", "COM3", "COM4", "COM5", "COM6", "COM7", "COM8", "COM9", "LPT1", "LPT2", "LPT3", "LPT4", "LPT5", "LPT6", "LPT7", "LPT8", "LP"};
    private static String[] csvPrefixes = new String[]{"=", "+", "-", "@", "\t", "\n", "\r", "|"};
    private static String[] escapers = new String[]{",", ";", "'", "\""};
    private static Pattern[] patterns = new Pattern[]{Pattern.compile("<script>(.*?)</script>", 2), Pattern.compile("src[\\s]*=(.*?)'(.*?)'", 42), Pattern.compile("src[\\s]*=(.*?)\"(.*?)\"", 42), Pattern.compile("</script>", 2), Pattern.compile("<script(.*?)>", 42), Pattern.compile("eval\\((.*?)\\)", 42), Pattern.compile("expression\\((.*?)\\)", 42), Pattern.compile("javascript:", 2), Pattern.compile("vbscript:", 2), Pattern.compile("onload(.*?)=", 42)};

    public static boolean isValidNameForFilesystem(String name) {
        if (name.length() >= 256) {
            return false;
        }
        List<String> list = Arrays.asList(reservedWords);
        boolean regexOK = name.matches("[\\w -]++");
        if (regexOK) {
            return !list.contains(name.toUpperCase());
        }
        return false;
    }

    public static boolean containsCSVInjectionPayload(String in) {
        if (DataValidation.startsWithCsvInjectionSymbol((String)in)) {
            return true;
        }
        return StringUtils.containsAny((CharSequence)in, (CharSequence[])csvPrefixes) && StringUtils.containsAny((CharSequence)in, (CharSequence[])escapers);
    }

    public static boolean startsWithCsvInjectionSymbol(String in) {
        return StringUtils.startsWithAny((CharSequence)in, (CharSequence[])csvPrefixes);
    }

    public static String stripXSS(String value) {
        if (value != null) {
            value = value.replaceAll("\u0000", "");
            for (Pattern scriptPattern : patterns) {
                value = scriptPattern.matcher(value).replaceAll("");
            }
        }
        return value;
    }
}

