/*
 * Decompiled with CFR 0.152.
 */
package com.geolang.ascema.managerservice.rest;

import com.geolang.ascema.managerservice.rest.TimedCompletableFuture;
import java.util.ArrayList;
import java.util.concurrent.CopyOnWriteArrayList;

public class CompletableCollection<T> {
    private final CopyOnWriteArrayList<TimedCompletableFuture<T>> waiting;
    private final T emptyValue;

    CompletableCollection(T empty) {
        this.emptyValue = empty;
        this.waiting = new CopyOnWriteArrayList();
    }

    public synchronized void checkExpired() {
        ArrayList<TimedCompletableFuture> expired = new ArrayList<TimedCompletableFuture>();
        for (TimedCompletableFuture res : this.waiting) {
            if (!res.expired()) continue;
            expired.add(res);
            res.getFuture().complete(this.emptyValue);
        }
        this.waiting.removeAll(expired);
    }

    synchronized void completeAll(T message) {
        for (TimedCompletableFuture res : this.waiting) {
            res.getFuture().complete(message);
        }
        this.waiting.clear();
    }

    synchronized void add(TimedCompletableFuture<T> f) {
        this.waiting.add(f);
    }

    synchronized boolean hasWaiting() {
        return !this.waiting.isEmpty();
    }
}

