/*
 * Decompiled with CFR 0.152.
 */
package com.geolang.ascema.managerservice.rest;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.geolang.ascema.endpointcommon.domain.DeviceType;
import com.geolang.ascema.endpointcommon.domain.PlatformSubType;
import com.geolang.ascema.indexingcommon.endpoint.cloudcommon.CloudCredentials;
import com.geolang.ascema.indexingcommon.endpoint.cloudcommon.ConnectionStatus;
import com.geolang.ascema.managercore.MessageBus;
import com.geolang.ascema.managerdomain.domain.CloudCredentialStored;
import com.geolang.ascema.managerdomain.web.WebSavedCredentials;
import com.geolang.ascema.managerevents.ConnectionStatusEvent;
import com.geolang.ascema.managerevents.ConnectionStatusMultipleEvent;
import com.geolang.ascema.managerpersistence.CloudCredentialsStore;
import com.geolang.ascema.managerservice.controllers.devices.DeviceService;
import com.geolang.ascema.managerservice.rest.CloudCredentailsRestService;
import com.geolang.ascema.managerservice.rest.CompletableManager;
import com.geolang.ascema.managerservice.rest.GoogleRestService;
import com.geolang.ascema.managerservice.rest.NamedCompletableCollection;
import com.geolang.ascema.managerservice.rest.requests.alfresco.WebConnectionStatus;
import com.google.common.eventbus.Subscribe;
import jakarta.annotation.PostConstruct;
import jakarta.annotation.PreDestroy;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.security.Principal;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Async;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/api/cloudcredentials"})
public class CloudCredentailsRestService {
    private static final Logger LOG = Logger.getLogger(CloudCredentailsRestService.class.getName());
    @Autowired
    private DeviceService controller;
    @Autowired
    private CloudCredentialsStore ccStore;
    @Autowired
    private CompletableManager completeMgr;
    private NamedCompletableCollection<String, WebConnectionStatus> deviceToFuture;
    private NamedCompletableCollection<String, List<WebConnectionStatus>> deviceToFutureMultiple;

    @PostConstruct
    public void afterPropertiesSet() throws Exception {
        this.deviceToFuture = this.completeMgr.newNamedCollection();
        this.deviceToFutureMultiple = this.completeMgr.newNamedCollection();
        MessageBus.getBus().register((Object)this);
    }

    @PreDestroy
    public void destroy() throws Exception {
        MessageBus.getBus().unregister((Object)this);
    }

    @Subscribe
    public void handleStatusChange(ConnectionStatusEvent ev) {
        if (!ev.getStatus().isIsDatabase()) {
            LOG.log(Level.INFO, "status for {0} is {1}", new Object[]{ev.getDeviceId(), ev.getStatus()});
            String deviceId = ev.getDeviceId();
            this.deviceToFuture.completeIfContains((Object)deviceId, (Object)WebConnectionStatus.fromConnectionStatus((ConnectionStatus)ev.getStatus()));
        }
    }

    @Subscribe
    public void handleStatusChange(ConnectionStatusMultipleEvent ev) {
        String deviceId = ev.getDeviceId();
        LOG.log(Level.INFO, "status for {0} is {1}", new Object[]{deviceId, ev.getStatuses()});
        ArrayList<WebConnectionStatus> ret = new ArrayList<WebConnectionStatus>();
        for (ConnectionStatus cs : ev.getStatuses()) {
            ret.add(WebConnectionStatus.fromConnectionStatus((ConnectionStatus)cs));
        }
        this.deviceToFutureMultiple.completeIfContains((Object)deviceId, ret);
    }

    @Async
    @PostMapping(value={"/status"})
    public CompletableFuture<WebConnectionStatus> getStatus(@RequestParam(value="deviceId") String deviceId) throws InterruptedException {
        return this.deviceToFuture.putOrUpdate((Object)deviceId, 30);
    }

    @Async
    @PostMapping(value={"/statusmultiple"})
    public CompletableFuture<List<WebConnectionStatus>> getStatusMultiple(@RequestParam(value="deviceId") String deviceId) throws InterruptedException {
        return this.deviceToFutureMultiple.putOrUpdate((Object)deviceId, 30);
    }

    @RequestMapping(value={"/checkconnection/{deviceId}/{deviceType}"})
    public boolean checkConnection(@PathVariable(value="deviceId") String deviceId, @PathVariable(value="deviceType") int deviceType) {
        DeviceType type = DeviceType.values()[deviceType];
        return this.controller.checkCloudConnection(deviceId, type);
    }

    @PostMapping(value={"/setcredentialsfromjson/{deviceId}"})
    public boolean setCredentialsFromJson(Principal principal, @PathVariable(value="deviceId") String deviceId, @RequestParam(value="encjson") String json, @RequestParam(value="type") Integer type) {
        try {
            String name = "unknown";
            if (principal != null) {
                name = principal.getName();
            }
            DeviceType dt = DeviceType.values()[type];
            return this.controller.setCloudCredentialsAndDeviceType(name, deviceId, json, dt);
        }
        catch (JsonProcessingException ex) {
            Logger.getLogger(CloudCredentailsRestService.class.getName()).log(Level.SEVERE, null, ex);
            return false;
        }
    }

    @PostMapping(value={"/testcredentialsfromjson/{deviceId}"})
    public boolean testCredentialsFromJson(@PathVariable(value="deviceId") String deviceId, @RequestParam(value="encjson") String json) {
        try {
            CloudCredentials cc = CloudCredentials.fromJSON((String)json);
            return this.controller.testCloudCredentials(deviceId, cc);
        }
        catch (JsonProcessingException ex) {
            Logger.getLogger(CloudCredentailsRestService.class.getName()).log(Level.SEVERE, null, ex);
            return false;
        }
    }

    @PostMapping(value={"/testsimplecredentials/{deviceType}/{deviceId}"})
    public String testSimpleCredentials(@PathVariable(value="deviceType") int deviceType, @PathVariable(value="deviceId") String deviceId, @RequestParam(value="host") String host, @RequestParam(value="user") String user, @RequestParam(value="pwd") String pwd) {
        DeviceType type = DeviceType.values()[deviceType];
        CloudCredentials cc = CloudCredentials.createSimple((DeviceType)type, (String)host.trim(), (String)user.trim(), (String)pwd.trim());
        if (cc != null) {
            this.controller.testCloudCredentials(deviceId, cc);
            return cc.toJSON();
        }
        return "";
    }

    @PostMapping(value={"/testcredentialsatlassian/{deviceId}"})
    public String testCredentialsForAtlassian(@PathVariable(value="deviceId") String deviceId, @RequestParam(value="host") String host, @RequestParam(value="user") String user, @RequestParam(value="pwd") String pwd, @RequestParam(value="subtypes") Integer[] subtypes, @RequestParam(value="isCloud") boolean cloud) {
        CloudCredentials cc;
        HashSet<PlatformSubType> subs = new HashSet<PlatformSubType>();
        if (subtypes != null) {
            Integer[] integerArray = subtypes;
            int n = integerArray.length;
            for (int i = 0; i < n; ++i) {
                int i2 = integerArray[i];
                subs.add(PlatformSubType.values()[i2]);
            }
        }
        if ((cc = CloudCredentials.createForAtlassian((String)host.trim(), (String)user.trim(), (String)pwd.trim(), subs, (boolean)cloud)) != null) {
            this.controller.testCloudCredentials(deviceId, cc);
            return cc.toJSON();
        }
        return "";
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @PostMapping(value={"/testcredentialsgoogle/{deviceId}"})
    public String testCredentialsForGoogle(@PathVariable(value="deviceId") String deviceId, @RequestParam(value="host") String host, @RequestParam(value="user") String user, @RequestParam(value="pwd") String pwd, @RequestParam(value="file") MultipartFile jsonfile) {
        try (InputStream is = jsonfile.getInputStream();){
            1 byteSource = new /* Unavailable Anonymous Inner Class!! */;
            String pk = byteSource.asCharSource(StandardCharsets.UTF_8).read();
            CloudCredentials cc = CloudCredentials.createForGoogle((String)host.trim(), (String)user.trim(), (String)pwd.trim(), (String)pk);
            if (cc == null) return "";
            this.controller.testCloudCredentials(deviceId, cc);
            String string = cc.toJSON();
            return string;
        }
        catch (IOException ex) {
            Logger.getLogger(GoogleRestService.class.getName()).log(Level.SEVERE, null, ex);
        }
        return "";
    }

    @PostMapping(value={"/save"})
    public boolean save(Principal principal, @RequestParam(value="name") String displayname, @RequestParam(value="encjson") String json) {
        try {
            String name = "unknown";
            if (principal != null) {
                name = principal.getName();
            }
            CloudCredentials cc = CloudCredentials.fromJSON((String)json);
            cc.setDisplayName(displayname);
            CloudCredentialStored stored = new CloudCredentialStored(displayname, cc, name);
            stored = this.ccStore.addOrReplace(stored);
            return stored != null;
        }
        catch (JsonProcessingException ex) {
            Logger.getLogger(CloudCredentailsRestService.class.getName()).log(Level.SEVERE, null, ex);
            return false;
        }
    }

    @PostMapping(value={"/delete"})
    public boolean delete(@RequestParam(value="name") String name) {
        return this.ccStore.deleteByName(name);
    }

    @PostMapping(value={"/exists"})
    public boolean exists(@RequestParam(value="name") String name) {
        return this.ccStore.existsByName(name);
    }

    @RequestMapping(value={"/allsaved"})
    public List<WebSavedCredentials> getAllSaved() {
        ArrayList<WebSavedCredentials> ret = new ArrayList<WebSavedCredentials>();
        for (CloudCredentialStored stored : this.ccStore.getAll()) {
            boolean inUse = this.controller.deviceIsUsingCredentails(stored.jsonCredentialsString());
            ret.add(new WebSavedCredentials(stored, inUse));
        }
        return ret;
    }

    @RequestMapping(value={"/savedbytype/{deviceType}"})
    public List<WebSavedCredentials> getByType(@PathVariable(value="deviceType") int deviceType) {
        DeviceType type = DeviceType.values()[deviceType];
        ArrayList<WebSavedCredentials> ret = new ArrayList<WebSavedCredentials>();
        for (CloudCredentialStored stored : this.ccStore.getAll()) {
            if (!stored.getDeviceType().equals((Object)type)) continue;
            boolean inUse = this.controller.deviceIsUsingCredentails(stored.jsonCredentialsString());
            ret.add(new WebSavedCredentials(stored, inUse));
        }
        return ret;
    }
}

